import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentControl {

    public static void sendTo(DocumentCanvas D,String S) {
	try{
          D.setExplain(S);
          D.repaint();   
	  D.Y0=0;
          D.Y1=0;
	}
	catch(Exception e) {}
    }


    public static void display(DocumentCanvas D) {
	String S="picture display";

	S=S+"\n\nThis control panel toggles the main displays on the picture window.  There are 8 options. You can read more about each one by clicking on the question box next to the item.  If you want to turn a feature on or off, click the square to the left of the feature name.";

	sendTo(D,S);
    }


    public static void mapGuides(DocumentCanvas D) {
	String S="map construction";

	S=S+"\n\nThe anti-farpoint map AF, meaning the composition of the farthest point map F with the antipodal map A, is a birational map. It also has a geometric interpretation.  This feature gives a straight line construction which implements the map.  If you rapidly turn this feature off and on, while keeping the map feature on, you can see how the map construction relates to the map.";
	sendTo(D,S);
    }



    public static void spider(DocumentCanvas D) {
	String S="spider";

	S=S+"\n\nGiven a point p on the central triangle of the octahedron, there are 6 geodesics (in the flat cone metric) which reach around and connect that point to F(p), the far point w.r.t. p.  Generally speaking, 3 of these geodesics will have precisely the same length and the other 3 will be longer.  When you have this option on, you can see the 6 geodesic segments.  You will also see a circle (C) which has the radius of the distance between p and F(p).  Three of the geodesic segments end on the boundary of C and the other 3 extend beyond it.  The three short geodesics are colored in a bold way.  These geodesics all point to a vertex of the cut locus w.r.t. the point p.";

	S=S+"\n\nIf you drag the mouse around the inner triangle you can see how the triple of short geodesics makes transitions as you cross the boundaries of the domains of definition (DD) for AF.  If you want to watch a nice animation, push the GO button at the bottom right of this control panel. This will automatically move p along a cardioid-like loop which visits all the regions.  You can watch how the spider moves around along the path.  You should turn on the cut locus and voronoi images features for a better appreciation of what the spider is doing.";

	sendTo(D,S);
    }



    public static void voronoi(DocumentCanvas D) {
	String S="voronoi construction";

	S=S+"\n\nThis feature shows the building block of the (unfolded) cut locus.  There are 6 isometries whic take each of the outer triangles to a given one.  We choose the initial point p in the fundamental domain and then consider the points p0,p1,p2,p3,p4,p5 which are the images of p under the isometries.  (One of the isometries is the identity, so that p=p0.) These 6 points make a convex hexagon.  We take the Voronoi decomposition with respect to the vertices of these points and then interesect it with the given outer triangle.  This produces a tiling of the outer triangle.  This tiling is the basic building block.";

	S=S+"\n\nThis feature is meant work in tandem with the green arrows that appear when you turn on this feature. The green arrows let you select the outer triangle of your choice.  In the paper, we use choice 0.  This is the default choice.  It is worth looking once at each of the 6 options and then setting the choice to 0 for good.";
	sendTo(D,S);
    }


    public static void cutLocus(DocumentCanvas D) {
	String S="cut locus";
	S=S+"\n\nThe map \u03C8 from the octahedral plan to the octahedron is not injective. Once the point p in the central domain is chosen, we say that a point q in the octahedral plan is good if we have |p-q|<|p-q'| for any point q' such that \u03C8(q)=\u03C8(q').  The set U(p) is the set of these good points.  The set C(p) is the boundary of U(p).  The set C(p) is the preimage under \u03C8 of the cut locus on the regular octahedron with respect to p. This feature shows the cut locus.   To best appreciate how the cut locus is constructed, you should draw it with a semi-transparent color and also turn on the Voronoi images feature."; 


	sendTo(D,S);
    }



    public static void voronoiImages(DocumentCanvas D) {
	String S="voronoi images";

	S=S+"\n\nThis option shows the basic voronoi region moved around the octahedral plan, from a single outer triangle to all of them.  We also show the corresponding picture in the 6 triangles adjecent to these outer triangles.  So, all in all, 12 triangles are partitioned.  You should turn on the cut locus feature to appreciate what this tiling has to do with the cut locus.";
	sendTo(D,S);
    }


    public static void bary(DocumentCanvas D) {	

        String S="barycentric subdivision";

	S=S+"\n\nThis shows the barycentric subdivision of the central triangle.  AF chances when you cross the edges of the barycentric subdivision.  Also, AF preserves a piecewise straight-line foliation which is parallel in each piece to one of the 3 segments displayed here.";

	sendTo(D,S);

    }


    public static void curves(DocumentCanvas D) {

        String S="J curve";	

	S=S+"\n\n This shows the curve J which comprise the set where AF is not uniquely defined. Together, these curves and the first barycentric subdivision define the 12 DDs, domains of rationality, for AF.";

	S=S+"\n\nIf you drag the mouse over one of these curves while the spider feature is on, you can see how one of the legs of the spider changes at the crossing. At the moment of crossing, a certain pair of distances are equal.  I found the formula for these algebraic curves by computing the relevant distances and setting them equal to each other.  If you are curious, you can see the formulas and construction of these curves in the class MapFormula.java.";

	S=S+"\n\nFor convenience, I'll give the formula for one of the curves. For this description to work, the picture should be rotated so that the left side of the central triangle is vertical.  This is to say that the vertices of the central triangle are the 3 cube roots of unity. The curve I have in mind touches the x-axis to the right of the origin and rises upwards until hitting a vertex.  This curve turns out to be the (very steep) graph of a function.  So, I am going to describe a certain function y=f(x) defined on a certain interval [a,b] where\n\na=0.239123..., the positive solution of 1-4a=a^2-a^3.\n\nb=0.25, the solution of 1-4b=0.";

	S=S+"\n\nLet Q[...] denote the cube root function.  In the equation to follow, the argument of Q is non-negative real and we take the branch of Q which is non-negative real.  The formula is\n\nf(x)=(1/\u221A3)(1-x-Q[(2+x)(5-2x)(1-4x)])";
	S=S+"\n\nWhy does this crazy curve come up in connection with a canonical operation defined on one of the platonic solids?  I have no good explanation for this except that those are the facts.  But, by zooming really far into the picture and passing back and forth over the curve and watching the construction change, you can see that I've got the curves right.";

	sendTo(D,S);
    }

    public static void map(DocumentCanvas D) {

        String S="map";
	S=S+"\n\nThis shows the basic map.  What is plotted here is the chosen point p, and the image AF(p), and the line segment connecting them.  Note that this line segment is always parallel to one of the 3 segments in the barycentric subdivision of the central triangle.  This is a manifestation of the AF-invariant straight line foliation.";

	sendTo(D,S);
    }


    public static void dev(DocumentCanvas D) {
	String S="triangle choice";

	S=S+"\n\nThis feature works in tandem with the Voronoi construction feature.  It allows you to choose the outer triangle in the plan on which you want to base the construction. The canonical choice is 0.";
	
	sendTo(D,S);
    }



    public static void web(DocumentCanvas D) {
	String S="web study";

	S=S+"\n\n These keys let you select each of the 12 web rays. Each web ray emanates from a vertex (Q) of the triangular lattice.  The position of the web ray is a function of p in the following way:  An auxiliary green segment joins p to some other vertex (q) of the triangulation. Independent of p, There exists a triangulation-respecting isometry mapping q to Q that carries the green segment to the web ray.  This structure lets one determine the formula for the ray.\n\nYou can best appreciate this feature if you turn off the guides, spider, and map features and then drag the point around the central triangle. Watch how the green and white rays move. Note that they always move at the same angular speed.";


	S=S+"\n\nThe construction of the web favors one of the 6 colorful triangles, but you can change the favorite by using the green arrow keys.  For each web ray there are 2 choices of favorites in which the green segment is parallel to the web ray.  This happens when the value (g) on the green arrow keys and the value (b) on the blue arrow keys satisfies g=b mod 6 or g=(b+3) mod 6.";

       sendTo(D,S);
    }



    public static void popup(DocumentCanvas D) {
	String S="popup windows";

	S=S+"\n\n All the main windows in the program are in the form of popups. You bring forth these windows by clicking on the buttons below.   You kill the windows in the usual way that you kill windows on your computer.  On the mac, this amounts to clicking on the red x in the upper left corner.  After you kill a window, you can re-create it by clicking on the button again.\n\nYou can go through the kill/create cycle as many times as you like.  If you happen to bring up the same window twice the controls might get messed up. It is best to kill both copies and then create a new one.";

	S=S+"\n\nThe popup windows are also resizeable. You (probably) resize them by dragging the mouse from the lower right corner of the window.";

       sendTo(D,S);
    }


    public static void animate(DocumentCanvas D) {
	String S="animation";

	S=S+"\n\n I thought it would be fun to animate this program. Press go to see the animation and press stop to stop the animation. After you animate it, you might have fun turning on the spider display and then zooming in one one of the colorful triangles in the picture window.  This will give you a nice display of a voronoi vertex taking a ride on the cut locus.  The animation causes the choice of point on the central triangle to make a loop. The loop is some kind of cardioid which I thought would make a nice picture.";

	S=S+"\n\nThere is one bug with the animation that I fixed in an inelegant way.  When the animation ran initially, the spider drawing routine tends to flicker.  For some reason the computation of the lengths of the geodesics does not interact so well with the multi-threading. I fixed this by making less stringent the error tolerance for the lengths of these geodesics when the animation is on.  The reader can see this by inspecting the code for the drawSpider routine in the PictureCanvas class.";

       sendTo(D,S);
    }


    public static void key(DocumentCanvas D) {
	String S="key commands";

	S=S+"\n\nThe picture and remote control windows are designed to work best with a 3 button mouse.  However, if you don't have a 3-button mouse, you can use the keyboard to simulate a 3-button mouse.  Here are the commands:";

	S=S+"\n\nbutton-1 (scale up) use key q or key i.";
	S=S+"\n\nbutton-2 (select point) use key w or key o";
	S=S+"\n\nbutton-3 (scale dpwn) use key e or key p.";
	S=S+"\n\nThe idea here is that there are active keys q,w,e on left and active keys i,o,p on the right.";
	S=S+"\n\nYou can also simulate the drag feature of the mouse by holding in keys w or o and then moving the mouse around over the central triangle.\n\nFor all these features, you probably will need to click in the indended window (to activate it) before the key commands will work.";

       sendTo(D,S);
    }



    public static void closeup(DocumentCanvas D) {
	String S="closeup display";


	    S=S+"\n\nThe remote control window gives you a second way to choose a point in the central triangle.  I made the closeup window because sometimes you want to look very closely at what is going on in the central triangle but then zooming in will send the rest of the picture out of view.  When the closeup window is open you can control the initial point remotely from that window.  The point on the picture window then copies what you do in the closeup window.";

	    S=S+"\n\nThe closeup window has some of the same options for display as the main picture window.  You can read about these options by clicking on the ?-boxes next to the items on the picture display control panel.";

	sendTo(D,S);
    }




}


