import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/


public class DocumentIntro {

    public DocumentIntro() {}


    public static void setup(DocumentCanvas D) {
    
	String S="Main (and Auxiliary) Calculations";
        S=S+"\nby Rich Schwartz";


	S=S+"\n\nPURPOSE:";
        S=S+"\n\nThe purpose of this program is to do numerical simulations with the main and auxiliary calculations from my paper about the optimal Moebius band.  This text will explain the operation of the program.  There is more text than fits on the screen.  You can drag the text down with the mouse. You can also reset the position of text or change the font size using the controls at the top of this window. ";

	S=S+"\n\nMOUSE:";
	S=S+"\n\nThis program is best run using a 3 button mouse.  The control panel (the one with all the buttons) just requires a 1 button mouse and occasionally the keyboard.  The other windows use the 3 buttons.  In general, a left and right click will scale the picture about the click point and a middle point will select a new source point on the window.  I have added in keyboard shortcuts in case you do not have a 3 button mouse.  The keys z,x,c, simulate the 3 kinds of clicks.  In general, you have to click on a window in order to activate the keyboard shortcuts";

	S=S+"\n\nOVERVIEW";
	S=S+"\n\nThis program has 5 windows. Here is their description:";
	S=S+"\n\nText window.  This is what you are reading.";
	S=S+"\n\nControl Window.  This is the teal window.  This window allows you to choose the calculation you are doing, and modify the calculation and display in various ways.";
	S=S+"\n\nTensegrity window:  This window draws a planar projection of the tensegrity image. (Atcually, at the moment, we are only considering planar tensegrities.  The reasons for this (besides laziness) are explained in chapter 6 of the paper.";
	S=S+"\n\ntrapezoid window: This window reconstructs the minimal tensegrity corresponding to the tensegrity image shown in the space window.  This window is not visible when you launch the program. You need to click the `trap.' button on the control window to launch it.";
	S=S+"\n\nselector window: This shows a picture of the trapezoid from Statement 3 of THeorem 3.1 in the paper.  This trapezoid shows the range of allowable slopes for the top and bottom edges of the trapezoid shown in the trapezoid window.";
	S=S+"\n\nConcerning the popup windows, you should not bring up the same window twice. This will cause neither to work.  If you do this accidentally, kill both of them and bring up a new one.  This should fix it.";
	S=S+"\n\nYou can rescale all the windows except the control panel.";

	S=S+"\n\nMAIN OPERATIONS:";
	S=S+"\n\nThe 'calcs' menu on the control window lets you select which of the calculations you want to do. Once you select a calculation, press go to run it and stop to stop it. These calculations are listed in the same order that they are listed in the paper.  There are various ways that you can modify the calculations or the display, as I now explain.";

S=S+"\n\n1. capacity options.  The reduced capacity is a simpler version of the capacity function which ignores the diagonals of the tensegrity.  I think that all the main calculations, and certainly all the auxiliary calculations, still work with the reduced capacity.  The presumed advantage of using the reduced capacity is that it would be easier to make such calculations rigorous.  Anyway, I was curious about using a simpler calculation.";

S=S+"\n\n2. display options.  You can toggle the display of various various features shown on the space window. You can also recolor them.   On the `display' panel, the left column of buttons controls the color and the right column controls whether the corresponding object is shown or not.  To recolor things, first choose a color on the color selector, then press one of the left buttons.";

S=S+"MANUAL OPERATIONS";

S=S+"\n\nSome of the controls on the window are present for the purposes of debugging.  These are grouped together in the magenta cluster on the control window.";

S=S+"\n\nSigns: When one of the calculations is running, the trapezoid window reconstructs and displays the minimal (planar) aspect ratio trapezoid based on the tensegrity image contained in the tensegrity window. When one of the main calculations is not running, you can move points around in the tensegrity window to create your own.  The trapezoid is reconstructed based on various distances between points and some choices of auxiliary signs.  The point is that the lengths determine the slopes up to sign, but to get the sign you have to make a choice.  You can see this in action by opening up the trapezoid window and toggling the signs.";


S=S+"\n\n bend pitches.  When one of the calculations is running, the bend pitches are determined automatically.  When the calculations are not running, you can specify these bend pitches using the two fields which say `bend pitch'.  These control the bend pitches of the two middle bends.  Once you modify these values, you need to drag points around in the tensegrity window to see the change.  This is something that you just need to play with to see how it works.";

S=S+"\n\nguide points:  If you turn on the guide points option on the display, you will see more clearly where you should click/drag to move the tensegrity around. Again, you just have to play around with the controls to see what they do.";

        D.setExplain(S);
        D.repaint();   
	D.Y0=0;
        D.Y1=0;
    }
}

