import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of complex numbers */

public class DyadicCube {
    int DIM;
    double[][] X=new double[10][2];
    int[] age=new int[10];


    public DyadicCube(int n) {
	DIM=n;
	for(int i=0;i<DIM;++i) {
	    X[i][0]=0;
	    X[i][1]=1;
	}
    }

    public DyadicCube(DyadicCube C) {
	DIM=C.DIM;
	for(int i=0;i<C.DIM;++i) {
	    X[i][0]=C.X[i][0];
	    X[i][1]=C.X[i][1];
	    age[i]=C.age[i];
	}
    }

    public double[] center() {
	double[] r=new double[DIM];
        for(int i=0;i<DIM;++i) r[i]=(X[i][0]+X[i][1])/2;
	return r;
    }

    public DyadicCube sub0() {
	int k= lowestDrop(age,DIM);
	return sub0(k);
    }
    
    public DyadicCube sub1() {
	int k= lowestDrop(age,DIM);
	return sub1(k);
    }
    

    public DyadicCube sub0(int k) {
	DyadicCube C=new DyadicCube(this);
	C.X[k][0]=C.X[k][0];
	C.X[k][1]=(C.X[k][0]+C.X[k][1])/2;
	++C.age[k];
	return C;
    }
	

    public DyadicCube sub1(int k) {
	DyadicCube C=new DyadicCube(this);
	C.X[k][0]=(C.X[k][0]+C.X[k][1])/2;
	C.X[k][1]=C.X[k][1];
	++C.age[k];
	return C;
    }


    public static int lowestDrop(int[] a,int N) {
	for(int i=0;i<N-1;++i) {
	    if(a[i+1]<a[i]) return i+1;
	}
	return 0;
    }


    public double volume() {
	int tot=0;
	for(int i=0;i<DIM;++i) tot=tot+age[i];
	return Math.pow(.5,tot);
    }
    
    public double perimeter() {
	double tot=0;
	double[] weight={1,1,1,1.0/18,1.0/4,1,1,1,1,1};
	for(int i=0;i<DIM;++i) tot=tot+weight[i]*Math.pow(.5,age[i]);
	return 4*tot;
    }

    public void print() {
	for(int i=0;i<DIM;++i) {
	    System.out.println(age[i]+" "+"["+X[i][0]+"    "+X[i][1]+"]");
	}
    }

}


