import java.awt.event.*;
import java.awt.*;

public class EnhancedSlider {
    int x,y,w,h;
    int ACTIVE;
    SelectInteger POW;
    ListenSquare RESET;
    double POS;
    Color C;
    String S;
    
    EnhancedSlider(int x,int y,int w,int h,double POS,Color C,String s) {
        this.x=x;
        this.y=y;
        this.h=h;
        this.w=w;
        this.POS=POS;
        this.C=C;
	this.S=s;
	this.POW=new SelectInteger(x+w,y,50,h,0,-20,20,1);
	this.RESET=new ListenSquare(x+w+50,y,19,h);this.RESET.on=1;
        ACTIVE=0;
    }

    void render(Graphics g) {
        g.setColor(C);
        g.fillRect(x,y,w,h);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.setColor(Color.white);
	Double D=new Double(getValue());
	String S2=S+" "+D.toString();
	g.drawString(S2,x+5,y+h-5);
	g.setColor(Color.black);
	if(ACTIVE==1) g.setColor(Color.white);
        g.drawRect(x,y,w,h);
	POW.render(g,C,new Color(0,0,0,0),new Color(0,0,0,0));
	RESET.render(g,C);
        g.setColor(Color.white);
	int p=(int)(POS);
        g.fillRect(p-1,y+1,2,h-2); 
        g.drawRect(p-1,y+1,2,h-2); 

    }

    void configure(Point p) {
	configure(p,false);
    }


    void configure(Point p,boolean drag) {
        if((ACTIVE==1)&&(p.x<x+w)&&(p.x>x)) POS=p.x;
	if(drag==false) {
	      POW.modify(p);
	}
	if(RESET.inside(p)==1) POS=this.w/2;
    }

    void activate(Point p) {
	ACTIVE=0;
	if(inside(p)==1) ACTIVE=1;
    }
    
    int inside(Point p) {
        int test=0;
        if((p.x>x)&&(p.x<x+w+50)&&(p.y>y)&&(p.y<y+h)) test=1;
        return(test);
    }

    public double getValue() {
	double t1=1.0*this.POS/this.w;
	double t2=Math.pow(2,POW.val);
	return t1*t2;
    }
    
    public double getValueSigned() {
	double t1=1.0*this.POS/this.w;
	double t2=Math.pow(2,POW.val);
	return t1*t2-t2/2;
    }

    public void forceValue(double t) {
	double a=Math.log(t)/Math.log(2);
	Double A=new Double(a);
	int b=A.intValue();
	POW.val=b+1;
	double c=t/Math.pow(2,b+1);
	POS=w*c;
    }
    
    public void forceValueSimple(double t) {
	POW.val=1;
	double c=t/2;
	POS=w*c;
    }
    
}
