import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] TEN=new Complex[10];
    double[] A=new double[5];

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(50,550,260);
     }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTens(g);
   }

    

    public void drawTens(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	int[][] A=M.C.loopOrder();
	int[] B=M.C.divider();
	TEN=Tensegrity.tensegrity(A,M.S.Z,M.C.LEVEL.mode);

	double cap=Complex.dist(TEN[0],TEN[8])+Complex.dist(TEN[1],TEN[9]);
	cap=cap-2*Math.sqrt(3);
	Double CAP=new Double(cap);
	g.setColor(Color.blue);
	g.drawString(CAP.toString(),5,20);


	Complex[] T0={TEN[0],TEN[1],TEN[B[1]],TEN[B[0]]};
	PolygonWrapper X=new PolygonWrapper(4,T0);
	p=X.toPath();
	p=transform(p);
	g.setColor(Color.yellow);
	g.fill(p);

	Complex[] T1={TEN[B[0]],TEN[B[1]],TEN[9],TEN[8]};
	X=new PolygonWrapper(4,T1);
	p=X.toPath();
	p=transform(p);
	g.setColor(new Color(200,200,255));
	g.fill(p);
	
	for(int i=0;i<5;++i) {
	    p.reset();
	    p.moveTo(TEN[2*i+0].x,TEN[2*i+0].y);
	    p.lineTo(TEN[2*i+1].x,TEN[2*i+1].y);
	    p=transform(p);
	    g.setColor(M.C.DISPLAY.M[2+i].C);
	    g.draw(p);
	}

	for(int i=0;i<4;++i) {
	    p.reset();
	    p.moveTo(TEN[2*i+0].x,TEN[2*i+0].y);
	    p.lineTo(TEN[2*i+2].x,TEN[2*i+2].y);
	    p.moveTo(TEN[2*i+1].x,TEN[2*i+1].y);
	    p.lineTo(TEN[2*i+3].x,TEN[2*i+3].y);
	    p=transform(p);
	    g.setColor(M.C.DISPLAY.M[7].C);
	    if(i==3) g.setColor(M.C.DISPLAY.M[8].C);
	    g.draw(p);
	}

    }

    
    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) SOURCE=unTransform(J.X);
	SOURCE.print();
	repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
     }


}

