import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SpaceCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] Z=new Complex[8];

     public SpaceCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(360,250,300);
	 double t=5*Math.PI/12;
	 Z=initExample();
     }


    public Complex[] initExample() {
	Complex[] W=new Complex[8];
	double m=1/Math.sqrt(3);
	 W[0]=new Complex(0,0);
	 W[1]=new Complex(-1,0);

	 W[2]=new Complex(0,Math.tan(Math.PI/12));
	 W[3]=new Complex(-1,0);

	 W[4]=new Complex(0,m);
	 W[5]=new Complex(-.5,-m/2);

	 W[6]=new Complex(0,m);
	 W[7]=new Complex(0,-m);

	 return W;
    }

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawTensegrity(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
    }

    public void drawSegment(Graphics2D g,Complex a,Complex b,Color C) {
	drawSegment(g,a,b,C,1);
    }
    
    public void drawSegment(Graphics2D g,Complex a,Complex b,Color C,int thick) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(a.x,a.y);
	p.lineTo(b.x,b.y);
	p=transform(p);
	g.setColor(C);
	g.setStroke(new BasicStroke(thick));
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }

    public void drawTensegrity(Graphics2D g) {
	drawBendImages(g);
	drawCycle(g);
	drawPointGuides(g);
    }

    
    public void drawBendImages(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	fillPoint(g,new Complex(0,0),.003,Color.yellow,32);
	   for(int i=0;i<4;++i) {
	       if(M.C.DISPLAY.L[i+2].on==1) {
                   drawSegment(g,Z[2*i],Z[2*i+1],M.C.DISPLAY.M[i+2].C);
		   Complex z=Complex.plus(Z[2*i],Z[2*i+1]);
		   z=z.scale(.5);
	       }
	   }
    }

    public void drawPointGuides(Graphics2D g) {
	if(M.C.DISPLAY.L[8].on==0) return;
	Color C=M.C.DISPLAY.M[8].C;
	Path2D.Double p=new Path2D.Double();
	fillPoint(g,new Complex(0,0),.003,Color.yellow,32);
	   for(int i=0;i<4;++i) {
	       if(M.C.DISPLAY.L[i+2].on==1) {
		   Complex z=Complex.plus(Z[2*i],Z[2*i+1]);
		   z=z.scale(.5);
		   fillPoint(g,z,.01,C,32);
		   fillPoint(g,Z[2*i+1],.01,C,32);
	       }
	   }
    }


    


    public void drawCycle(Graphics2D g) {
	if(M.C.DISPLAY.L[7].on==0) return;
	Color COL=M.C.DISPLAY.M[7].C;
	int mode=M.C.STUDY.mode;
	int[][] A=M.C.loopOrderShort();
        drawSegments(g,A,COL);
    }
    
    public void drawSegments(Graphics2D g,int[][] A,Color C) {
	for(int i=0;i<A.length;++i) {
	    drawSegments(g,A[i],C);
	}
    }

    public void drawSegments(Graphics2D g,int[] A,Color C) {
	for(int i=0;i<A.length-1;++i) {
	    drawSegment(g,Z[A[i]],Z[A[i+1]],C);
	}
    }

    

    public void setPoint() {
	double t=5*Math.PI/12;
	int index=-1;
	double dist=100;

	for(int i=0;i<8;++i) {
	  double test=Complex.dist(SOURCE,Z[i]);
	  if(test<dist) {
	     index=i;
	     dist=test;
	  }
	}

	for(int i=1;i<4;++i) {
	    Complex w=Complex.plus(Z[2*i],Z[2*i+1]);
	    w=w.scale(.5);
	    double test=Complex.dist(SOURCE,w);
	    if(test<dist) {
		dist=test;
		index=10+i;
	    }
	}


	if(index>8) {
	    int i=index-10;
            Complex w=Complex.plus(Z[2*i],Z[2*i+1]);
	    w=w.scale(.5);
	    w=Complex.minus(SOURCE,w);
	    Z[2*i+0]=Complex.plus(Z[2*i+0],w);
	    Z[2*i+1]=Complex.plus(Z[2*i+1],w);
	    return;
	}


	if(index==0) return;

	if(index==1) {
	    if(SOURCE.x<-1) Z[1]=new Complex(SOURCE.x,0);
	    return;
	}
	
	if(index%2==1) {
	    int i=index;
	    Complex w=new Complex(SOURCE);
	    Complex w2=new Complex(Z[i-1]);
	    double d2=Complex.dist(w,w2);
	    Complex z=Complex.minus(Z[i-1],Z[i]);
	    z=z.unit();

	    if(index==3) {
		double a=Math.PI*M.C.SH[0].getParameter();
		double c=Math.cos(a);
		double s=Math.sin(a);
		z=new Complex(c,s);
	    }

	    if(index==5) {
		double a=Math.PI*M.C.SH[1].getParameter();
		double c=Math.cos(a);
		double s=Math.sin(a);
		z=new Complex(c,s);
	    }

	    
	    z=z.scale(d2);
	    if(d2>1) Z[i]=Complex.minus(Z[i-1],z);
	}



    }

    
    public void mousePressed(MouseEvent e) { }
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) {
	     SOURCE=unTransform(J.X);
	     setPoint();
	}
	repaint();
	M.repaint();
    }
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
	 MouseData J=MouseData.process(e);
	 if(J.mode==2) {
	      SOURCE=unTransform(J.X);
  	      setPoint();
	 }
	repaint();
	M.repaint();
     }


}

