import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**This class generates a random tensegrity.
   There are 10 variables.*/

public class Tensegrity {

    public static Complex[] tensegrity(int[][] A,Complex[] Z,int level) {

	Vector[] V=new Vector[8];
	for(int i=0;i<8;++i) V[i]=new Vector(Z[i].x,Z[i].y,0);
	return tensegrity(A,V,level);
    }


    public static Complex[] tensegrity(int[][] A,Vector[] V,int level) {
	Complex[] T=new Complex[10];
        double[] s=new double[5];
	for(int i=0;i<5;++i) {
	    double B=Vector.dist(V[A[0][i]],V[A[1][i]]);
	    s[i]=A[2][i]*Math.sqrt(B*B-1);
	}

        double[] L=new double[4];
	double[] R=new double[4];
	for(int j=0;j<4;++j) {
            int i0=A[0][j];
	    int i1=A[1][j];
	    int i2=A[0][j+1];
	    int i3=A[1][j+1];
	    double d02=Vector.dist(V[i0],V[i2]);
	    double d13=Vector.dist(V[i1],V[i3]);
	    double d03=Vector.dist(V[i0],V[i3]);
	    double d12=Vector.dist(V[i1],V[i2]);

	    double[] LR=Trapezoid.main(s[j],s[j+1],d02,d13,d03,d12,level);
            L[j]=LR[0];
	    R[j]=LR[1];
	}

	//assemble
	T[1]=new Complex(0,0);
	T[0]=new Complex(1,s[0]);

	for(int i=1;i<5;++i) {
            T[2*i+0]=Complex.plus(T[2*i-2],new Complex(0,R[i-1]));
            T[2*i+1]=Complex.plus(T[2*i-1],new Complex(0,L[i-1]));
	}

	double sumL=0;
	double sumR=0;
	for(int i=0;i<4;++i) {
	    sumL=sumL+L[i];
	    sumR=sumR+R[i];
	}
	return T;	
    }

    

    /**This gets the slopes of the bends*/


    /**Converts a random point into bend data*/

    public static double[] bends(double[] b0,int choice,double[] r) {
	double x0=Math.max(0,b0[0]);
	double x1=(Math.sqrt(27)-Math.sqrt(11))/4;
	x1=Math.min(x1,b0[1]);
	double[] A=new double[4];
	A[0]=interpolate(x0,x1,r[0]);
	A[1]=interpolate(-1,1,r[1]);
	A[2]=interpolate(-1,1,r[2]);
	
	double y1=(2.0/3)*A[0]-1.0/Math.sqrt(3);
	double y2=(2.0/3)*A[0]-1.0/2;
	double y3=(4.0/3)*A[0]-1.0/Math.sqrt(3);
	double y4=Math.min(y2,y3);
	A[3]=interpolate(y1,y4,r[3]);

	if(choice!=0) {
	    double a2=A[2];
	    double a3=A[3];
	    A[2]=a3;
	    A[3]=a2;
	}
	return A;
    }


    /**this gets the offsets**/

    public static double[] offset() {
	double[] r={Math.random(),Math.random()};
	return offset(r);
    }

    public static double[] offset(double[] r) {
	double[] A=new double[2];
	A[0]=interpolate(0,1.0/18,r[0]);
	A[1]=interpolate(-1.0/30,1.0/30,r[1]);
	return A;
    }


    /**This gets the pitches*/

    public static double[] pitch(int choice) {
	double[] r={Math.random()};
	return pitch(choice,r);
    }

    public static double[] pitch(int choice,double[] r0) {
	double[] A={0,0,0};
	if(choice==0) A[1]=+Math.PI/12;
	if(choice==1) A[1]=+Math.PI/12;
	if(choice==2) A[1]=-4*Math.PI/12; //4 could be replaced by 5
	if(choice==3) A[1]=interpolate(-Math.PI/30,+Math.PI/12,r0[0]);
	if(choice==4) A[1]=interpolate(+Math.PI/30,-Math.PI/12,r0[0]);
	if(choice==0) A[2]=interpolate(5*Math.PI/12,7*Math.PI/12,r0[0]);
	if(choice==1) A[2]=interpolate(5*Math.PI/12,7*Math.PI/12,r0[0]);
	if(choice==2) A[2]=interpolate(1*Math.PI/12,3*Math.PI/12,r0[0]);
	if(choice==3) A[2]=4*Math.PI/12;
	if(choice==4) A[2]=4*Math.PI/12;
	return A;
    }



    /**This gets the proposed centerpoints*/

    public static double[] center1(int choice) {
	double[] r={Math.random(),Math.random()};
	return center1(choice,r);
    }

    public static double[] center1(int choice,double[] r) {
	double[] c=new double[2];
	   c[0]=interpolate(-1,1,r[0]);
	   c[1]=interpolate(-1,1,r[1]);
	return c;
    }


    public static double[] center2(int choice,double[] c0,double[] bend,double[] pitch) {
	double[] r={Math.random()};
	return center2(choice,c0,bend,pitch,r);
    }


    public static double[] center2(int choice,double[] c0,double[] bend,double[] pitch,double[] rr) {
	double r=rr[0];
	double[] c=new double[2];
	double[] length=new double[4];
	for(int i=0;i<4;++i)  length[i]=Math.sqrt(1+bend[i]*bend[i]);

	double x1=length[1]*Math.cos(pitch[1])/2;  
	double y1=length[1]*Math.sin(pitch[1])/2;

	double x2=length[2]*Math.cos(pitch[2])/2;
	double y2=length[2]*Math.sin(pitch[2])/2;

	double x3=c0[0]+x1;
	double y3=c0[1]+y1;

	if(choice==2) {
	   x3=c0[0]-x1;
	   y3=c0[1]-y1;
	}


	c[0]=x3+interpolate(-x2,x2,r);
	c[1]=y3+interpolate(-y2,y2,r);
	return c;
    }



    public static Vector[] assemble(double[] bend,double[] offset,double[] pitch,double[] c0,double[] c1,double[] tilt) {
	Vector[] V=new Vector[8];
	double[] length=new double[4];
	for(int i=0;i<4;++i) length[i]=Math.sqrt(1+bend[i]*bend[i]);
	double x=0;
	double y=0;

	V[0]=new Vector(0,0,0);
	V[1]=new Vector(-length[0],0,0);

	x=length[1]*Math.cos(pitch[1])/2;
	y=length[1]*Math.sin(pitch[1])/2;
	V[2]=new Vector(c0[0]+x,c0[1]+y,0);
	V[3]=new Vector(c0[0]-x,c0[1]-y,0);

	x=length[2]*Math.cos(pitch[2])/2;
	y=length[2]*Math.sin(pitch[2])/2;
	V[4]=new Vector(c1[0]+x,c1[1]+y,0);
	V[5]=new Vector(c1[0]-x,c1[1]-y,0);
     
	V[6]=new Vector(offset[0],offset[1]+length[3]/2,0);
	V[7]=new Vector(offset[0],offset[1]-length[3]/2,0);

	Vector[] W23={V[2],V[3]};
	W23=tilt(W23,tilt[0],tilt[1]);
	V[2]=new Vector(W23[0]);
	V[3]=new Vector(W23[1]);

	Vector[] W45={V[4],V[5]};
	W45=tilt(W45,tilt[2],tilt[3]);
	V[4]=new Vector(W45[0]);
	V[5]=new Vector(W45[1]);

	return V;
    }

    public static double capacity(int choice, int[][] A,int level,Vector[] V) {
	Complex[] T=tensegrity(A,V,level);
	
	if(choice<=0) {
	    double c1=Complex.dist(T[0],T[6])+Complex.dist(T[1],T[7]);
	    c1=c1-Math.sqrt(3);
	    return c1;
	}
	double c1=Complex.dist(T[0],T[8])+Complex.dist(T[1],T[9]);
	c1=c1-2*Math.sqrt(3);
	return c1;
    }

    public static double capacity2(int choice, int[][] A,int level,Vector[] V) {
	Complex[] T=tensegrity(A,V,level);
	double c1=Complex.dist(T[0],T[4])+Complex.dist(T[1],T[5]);
	c1=c1-Math.sqrt(3);
	return c1;
    }






    
    public static void check(int choice, int[][] A,int level,Vector[] V) {
	Complex[] T=tensegrity(A,V,level);

	Vector[] W={V[0],V[1],V[2],V[3],V[6],V[7],V[4],V[5]};

	for(int i=0;i<8;++i) {
	    for(int j=i+1;j<8;++j) {
		double d1=Complex.dist(T[i],T[j]);
		double d2=Vector.dist(W[i],W[j]);
		double d=d1-d2;
		System.out.println(i+" "+j+" "+d);
	    }
	}
	
    }


    public static double interpolate(double x0,double x1,double r) {
	return (1-r)*x0+r*x1;
    }


    public static Vector[] tilt(Vector[] V,double r1,double r2) {
	Vector W=Vector.plus(V[0].scale(1-r1),V[1].scale(r1));
	double d0=Vector.dist(W,V[0]);
	double d1=Vector.dist(W,V[1]);
	Vector X0=Vector.minus(V[0],W);
	Vector X1=Vector.minus(V[1],W);
	double c=Math.cos(Math.PI*r2/4);
	double s=Math.sin(Math.PI*r2/4);
	Vector Y0=new Vector(X0.x[0]*c,X0.x[1]*c,+d0*s);
	Vector Y1=new Vector(X1.x[0]*c,X1.x[1]*c,-d1*s);
	Y0=Vector.plus(W,Y0);
	Y1=Vector.plus(W,Y1);
	Vector[] Y={Y0,Y1};
	return Y;
    }


    
}

