import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Animate implements Runnable {
    Manager M;
    boolean halt;

    public Animate() {}

    public Animate(Manager MM) {
	this.M=MM;
	halt=true;
    }

    public void run() {
	int mode=M.C.ANGLE.mode;
	if(mode==0) runCrossingLemma();
        else runBootstrapLemma(mode);
    }

    
    public void runBootstrapLemma(int mode) {
	
	halt=false;
	long count=0;
	int[] mask=M.T.getMask();
	double theta=M.T.getAngle();
      	double excess=M.T.getExcess();
	System.out.println("used");
	double[] LIST=NumericalStudy2.trial(theta,excess,mask);
	double[] ratio=NumericalStudy2.bump1(LIST,theta);
	if(mode==2) ratio=NumericalStudy2.bump5(LIST,theta);
	double[] ratio2={0,0};

	System.out.println("initial "+ratio[0]+" "+ratio[1]);
	
	double[] LIST2=new double[7];
	while(halt==false) {
	    
	    ++count;
	    LIST2=NumericalStudy2.trial(LIST,.001*Math.random(),theta,excess,mask);
	    if(mode==1)  ratio2=NumericalStudy2.bump1(LIST2,theta);
	    if(mode==2)  ratio2=NumericalStudy2.bump5(LIST2,theta);

	    boolean compare=false;
	    if((mode==1)&&(ratio2[0]<ratio[0])) compare=true;
	    if((mode==2)&&(ratio2[0]<ratio[0])) compare=true;
	    
	    if(compare==true) {
		ratio=ratio2;
		System.out.println("# " + count + " bump "+ratio[0]+" len "+ratio[1]+" bias "+ratio[2]);
		for(int i=0;i<7;++i) LIST[i]=LIST2[i];
		count=0;
	    }
	    M.T.LIST=LIST;
	    M.T.repaint();
	}
	halt=true;
	M.T.repaint();
	M.C.repaint();
    }



    
    public void runCrossingLemma() {
	
	halt=false;
	long count=0;
	double theta=M.T.getAngle();
	double excess=M.T.getExcess();
	System.out.println("used");
	int[] mask=M.T.getMask();
	double[] LIST=NumericalStudy2.trial(theta,excess,mask);

	double xmin=100;
	double xmax=-100;
	double ymin=100;
	double ymax=-100;

	
	Complex z=new Complex();	
	
	double[] LIST2=new double[7];
	while(halt==false) {
	    mask=M.T.getMask();
	    int t=M.T.TIP.mode;
	    int mode=M.T.PUSH.mode;
	    ++count;
	    LIST2=NumericalStudy2.trial(LIST,.001*Math.random(),theta,excess,mask);
	    z=NumericalStudy2.tip(t,LIST2,theta);
	    double x=z.x;
	    double y=z.y;

	    if((mode==0) && (x<xmin)) {
		xmin=x;
		LIST=LIST2;
		System.out.println("XMIN "+count+"   "+x);
		count=0;
	    }

	    if((mode==1) && (x>xmax)) {
		xmax=x;
		LIST=LIST2;
	        System.out.println("XMAX "+count+"   "+x);
		count=0;
	    }

	    if((mode==2) && (y<ymin)) {
		ymin=y;
		LIST=LIST2;
		System.out.println("YMIN "+count+"   "+y);
		count=0;
	    }
	    if((mode==3) && (y>ymax)) {
		ymax=y;
		LIST=LIST2;
	        System.out.println("YMAX "+count+"   "+y);
		count=0;
	    }


	    double[] SEND={xmin,xmax,ymin,ymax};
	    M.T.BBOX=SEND;
	    
	    M.T.LIST=LIST;
	    M.T.repaint();
	}
	halt=true;
	M.T.repaint();
	M.C.repaint();
    }







    

    
    public static double f(double x,double y) {
	return x-y+Math.sqrt(1+y*y);
    }
    
    public static double g(double x,double y) {
	return -x+y+Math.sqrt(5+4*x*x+y*y);
    }


    public static double[] randomPoint() {
	boolean test=false;
	double a=Math.sqrt(3);
	double[] X={0,0};
	while(test==false) {
	    X=randomPointRaw();
	    double f0=f(X[0],X[1]);
	    double g0=g(X[0],X[1]);
	    if((f0<a)&&(g0<a)) test=true;
	}
	return X;
    }
    
    public static double[] randomPoint2() {
	boolean test=false;
	double a=Math.sqrt(3);
	double[] X={0,0};
	while(test==false) {
	    X=randomPointRaw();
	    boolean test2=true;
	    if(-2*X[0]+3*X[1]<-Math.sqrt(3)) test2=false;
	    if(-4*X[0]+3*X[1]>-Math.sqrt(3)) test2=false;
	    if(-2*X[0]+3*X[1]>-3.0/2) test2=false;
	    if(X[1]>-X[0]/2) test2=false;
	    if(test2==true) test=true;
	}
	return X;
    }
    

    public static double[] randomPointRaw() {
	double x=Math.random();
	double y=Math.random();
	x=x/2;
	y=y/2-1.0/Math.sqrt(3);
	double[] X={x,y};
	return X;
    }

    public void sentPoint(double[] X) {
        M.T.PLOT[M.T.COUNT]=new Complex(X[0],X[1]);
        M.T.COL[M.T.COUNT]=Color.white;
	++M.T.COUNT;
	M.T.repaint();
    }
    
}
