import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class ColorHelp {

    ListenSquare[] Q0=new ListenSquare[10];
    ListenSquare[] Q1=new ListenSquare[10];
    int X,Y;

    public static Color[] COL0={
	new Color(40,80,255),
	new Color(100,150,255),
	new Color(0,0,200),
	new Color(0,0,255),
	new Color(50,100,255),
	new Color(0,80,160),
	new Color(0,150,255),
	new Color(0,100,200),
	new Color(0,200,200),
	new Color(0,255,255)};

    public static Color[] COL1={
	    new Color(150,0,0),
	    new Color(255,0,0),
	    new Color(200,0,0),
	    new Color(255,120,0),
	    new Color(255,200,0),
	    new Color(160,0,80),
	    new Color(255,0,150),
	    new Color(200,0,100),
	    new Color(150,0,150),
	    new Color(200,0,200)};


    

    public ColorHelp(int x,int y) {
	this.X=x;
	this.Y=y;
	for(int i=0;i<10;++i) {
	    Q0[i]=new ListenSquare(X+30*i,Y,30,15);
	    Q1[i]=new ListenSquare(X+30*i,Y+15,30,15);
	}
    }


    public Color getColor(int choice,int k) {
	if(choice==0)	return COL0[k%10];
	if(choice==1)	return COL1[k%10];
	return null;
    }

    public static Color trans(Color C,int alpha) {
	int r=C.getRed();
	int g=C.getGreen();
	int b=C.getBlue();
	Color C2=new Color(r,g,b,alpha);
	return C2;
    }

    public static Color copy(Color C) {
	int r=C.getRed();
	int g=C.getGreen();
	int b=C.getBlue();
	int alpha=C.getAlpha();
	Color C2=new Color(r,g,b,alpha);
	return C2;
    }

    

    public static Color trans(Color C,double t) {
	int a=(int)(t*255);
	if(a<0) a=0;
	if(a>255) a=255;
	return trans(C,a);
    }

    public void render(Graphics2D g) {
	for(int i=0;i<10;++i) {
	    Q0[i].render(g,COL0[i]);
	    Q1[i].render(g,COL1[i]);
	}
    }

    public void process(Point p,Color C) {
	for(int i=0;i<10;++i) {
	    if(Q0[i].inside(p)==1) {
		COL0[i]=copy(C);
	    }
	}
	for(int i=0;i<10;++i) {
	    if(Q1[i].inside(p)==1) {
		COL1[i]=copy(C);
	    }
	}
    }


    
}



