import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener {
    Manager M;
    SelectColor CS;
    SelectInteger NUM;
    EnhancedSlider TRANS,ROLL,PITCH,YAW;
    ListenSquare RESET2,GO,STOP,BEND,RESET,SYMM;
    ControlPanel RESTRICT,MODE,ANGLE;
    ControlPanelColor DISPLAY;
    Animate ANN;
    PopupManager POP;

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 CS=new SelectColor(this.M,0,499,799,50);
	 TRANS=new EnhancedSlider(0,300,800,30,250,new Color(120,130,140),"transparency");
	 ROLL=new EnhancedSlider(0,350,800,30,400,new Color(0,0,200),"roll");
	 PITCH=new EnhancedSlider(0,400,800,30,600,new Color(0,0,220),"pitch");
	 YAW=new EnhancedSlider(0,450,800,30,0,new Color(0,0,240),"yaw");
	 
	 NUM=new SelectInteger(400,5,40,20,2,2,20,2);
	 RESET2=new ListenSquare(470,5,60,20);
	 GO=new ListenSquare(655,5,55,20);
	 STOP=new ListenSquare(655,30,55,20);
	 RESET=new ListenSquare(350,5,40,20);
	 SYMM=new ListenSquare(555,5,40,20);
	 ANN=new Animate(this.M);

	 setPanels();
     }
    
    public void setPanels() {

       Color[] C0={new Color(80,120,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       String[] OrthoString={"init vertical","halfway ortho","restrictions"};
       int[] OrthoState={0,1};
        RESTRICT=new ControlPanel(C0,OrthoString,OrthoState,2);


        String[] ModeString={"pitch/roll/yaw",
                              "canonical",
                              "view"};
        int[] ModeState={0,1};
        MODE=new ControlPanel(C0,ModeString,ModeState,2);
	MODE.mode=1;

	
        String[] RecordString={"crossing lemma",
			       "1-right",
			       "5-right",
			       "detour lemma",
                              "kind of calculation"};
        int[] RecordState={1,0,0,0};
        ANGLE=new ControlPanel(C0,RecordString,RecordState,4);
	ANGLE.mode=0;


        String[] DisplayString={"background",
				"mobius first half",
				"mobius secont half",
                                "core curve first half",
                                "core curve second half",
				"initial bend",
				"halfway bend",
				"final bend",
                                "kite",			      
				"midpoints",
				"alt core first half",
				"alt core second half",
				"sphere",
				"individual bends",
				"display"};

       Color[] DisplayColor={
	   new Color(0,0,0),
	   new Color(0,0,255),
	   new Color(255,0,0),
	   new Color(0,0,255),
	   new Color(255,0,0),
           new Color(80,160,255),
           new Color(255,0,255),
           new Color(255,100,0),
	   new Color(150,0,200),
	   new Color(255,255,255),
       	   Color.black,
	   Color.black,
	   new Color(255,255,255,50),
	   new Color(255,255,0)};
	
       int[] DisplayState={1,1,0,1,0,1,1,0,0,1,0,0,0,0,0};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,14,DisplayColor);
    }

    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      drawStats(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(60,70,80));
      g.fillRect(0,0,getWidth(),getHeight()); 
    }
    
    public void drawControls(Graphics2D g) { 
      CS.render(g);
      RESTRICT.render(g,160,0,120);
      MODE.render(g,160,55,120);
      ANGLE.render(g,160,110,120);
      DISPLAY.render(g,0,0,155);
      TRANS.render(g);
      ROLL.render(g);
      PITCH.render(g);
      YAW.render(g);
      NUM.render(g,Color.blue,Color.white,Color.white);
      RESET2.render(g,"random",12,4,Color.blue);
      if(ANN.halt==true) GO.render(g,"go",12,4,new Color(0,180,0));
      if(ANN.halt==false) STOP.render(g,"stop",12,4,new Color(200,0,0));
      RESET.render(g,"reset",12,4,Color.blue);
      SYMM.render(g,"symm",12,4,Color.blue);
      POP.render(g);
    }

    public void drawStats(Graphics2D g) {
      try{
      g.setFont(new Font("Helvetica",Font.PLAIN,15));
      double d=M.P.PAP.globalAngle();
      Double D=new Double(d/Math.PI);
      g.drawString("global angle "+D.toString()+" \u03C0",350,65);

      double length=Math.sqrt(3)-2*M.P.PAP.coreLength();
      D=new Double(length);
      g.drawString("lower half surplus length "+D.toString(),350,90);

      double[] dd=M.P.PAP.halfwayAngles();
      String[] SS={"bend angle bottom(x)","bend angle halfway(y)"};

      for(int i=0;i<2;++i) {
	  D=new Double(dd[i]);
          g.drawString(SS[i]+" "+D.toString(),350,115+20*i);
      }}
      catch(Exception e) {}

    }

    public void doAnimate() {
	if(ANN.halt==false) return;
	ANN=new Animate(this.M);
	new Thread(ANN).start();
    }
    
    public void mouseClicked(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	TRANS.configure(J.X);
	ROLL.configure(J.X);
	PITCH.configure(J.X);
	YAW.configure(J.X);
	NUM.modify(J.X);
	RESTRICT.toggle(J.X);
	ANGLE.switchMode(J.X);
	MODE.switchMode(J.X);
	DISPLAY.process(J.X,CS.C);
	if(RESET.inside(J.X)==1) {
	     M.P.initBend(NUM.val);
	}
	
	if(RESET2.inside(J.X)==1) {
	    if(NUM.val>2) M.P.initBendRandom(NUM.val/2);
	}
	if(SYMM.inside(J.X)==1) M.P.PAP.symmetrize();
	if(GO.inside(J.X)==1) doAnimate();
	if(STOP.inside(J.X)==1) ANN.halt=true;
	POP.process(J.X);
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {
       MouseData J=MouseData.process(e);
       TRANS.activate(J.X);
       ROLL.activate(J.X);
       PITCH.activate(J.X);
       YAW.activate(J.X);
    }
    
	
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	TRANS.configure(J.X);
	ROLL.configure(J.X);
	PITCH.configure(J.X);
	YAW.configure(J.X);

	if(RESET2.inside(J.X)==1) {
	    if(NUM.val>2) M.P.initBendRandom(NUM.val/2);
	}


	
	repaint();
	M.repaint();
     } 

}

