import java.awt.event.*;
import java.awt.*;

public class EnhancedSlider {
    int x,y,w,h;
    int ACTIVE;
    ListenSquare[] RESET=new ListenSquare[13];
    double POS;
    Color C;
    String S;
    
    EnhancedSlider(int x,int y,int w,int h,double POS,Color C,String s) {
        this.x=x;
        this.y=y;
        this.h=h;
        this.w=w;
        this.POS=POS;
        this.C=C;
	this.S=s;
	for(int i=0;i<13;++i) {
	    this.RESET[i]=new ListenSquare(x+i*w/13,y+h,w/13,10);this.RESET[i].on=1;
	}
        ACTIVE=0;
    }

    void render(Graphics g) {
        g.setColor(C);
        g.fillRect(x,y,w,h);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	g.setColor(new Color(255,255,255,100));
	Double D=new Double(getValue());
	String S2=S+" "+D.toString();
	g.drawString(S2,x+5,y+h-5);
	g.setColor(Color.black);
	if(ACTIVE==1) g.setColor(Color.white);
        g.drawRect(x,y,w,h);
	for(int i=0;i<13;++i) {
   	   RESET[i].render(g,C);
	}
        g.setColor(Color.white);
	int p=(int)(POS);
        g.fillRect(p-1,y+1,2,h-2); 
        g.drawRect(p-1,y+1,2,h-2); 

    }

    void configure(Point p) {
	configure(p,false);
    }


    void configure(Point p,boolean drag) {
        if((ACTIVE==1)&&(p.x<x+w)&&(p.x>x)) POS=p.x;
	for(int i=0;i<13;++i) {
	    if(RESET[i].inside(p)==1) POS=1.0*i*w/12;
	}
    }

    void activate(Point p) {
	ACTIVE=0;
	if(inside(p)==1) ACTIVE=1;
    }
    
    int inside(Point p) {
        int test=0;
        if((p.x>x)&&(p.x<x+w+50)&&(p.y>y)&&(p.y<y+h)) test=1;
        return(test);
    }

    public double getValue() {
	double t=1.0*this.POS/this.w;
	return t;
    }
    
    public void forceValue(double t) {
	double c=t;
	POS=w*c;
    }
    
}
