import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of 3x3 matrices */


public class Matrix {
    double[][] a=new double[3][3];
    public Matrix(){}

    public Matrix(double[][] aa) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=aa[i][j];
	    }
	}
    }

    public Matrix(Vector[] V) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=V[i].x[j];
	    }
	}
    }
    
    public static Matrix times(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=0;
		for(int k=0;k<3;++k) {
		    M.a[i][j]=M.a[i][j]+M1.a[i][k]*M2.a[k][j];
		}
	    }
	}
	return(M);
    }


    public void print() {

	System.out.println("matrix");
	System.out.println(a[0][0]+ " "+a[0][1]+" "+a[0][2]);
	System.out.println(a[1][0]+ " "+a[1][1]+" "+a[1][2]);
	System.out.println(a[2][0]+ " "+a[2][1]+" "+a[2][2]);
    }



    public double det() {

	double a1=a[0][0]*a[1][1]*a[2][2];
	double a2=a[0][1]*a[1][2]*a[2][0];
	double a3=a[0][2]*a[1][0]*a[2][1];

	double b1=a[2][0]*a[1][1]*a[0][2];
	double b2=a[2][1]*a[1][2]*a[0][0];
	double b3=a[2][2]*a[1][0]*a[0][1];

	return(a1+a2+a3-b1-b2-b3);
    }


    public Matrix inverse() {

	Matrix M=new Matrix();

	M.a[0][0]= a[1][1]*a[2][2]-a[1][2]*a[2][1];
	M.a[0][1]= a[1][2]*a[2][0]-a[1][0]*a[2][2];
	M.a[0][2]= a[1][0]*a[2][1]-a[1][1]*a[2][0];

	M.a[1][0]= a[2][1]*a[0][2]-a[2][2]*a[0][1];
	M.a[1][1]= a[2][2]*a[0][0]-a[2][0]*a[0][2];
	M.a[1][2]= a[2][0]*a[0][1]-a[2][1]*a[0][0];

	M.a[2][0]= a[0][1]*a[1][2]-a[0][2]*a[1][1];
	M.a[2][1]= a[0][2]*a[1][0]-a[0][0]*a[1][2];
	M.a[2][2]= a[0][0]*a[1][1]-a[0][1]*a[1][0];

	double d=this.det();

	Matrix TM=new Matrix();

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=M.a[i][j]/d;
	    }
	}
	return(TM);
    }



    public Matrix adjoint() {

	Matrix M=new Matrix();

	M.a[0][0]= a[1][1]*a[2][2]-a[1][2]*a[2][1];
	M.a[0][1]= a[1][2]*a[2][0]-a[1][0]*a[2][2];
	M.a[0][2]= a[1][0]*a[2][1]-a[1][1]*a[2][0];

	M.a[1][0]= a[2][1]*a[0][2]-a[2][2]*a[0][1];
	M.a[1][1]= a[2][2]*a[0][0]-a[2][0]*a[0][2];
	M.a[1][2]= a[2][0]*a[0][1]-a[2][1]*a[0][0];

	M.a[2][0]= a[0][1]*a[1][2]-a[0][2]*a[1][1];
	M.a[2][1]= a[0][2]*a[1][0]-a[0][0]*a[1][2];
	M.a[2][2]= a[0][0]*a[1][1]-a[0][1]*a[1][0];
	Matrix TM=new Matrix();

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=M.a[i][j];
	    }
	}
	return(TM);
    }

    public Matrix transpose() {

	Matrix TM=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=a[i][j];
	    }
	}
	return(TM);
    }

    public double trace() {
	double t=a[0][0]+a[1][1]+a[2][2];
	return(t);
    }

    public Vector act(Vector V) {
	Vector W=new Vector();
	for(int i=0;i<3;++i) {
	    W.x[i]=a[0][i]*V.x[0]+a[1][i]*V.x[1]+a[2][i]*V.x[2];
	}
	return W;
    }

    public static Matrix identity() {
	return rotateZ(0);
    }

    public static Matrix rotateZ(double theta) {
	Vector V0=new Vector(+Math.cos(theta),Math.sin(theta),0);
	Vector V1=new Vector(-Math.sin(theta),Math.cos(theta),0);
	Vector V2=new Vector(0,0,1);
	Vector[] V={V0,V1,V2};
	Matrix M=new Matrix(V);
	return M;
    }

    public static Matrix rotate(Vector V,double theta) {
	Vector[] F=V.orthoFrame();
	Matrix M1=new Matrix(F);
	Matrix M2=M1.inverse();
	Matrix M3=rotateZ(theta);
	Matrix M4=Matrix.times(M2,Matrix.times(M3,M1));
	return M4;
    }


    /**This map carries V to W and has linear part the given matrix*/

    public static Vector affineAct(Matrix M,Vector V,Vector W,Vector X) {
	Vector V2=Vector.minus(X,V);
	V2=M.act(V2);
	V2=Vector.plus(V2,W);
	return V2;
    }

}
