import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class NumericalStudy1 {



    /**This routine computes the geodesic distance between
two points that are in the positive quadrant and outside the
unit disk.  The geodesic must remain outside the unit disk.*/

    public static double geodesicDistance(Complex z1,Complex z2) {
	boolean test=hitsCircle(z1,z2);
	if(test==false) return Complex.dist(z1,z2);
	Complex[] W=intersectionPoints(z1,z2);
	double d=circleDistance(W[0],W[1]);

	double d10=Complex.dist(z1,W[0]);
	double d11=Complex.dist(z1,W[1]);
	double d20=Complex.dist(z2,W[0]);
	double d21=Complex.dist(z2,W[1]);

	double e1=d+d10+d21;
	double e2=d+d11+d20;
	double e=Math.min(e1,e2);
	return e;
    }
    

    /**abbraviated power function*/
    public static double p(double x,int k) {
	return Math.pow(x,k);
    }


    /**This decides if the line segment joining the two
       complex numbers intersects the unit circle*/

    public static boolean hitsCircle(Complex z1,Complex z2) {
	double disc=discriminant(z1,z2);
	if(disc<0) return false;
	return true;
    }


    /**Assuming this is true, this returns the places where some
       line segment intersects the unit circle*/

    public static Complex[] intersectionPoints(Complex z1,Complex z2) {
	double x1=z1.x;
	double y1=z1.y;
	double x2=z2.x;
	double y2=z2.y;
        double disc=discriminant(z1,z2);
	double den= p(x1,2) - 2*x1*x2 + p(x2,2) + p(y1 - y2,2);
        double t1=(p(x1,2) - x1*x2 + p(y1,2) - y1*y2 - Math.sqrt(disc))/den;
	double t2=(p(x1,2) - x1*x2 + p(y1,2) - y1*y2 + Math.sqrt(disc))/den;
        double xx1=(1-t1)*x1+t1*x2;
        double yy1=(1-t1)*y1+t1*y2;
        double xx2=(1-t2)*x1+t2*x2;
        double yy2=(1-t2)*y1+t2*y2;
	Complex zz1=new Complex(xx1,yy1);
	Complex zz2=new Complex(xx2,yy2);
	Complex[] Z={zz1,zz2};
	return Z;
    }

	/**Tells if the line segment joining the two complex numbers intersects the
           unit circle.  Negative implies false.  Positive implies true. Zero implies tangent.*/

    public static double discriminant(Complex z1,Complex z2) {
	double x1=z1.x;
	double y1=z1.y;
	double x2=z2.x;
	double y2=z2.y;
        double disc=p(x1,2) - 2*x1*x2 + p(x2,2) + p(y1,2) -
	    p(x2,2)*p(y1,2) - 2*y1*y2 + 2*x1*x2*y1*y2 + p(y2,2) - p(x1,2)*p(y2,2);
	if(Math.abs(disc)<.000000001) return 0;
	return disc;
    }


    /**This gives the circular distance between two unit complex numbers in the positive quadrant */
    
    public static double circleDistance(Complex u1,Complex u2) {
	double t1=Math.acos(u1.x);
	double t2=Math.acos(u2.x);
	return Math.abs(t1-t2);
    }

}
