import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class NumericalStudy2 {

    /**This constructs the basic object. We do planar stuff first*/


    public static double[] trial(double theta,double excess,int[] mask) {
	boolean test=false;
	double[] list=new double[7];
	long count=0;
	while(test==false) {
	    ++count;
	    list=randomParameters();
	    test=satisfiesConstraints(list,theta,excess,mask);
	}
	return list;
    }

    public static double[] trial(double[] list0,double size,double theta,double excess,int[] mask) {
	boolean test=false;
	double[] list=new double[7];
	long count=0;
	while(test==false) {
	    ++count;
	    list=randomPerturb(list0,size);
       	    test=satisfiesConstraints(list,theta,excess,mask);
	}
	return list;
    }

    /**Constraints*/

    public static boolean satisfiesConstraints(double[] list,double theta,double excess,int[] mask) {

	double[][] P=parametersToShape(list,theta);
	Complex[] Z=new Complex[6];
       	for(int i=0;i<6;++i) Z[i]=new Complex(P[i][0],P[i][1]);
	double[][] shape=extractShape(P);
	double x=shape[0][0];
	double y=shape[0][1];
	double z=shape[0][2];
	double L1=shape[1][0];
	double L2=shape[1][1];
	double R1=shape[1][2];
	double R2=shape[1][3];

	double L1fold=shape[2][0];
	double L2fold=shape[2][1];
	double R1fold=shape[2][2];
	double R2fold=shape[2][3];
	double S=L1fold+L2fold+R1fold+R2fold;


	/**basic constraints*/
	
	if(mask[0]==1) {
	   if(Z[0].y<.5-1.0/30) return false;
	   if(Z[0].x>Z[2].x+1.0/24) return false;
	   if(2*Z[2].x>Z[0].x+Z[3].x+1.0/15) return false;
	   if(2*Z[2].x<Z[0].x+Z[3].x-1.0/15) return false;
	   if(Z[2].x>.56) return false;
       	   if(L1<L1fold) return false;
      	   if(R2<R2fold) return false;
       	   if(S>Math.sqrt(3)+excess) return false;
	}

	/**crosshatch constraints*/

	if(mask[1]==1) {
	  double cr04=Math.sqrt(1+(L2+z)*(L2+z));
	  double cr15=Math.sqrt(1+(L1+z)*(L1+z));
	  double cr24=Math.sqrt(1+(R1-z)*(R1-z));
	  double cr13=Math.sqrt(1+(R2-z)*(R2-z));

	  double cr04fold=Complex.dist(Z[0],Z[4]);
	  double cr15fold=Complex.dist(Z[1],Z[5]);
	  double cr24fold=Complex.dist(Z[2],Z[4]);
	  double cr13fold=Complex.dist(Z[1],Z[3]);

	  double f04=cr04-cr04fold;
	  double f15=cr15-cr15fold;
	  double f24=cr24-cr24fold;
	  double f13=cr13-cr13fold;

	  if(f04<0) return false;
	  if(f15<0) return false;
	  if(f24<0) return false;
	  if(f13<0) return false;
	}

	/*perimeter constraint*/

	if(mask[2]==1) {
	    double perimeter=Complex.dist(Z[0],Z[2])+Complex.dist(Z[2],Z[3])+Complex.dist(Z[3],Z[5])+Complex.dist(Z[5],Z[0]);
	   if(perimeter>2*Math.sqrt(3)) return false;
	}

	return true;
    }


/**This is for the Pi/12 bend: bump size versus length of path*/

    public static double[] bump1(double[] list,double theta) {
        double[][] P=parametersToShape(list,theta);
	Complex[] Z=new Complex[6];
	for(int i=0;i<6;++i) Z[i]=new Complex(P[i][0],P[i][1]);

	double[][] shape=extractShape(P);
	double S=Complex.dist(Z[0],Z[2])+Complex.dist(Z[3],Z[4])+Complex.dist(Z[4],Z[5]);
	double b = P[6][0];
	double ss=Math.sqrt(3)-S;
	double bump=P[8][0];
	double ratio=bump/ss;
	double[] ratio2={ratio,ss,0};
	return ratio2;
    }




    
    public static double[] bump5(double[] list,double theta) {
        double[][] P=parametersToShape(list,theta);
	Complex[] Z=new Complex[6];
	for(int i=0;i<6;++i) Z[i]=new Complex(P[i][0],P[i][1]);
	double mult=Math.sqrt(3)*(Z[0].y-Z[3].y)/(Z[1].y-Z[3].y);
	double[][] shape=extractShape(P);
	double L1=shape[2][0];
	double L2=shape[2][1];
	double R1=shape[2][2];
	double R2=shape[2][3];
	double S=L1+L2+R1+R2;
	double surplus=Math.sqrt(3)-S;
	double ratio=-Z[1].x+Z[0].x;
	double[] ratio2={ratio,surplus,0};
	return ratio2;
    }


    

    

/**This is for the Pi/3 bend: bump size versus perimeter*/
    public static double[] bumpAndPerimeter(double[] list,double theta) {
        double[][] P=parametersToShape(list,theta);
	Complex[] Z=new Complex[6];
	for(int i=0;i<6;++i) Z[i]=new Complex(P[i][0],P[i][1]);
	double[][] shape=extractShape(P);
        double x=shape[0][0];
        double y=shape[0][1];
	double perimeter=Complex.dist(Z[0],Z[3])+Complex.dist(Z[3],Z[5])+Complex.dist(Z[5],Z[0]);
	double surplus=2*Math.sqrt(3)-perimeter;
	double ratio=shape[0][3]/surplus;
	double[] ratio2={ratio,surplus};
	return ratio2;
    }


    
    public static Complex tip(int t,double[] list,double theta) {
        double[][] P=parametersToShape(list,theta);
	Complex[] Z=new Complex[6];
	for(int i=0;i<6;++i) Z[i]=new Complex(P[i][0],P[i][1]);
	//Complex z=Vector.reflect(Z[1],Z[4],Z[2]);
	Complex d1=Complex.minus(Z[1],Z[0]);
	Complex d2=Complex.minus(Z[4],Z[5]);
	if(t==0) return d1;
	return d2;
    }

    

    public static double[][] extractShape(double[][] P) {
	Complex[] Z=new Complex[6];
	for(int i=0;i<6;++i) Z[i]=new Complex(P[i][0],P[i][1]);
	double L2fold=Complex.dist(Z[0],Z[1]);
	double R1fold=Complex.dist(Z[1],Z[2]);
	double R2fold=Complex.dist(Z[3],Z[4]);
	double L1fold=Complex.dist(Z[4],Z[5]);
	

	double R1=R1fold;
	double L2=L2fold;
	double x=P[6][0];
	double y=P[6][1];
	double T=Math.sqrt(1+y*y);

	double C=Complex.dist(Z[1],Z[4]);
	double z=Math.sqrt(C*C-1);  //centerline slope*/
	double L1=R1+x-z;
	double R2=L2+z-y;
	double b0=bumpsize(0,Z); //1-bump
	double b1=bumpsize(1,Z); //5-bump
	
	double[][] lengths={{x,y,z,b0,b1},{L1,L2,R1,R2,0},{L1fold,L2fold,R1fold,R2fold,0}};
	return lengths;
    }



    public static double bumpsize(int choice,Complex[] Z) {
	if(choice==0) return bumpsize0(Z);
	else return bumpsize1(Z);
    }


    public static double bumpsize0(Complex[] Z) {
	return pointLineDist(Z[0],Z[1],Z[3]);
    }


    public static double bumpsize1(Complex[] Z) {
	return pointLineDist(Z[3],Z[4],Z[5]);
    }


    public static double pointLineDist(Complex a1,Complex b,Complex a2) {
	double A=Complex.area(a1,b,a2);
	double d2=Complex.dist(a1,a2);
	return A/d2;
    }


    

    public static double[][] parametersToShape(double[] list,double theta) {
	double x=list[0];
	double y=list[1];
	double u=list[2];
	double v=list[3];
	double u2=list[4];
	double m=list[5];

	double cm=m*Math.cos(theta);
	double sm=m*Math.sin(theta);
	double B=Math.sqrt(1+x*x);
	double T=Math.sqrt(1+y*y);

	double[][] P=new double[9][2];
	P[0][0]=B/2+u;
	P[0][1]=T/2+v;
	P[1][0]=P[0][0]+u2;
       	P[1][1]=(T/2)+list[6];
	P[2][0]=B/2;
	P[2][1]=0;
	P[3][0]=P[0][0];
	P[3][1]=P[0][1]-T;
	P[4][0]=P[1][0]-cm;
	P[4][1]=P[1][1]-sm;
	P[5][0]=-B/2;
	P[5][1]=0;
	P[6][0]=x; //B-slope
	P[6][1]=y; //T-slope
	P[7][0]=u;
	P[7][1]=v;
	P[8][0]=u2;//1-bump size
	return P;
    }


    

    /**the parameters are:
          bottom slope
          top slope
          T pattern x-displacement
          T pattern y-displacement
          bump size 
          middle bend length*/

    
    public static double[] randomParameters() {
	double Pi=Math.PI;
	double[] X=randomPoint();
	double x=X[0];
	double y=X[1];
        double B=Math.sqrt(1+x*x);
	double T=Math.sqrt(1+y*y);
	double u=(1.0/18)*Math.random();
	double u2=(1-2*Math.random());
	double v=(1.0/30)*(1-2*Math.random());
	double m=1+.2*Math.random();
	double t=Math.random();
	t=1-2*Math.random();
	double[] list={x,y,u,v,u2,m,t};
	return list;
    }




    

    public static double[] randomPerturb(double[] list,double t) {
       double[] list2=randomParameters();
       double[] list3=new double[7];
       for(int i=0;i<7;++i) list3[i]=(1-t)*list[i]+t*list2[i];
       return list3;
    }

    /**This is a point, specifying the bottom and bottom slopes,
       that is inside the trapezoid of constraint*/
    
    public static double[] randomPoint() {
	boolean test=false;
	double a=Math.sqrt(3);
	double[] X={0,0};
	while(test==false) {
	    X=randomPointRaw();
	    boolean test2=true;
	    if(-2*X[0]+3*X[1]<-Math.sqrt(3)) test2=false;
	    if(-4*X[0]+3*X[1]>-Math.sqrt(3)) test2=false;
	    if(-2*X[0]+3*X[1]>-3.0/2) test2=false;
	    if(X[1]>-X[0]/2) test2=false;
	    if(test2==true) test=true;
	}
	return X;
    }
    


    
    public static double f(double x,double y) {
	return x-y+Math.sqrt(1+y*y);
    }
    
    public static double g(double x,double y) {
	return -x+y+Math.sqrt(5+4*x*x+y*y);
    }


    public static double[] randomPoint2() {
	boolean test=false;
	double a=Math.sqrt(3);
	double[] X={0,0};
	while(test==false) {
	    X=randomPointRaw();
	    double f0=f(X[0],X[1]);
	    double g0=g(X[0],X[1]);
	    if((f0<a)&&(g0<a)) test=true;
	}
	return X;
    }
    



    public static double[] randomPointRaw() {
	double x=Math.random();
	double y=Math.random();
	x=x/2;
	y=y/2-1.0/Math.sqrt(3);
	double[] X={x,y};
	return X;
    }

}
