import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PaperMobius {
    Complex[][] ZIG=new Complex[30][2];  //the coordinates of the bending lines
    double[] BEND=new double[30];        //the bending angles
    int[] GLUE=new int[30];              //tells whether the triangles bend up or down
    Matrix[] m=new Matrix[30];           //the rotation matrices
    Vector[][] V0=new Vector[30][2];     //the vectors for the plan
    Vector[][] V=new Vector[30][2];      //the vectors for the embedding
    int NUM;                             //number of bends
    int HALF;                            //the halfway bend

    /**constructors*/
    public PaperMobius() {}


    public PaperMobius(PaperMobius Q) {
	NUM=Q.NUM;
	HALF=Q.HALF;
	for(int i=0;i<NUM;++i) {
	    ZIG[i][0]=new Complex(Q.ZIG[i][0]);
	    ZIG[i][1]=new Complex(Q.ZIG[i][1]);
	    BEND[i]=Q.BEND[i];
	    GLUE[i]=Q.GLUE[i];
	}
	addGeometry();
    }

    public void addGeometry() {
	m=prodList();
	V0=plan();
	V=geometry();
    }


    
    
    /**This is the realization of the mobius band*/
    public Vector[][] geometry() {
	Matrix[] m=prodList();
	Vector[][] U=plan();
	Vector[][] B=new Vector[U.length][2];
	for(int i=0;i<2;++i) {
	  B[i][0]=new Vector(U[i][0]);
	  B[i][1]=new Vector(U[i][1]);
	}
	for(int i=2;i<U.length;++i) {
	    B[i][0]=Matrix.affineAct(m[i-2],U[i-1][0],B[i-1][0],U[i][0]);
	    B[i][1]=Matrix.affineAct(m[i-2],U[i-1][1],B[i-1][1],U[i][1]);
	}
	return B;
    }
    
    /**This is the flat realization*/
    public Vector[][] plan() {
	int k=NUM;
	Vector[][] V=new Vector[k][2];
	for(int i=0;i<k;++i) {
            V[i][0]=new Vector(ZIG[i][0].x,ZIG[i][0].y,0);
	    V[i][1]=new Vector(ZIG[i][1].x,ZIG[i][1].y,0);
	}
	return V;
    }


    /**These are the matrices which make the bending*/
    
    public Matrix[] prodList() {
	Matrix m0=Matrix.identity();
	Matrix m=Matrix.identity();
	Matrix[] LIST=rawList();
	Matrix[] PROD=new Matrix[LIST.length];
	
	for(int i=0;i<LIST.length;++i) {
	    PROD[i]=Matrix.times(LIST[i],m);
	    m=Matrix.times(m0,PROD[i]);
	}
	return PROD;
    }

    public Matrix[] rawList() {
	int k=NUM-1;
	Matrix[] LIST=new Matrix[k];
	for(int i=0;i<k;++i) {
            Vector V=new Vector(ZIG[i+1][0].x,ZIG[i+1][0].y,0);
	    Vector W=new Vector(ZIG[i+1][1].x,ZIG[i+1][1].y,0);
	    Vector AXIS=Vector.minus(V,W);
	    double a=BEND[i+1];
	    a=Math.PI*(2*a-1);
	    LIST[i]=Matrix.rotate(AXIS,a);
	}
	return LIST;
    }
    
    /**end matrices routine*/




    

    /**detection routines*/

    /**This detects the region containing the point*/

    public int detectWedge(Complex z) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=0;i<NUM-1;++i) {
	    gp=wedge(i);
	    if(gp.contains(z.x,z.y)==true) return i;
	}
	return -1;
    }

    /**This gets the ith wedge*/
    public Path2D.Double wedge(int i) {
	    Path2D.Double gp=new Path2D.Double();
	    gp.moveTo(V0[i+0][0].x[0],V0[i+0][0].x[1]);
	    gp.lineTo(V0[i+0][1].x[0],V0[i+0][1].x[1]);
	    gp.lineTo(V0[i+1][1].x[0],V0[i+1][1].x[1]);
	    gp.lineTo(V0[i+1][0].x[0],V0[i+1][0].x[1]);
	    gp.closePath();
	    return gp;
    }


    /**Core curve routines*/
    /**This gets the vectors for the core curve*/

    public Vector[] core() {
	Vector[] W=new Vector[NUM];
	for(int i=0;i<NUM;++i) {
	    W[i]=Vector.plus(V[i][0],V[i][1]);
	    W[i]=W[i].scale(.5);
	}
	return W;
    }


    /**This gets the length*/

    public double coreLength() {
	Vector[] W=core();
	double tot=0;
	for(int i=0;i<HALF;++i) {
	    tot=tot+Vector.dist(W[i],W[i+1]);
	}
	return tot;
    }

    /**This gets the displacement*/

    public double displacementDist() {
	Vector[] W=core();
	return Vector.dist(W[HALF],W[0]);
    }

    

    /**This gets the difference core vectors */

    public Vector[] coreDiff() {
	Vector[] W=core();
	Vector[] DW=new Vector[W.length];
	DW[0]=W[0];
	for(int i=1;i<NUM;++i) {
	    DW[i]=Vector.minus(W[i],W[i-1]);
	}
	return DW;
    }

    
    public Vector[] core2() {
	Vector[] W=coreDiff();
	Vector[] IW=new Vector[W.length];
	IW[0]=new Vector(W[0]);
	for(int i=1;i<NUM;++i) {
	    int s=1-2*GLUE[i-1];
	    IW[i]=Vector.plus(IW[i-1],W[i].scale(s));
	}
	return IW;
    }
    
    /**This gets the sides for the kite*/
    
    public Vector[] kiteEdge() {
	Vector V0=V[0][0];
	Vector V1=V[0][1];
	Vector V2=V[HALF][0];
	Vector V3=V[HALF][1];
	Vector V4=V[NUM-1][0];
	Vector V5=V[NUM-1][1];
	Vector[] W={V0,V2,V1,V3,V4,V5};
	return W;
    }

    /**This gets the angle between the first and halfway line*/

    public double globalAngle() {
	Vector A0=V[0][0];
	Vector A1=V[0][1];
	Vector A=Vector.minus(A0,A1);
	Vector B0=V[HALF][0];
	Vector B1=V[HALF][1];
	Vector B=Vector.minus(B0,B1);
	double d=Vector.angle(A,B);
	return d;
    }

    /**This tells whether the halfway bend is forward or back slanting.*/

    public double slant() {
	double test=ZIG[HALF][0].x-ZIG[HALF][1].x;
	return test;
    }



    public double[] displacement() {
      Vector[] V=kiteEdge();
      Vector W1=Vector.plus(V[0],V[2]);
      Vector W2=Vector.plus(V[1],V[3]);
      W1=W1.scale(.5);
      W2=W2.scale(.5);
      double[] a1=view(W1);
      double[] a2=view(W2);
      double[] A={a2[0]-a1[0],a2[1]-a1[1]};
      return A;
    }



    public double[] halfwayAngles() {
	double x=ZIG[0][0].x-ZIG[0][1].x;
	double y=ZIG[HALF][0].x-ZIG[HALF][1].x;
	double[] R={-x,-y};
	return R;
    }

    /**This gets the projection onto the
       plane spanned by the first bend and the halfway bend direction*/

    public double[] view(Vector V) {
	Vector[] W=kiteEdge();
	Vector A=Vector.minus(W[0],W[2]);
	Vector B=Vector.minus(W[1],W[3]);
	B=B.unit();
	Vector C=Vector.cross(A,B);
	Vector V2=C.proj(V);
	double d1=Vector.dot(A,V2);
	double d2=Vector.dot(B,V2);
	double d3=Vector.dot(C,V);
      	double[] d={d2,-d1,d3};
	return d;
    }


    

    /**These routines are designed to help choose the
       halfway bend line so that it is perpendicular to the
       first bendline*/


    public void makeOrtho() {
	int h=HALF;
	double a0=-2;
	double a1=0;
	double a2=2;
	double test=1;
	int g=GLUE[h];
	
	for(int i=0;i<50;++i) {
	    a1=(a0+a2)/2;
	    double test0=testOrtho(a0);
	    double test1=testOrtho(a1);
	    double test2=testOrtho(a2);
	    if(test0*test1>0) a0=a1;
	    if(test1*test2>0) a2=a1;
	}
	Complex W=new Complex(ZIG[h][g]);
	ZIG[h][g].x=ZIG[h][g].x+a1;
	for(int i=0;i<NUM;++i) {
	    if(Complex.dist(ZIG[i][g],W)<.0000001) ZIG[i][g]=new Complex(ZIG[h][g]);
	}
	addGeometry();
    }

    public double testOrtho(double t) {
	int h=HALF;
	int g=GLUE[h];
        PaperMobius Q=new PaperMobius(this);
	Q.ZIG[h][g].x=ZIG[h][g].x+t;
	Q.addGeometry();
	double a=Math.PI/2-Q.globalAngle();
	return a;
    }

    /**symmetrize*/
    
    public void symmetrize() {
	PaperMobius P=new PaperMobius(this);
	int h=HALF;
	Complex z=Complex.plus(ZIG[h][0],ZIG[h][1]);
	for(int i=h+1;i<2*h+1;++i) {
	    ZIG[i][0]=Complex.minus(z,ZIG[2*h-i][1]);
	    ZIG[i][1]=Complex.minus(z,ZIG[2*h-i][0]);
	}
	NUM=2*h+1;
	addGeometry();
    }

    /**check legit*/

    public boolean isLegit() {
	for(int i=0;i<NUM-1;++i) {
	    if(ZIG[i][0].x>ZIG[i+1][0].x+.0000000001) return false;
	    if(ZIG[i][1].x>ZIG[i+1][1].x+.0000000001) return false;
	}
	return true;
    }


    /**checks if the paper mobius band is a kite buster*/

    public boolean kiteBuster() {
	Vector[] V=kiteEdge();
	Path2D.Double gp=new Path2D.Double();
	double[][] a=new double[6][2];
	for(int i=0;i<4;++i) {
	     a[i]=view(V[i]);
	     if(i==0) gp.moveTo(a[i][0],a[i][1]);
	     if(i!=0) gp.lineTo(a[i][0],a[i][1]);
	}
	
	Vector[] W=core();
	for(int i=0;i<HALF;++i) {
	    double[] b=view(W[i]);
	    if(gp.contains(b[0],b[1])==false) return true;
	}
	return false;
    }

    public void print() {

	double a=ZIG[0][1].x-ZIG[0][0].x;
	double b=ZIG[1][1].x-ZIG[0][1].x;
	double c=ZIG[2][0].x-ZIG[0][0].x;
	double d=ZIG[3][1].x-ZIG[1][1].x;
	double e=ZIG[4][0].x-ZIG[4][1].x;
	double[] A={a,b,c,d,e};
	System.out.println("--------------------------------");
	for(int i=0;i<5;++i) System.out.println(A[i]);

    }

}



