import java.awt.event.*;
import java.awt.*;
import java.awt.geom.*;


public class PaperMobiusRandom {


    
    /**random generation*/

    public static PaperMobius random(int k) {
	double[] a=new double[k];
	boolean test=false;
	while(test==false) {
	   for(int i=0;i<k;++i) a[i]=1.2*Math.random();
	   PaperMobius P=fromList(a);
           test=P.isLegit();
	   if(test==true) {
	       double len=P.coreLength();
	       if(len<Math.sqrt(3)-Math.PI/4) return P;
	       else test=false;
	   }
	}
	return null;
    }

    public static PaperMobius fromList(double[] a) {
	PaperMobius P=new PaperMobius();
	int l=a.length;
	P.NUM=2*l+1;
	P.HALF=l+1;
	
	P.ZIG[0][0]=new Complex(0,0);
	P.ZIG[0][1]=new Complex(0,1);
	P.ZIG[1][0]=new Complex(0,0);
	
	for(int i=0;i<P.NUM+2;++i) {
	    P.BEND[i]=1;
	    P.GLUE[i]=i%2;
	    P.ZIG[i][0]=new Complex(2,0);
	    P.ZIG[i][1]=new Complex(2,1);
	}
	
	P.ZIG[0][0]=new Complex(0,0);
	P.ZIG[0][1]=new Complex(0,1);
	P.ZIG[1][0]=new Complex(0,0);
	
	for(int i=0;i<l;++i) {
	    if(i%2==0) {
	       P.ZIG[i+1][1]=new Complex(a[i],1);
	       P.ZIG[i+2][1]=new Complex(a[i],1);
	    }
	    if(i%2==1) {
	       P.ZIG[i+1][0]=new Complex(a[i],0);
	       P.ZIG[i+2][0]=new Complex(a[i],0);
	    }
	}
	P.addGeometry();
      	P.makeOrtho();
      	P.symmetrize();
	return P;
    }



    
}



