import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener,KeyListener {
    Manager M;
    int SELECT,ZONE;
    PaperMobius PAP;
    EnhancedSlider ANGLE;
    ColorHelp CH;
    ListenSquare GO,STOP;
    SelectInteger HALF;
    ListenSquare CONTROL;
    ListenSquare LEFT,RIGHT;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(90,1200,600,600);
	 SELECT=0;
	 ANGLE=new EnhancedSlider(0,0,800,30,400,new Color(200,0,200),"");
	 CH=new ColorHelp(0,50);
	 HALF=new SelectInteger(350,50,40,20,1,1,12,1);
	 CONTROL=new ListenSquare(0,0,800,80);
	 LEFT=new ListenSquare(600,50,20,20);
	 RIGHT=new ListenSquare(630,50,20,20);
	 initBend(2);
	 ZONE=-1;
     }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawPlan(g);
      try{drawFaces(g);}
      catch(Exception e) {}
      drawBends(g);
      drawZones(g);
      drawControls(g);
      PAP.print();
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(80,90,100));
        g.fillRect(0,0,getWidth(),getHeight());
    }


    public void drawControls(Graphics2D g) {
	CONTROL.w=this.getWidth();
	CONTROL.render(g,new Color(40,50,60));
	ANGLE.render(g);
	CH.render(g);
        double d=ANGLE.getValue();
        d=2*d-1;
        Double D=new Double(d);
        g.setColor(Color.white);
        g.setFont(new Font("Helvetica",Font.PLAIN,20));
        g.drawString("bending angle "+D.toString()+" \u03C0",50,25);
	HALF.render(g,Color.blue,Color.white,Color.white);
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString("(i)insert",450,70);
	RIGHT.render(g,Color.blue);
	LEFT.render(g,Color.blue);
    }
    

    public void initBend(int k0) {
	PAP=new PaperMobius();
	int k=k0+1;
	double a=Math.tan(Math.PI/(2*k));
	double[] x0=new double[k0+2];
	double[] x1=new double[k0+2];

	for(int i=0;i<k0+2;++i) {
	    int t0=i+i%2;
	    int t1=i-i%2+1;
	    if(i==k0+1) --t0;
	    x0[i]=t0*a;
	    x1[i]=t1*a;
	}
	
	PAP.ZIG[0][0]=new Complex(0,0);
	PAP.ZIG[0][1]=new Complex(0,1);
	PAP.BEND[0]=0;
	
	for(int i=0;i<k0+2;++i) {
	    PAP.ZIG[i+1][0]=new Complex(x0[i],0);
	    PAP.ZIG[i+1][1]=new Complex(x1[i],1);
	    PAP.BEND[i+1]=1;
	    PAP.GLUE[i]=i%2;
	}
	PAP.NUM=k0+3;
	HALF.val=k0/2+1;
	PAP.HALF=HALF.val;
	PAP.addGeometry();
    }


    public void initBendRandom(int k) {
	PAP=new PaperMobius();
	PAP=PaperMobiusRandom.random(k);
	HALF.val=PAP.HALF;

    }





    

    public void drawPlan(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	gp.moveTo(-1,0);
	gp.lineTo(-1,1);
	gp.lineTo(3,1);
	gp.lineTo(3,0);
	gp=transform2(gp);
	g.setColor(Color.white);
	g.fill(gp);
	g.setColor(Color.black);
	g.draw(gp);
    }


    /*ZONES:  these determine the action of the mouse*/

    public double[][] zone() {
	double[][] y={{0,.3},{.3,.7},{.7,1}};
       return y;
    }
    
    public void setZone() {
	ZONE=-1;
	double y=SOURCE.y;
        double[][] yy=zone();
	for(int i=0;i<yy.length;++i) {
	    if((y>yy[i][0]) && (y<yy[i][1])) ZONE=i;
	}
    }


    public void drawZones(Graphics2D g) {
	double[][] y=zone();
	Path2D.Double p=new Path2D.Double();
	p.reset();
	  for(int i=0;i<y.length;++i) {
	      p.moveTo(-1,y[i][0]);
	      p.lineTo(3,y[i][0]);
	      p.moveTo(-1,y[i][1]);
	      p.lineTo(3,y[i][1]);
	  }
	  p=transform2(p);
	  g.setColor(new Color(0,0,0,100));
	  g.draw(p);


	  if(ZONE!=-1) {
	      p.reset();
	      double y1=y[ZONE][0];
	      double y2=y[ZONE][1];
	      p.moveTo(-1,y1);
	      p.lineTo(-1,y2);
	      p.lineTo(3,y2);
	      p.lineTo(3,y1);
	      p.closePath();
	      p=transform2(p);
	      g.setColor(new Color(255,255,255,50));
	      g.fill(p);
	  }
	  
	  p.reset();
	  p.moveTo(0,.5);
	  p.lineTo(2,.5);
	  double a=Math.sqrt(3);
	  double lambda=1.649497;
	  double[] x={0,lambda/2,a/2,a-lambda/2,a,a+lambda};
	  Color[] C={Color.white,Color.cyan,Color.yellow,new Color(150,150,150),Color.cyan,Color.yellow};
	  for(int i=0;i<x.length;++i) {
	      p.moveTo(x[i],0);
	      p.lineTo(x[i],1);
	  }
	  p=transform2(p);
	  g.setColor(Color.black);
	  g.draw(p);

    }
    /**end of zones*/



    
    /**Highlighting the selected bend*/
    public void drawBends(Graphics2D g) {
	try{highlightBend(g,SELECT,Color.white);}
	catch(Exception e) {}
    }

    public void highlightBend(Graphics2D g,int i,Color C) {
	Path2D.Double p=new Path2D.Double();
	if(i<0) return;
	p.moveTo(PAP.ZIG[i][0].x,PAP.ZIG[i][0].y);
	p.lineTo(PAP.ZIG[i][1].x,PAP.ZIG[i][1].y);
  	p=transform2(p);
        g.setStroke(new BasicStroke(5));
        g.setColor(Color.black);
	g.draw(p);
        g.setStroke(new BasicStroke(2));
        g.setColor(C);
	g.draw(p);
	g.setStroke(new BasicStroke(1));
    }
    /**end highlight of bends*/

    

    public void drawFaces(Graphics2D g) {
	Path2D.Double gp=new Path2D.Double();
	int lim=PAP.NUM-1;
	for(int i=0;i<lim;++i) {
	    gp.reset();
	    Vector V0=PAP.V0[i][0];
	    Vector W0=PAP.V0[i][1];
	    double[] a0=view(V0);
 	    double[] b0=view(W0);
            gp.moveTo(a0[0],a0[1]);
	    gp.lineTo(b0[0],b0[1]);
	    Vector V1=PAP.V0[i+1][0];
	    Vector W1=PAP.V0[i+1][1];
	    double[] a=view(V1);
	    double[] b=view(W1);
	    gp.lineTo(b[0],b[1]);
	    gp.lineTo(a[0],a[1]);
	    gp.closePath();
	    gp=transform2(gp);
	    Color COL=getColor(i);
	    g.setColor(COL);
	    g.fill(gp);
	    g.setColor(new Color(150,150,150));
	    g.draw(gp);
	}
    }


    public Color getColor(int i) {
	    int j=i;
	    int choice=0;
	    if(i>=HALF.val) {
		j=i-HALF.val;
		choice=1;
	    }
	    Color COL=CH.getColor(choice,j);
	    return COL;
    }

    public double[] view(Vector V) {
	double[] d={V.x[0],V.x[1]};
	return d;
    }




    /***Geometry change routines************/
    
    public void changeBandGeometry(Complex s) {
	int index=closestBend();
	if(index==-1) return;
	if(index!=-1) SELECT=index;


	if(ZONE==0) {
	    Complex W0=new Complex(PAP.ZIG[index][0]);
	    Complex W=BendHelp.interpolate0(PAP.ZIG[index],s);
	    PAP.ZIG[index][0]=new Complex(W);
	    for(int i=0;i<PAP.NUM;++i) {
		double test=Complex.dist(PAP.ZIG[i][0],W0);
		if(test<.0000001) PAP.ZIG[i][0]=new Complex(W);
	    }
	    PAP.ZIG[0][1]=Complex.minus(new Complex(0,1),PAP.ZIG[0][0]);
	}

	if(ZONE==2) {
	    if(index==0) return;
	    Complex W0=new Complex(PAP.ZIG[index][1]);
	    Complex W=BendHelp.interpolate1(PAP.ZIG[index],s);
	    PAP.ZIG[index][1]=new Complex(W);
	    if(index==0) PAP.ZIG[index][0]=Complex.minus(new Complex(0,1),W);
	    for(int i=0;i<PAP.NUM;++i) {
		double test=Complex.dist(PAP.ZIG[i][1],W0);
		if(test<.0000001) PAP.ZIG[i][1]=new Complex(W);
	    }
	}

	//forces the first edge to be vertical
	if(M.C.RESTRICT.L[0].on==1) {
	    Complex W0=new Complex(PAP.ZIG[0][0]);
	    PAP.ZIG[0][0]=new Complex(0,0);
	    PAP.ZIG[0][1]=new Complex(0,1);
	    for(int i=0;i<PAP.NUM;++i) {
		double test=Complex.dist(PAP.ZIG[i][0],W0);
		if(test<.0000001) PAP.ZIG[i][0]=new Complex(0,0);
	    }
	    PAP.ZIG[0][1]=Complex.minus(new Complex(0,1),PAP.ZIG[0][0]);
	}

	if(ZONE==1) {
	    ANGLE.forceValue(PAP.BEND[SELECT]);
	}
	PAP.addGeometry();
    }

    public void makePerpendicular() {
	if(M.C.RESTRICT.L[1].on==0) return;
	PAP.makeOrtho();
    }
    public void changeBend(double t) {
	if(SELECT<1) return;
	PAP.BEND[SELECT]=t;
	PAP.addGeometry();
    }

    /**********End of geometry change routines***********/

    /***parallel move*/

    public void parallelMove(int choice) {
	double s=.001*choice;
	System.out.println(SELECT);

	Complex W0=new Complex(PAP.ZIG[SELECT][0]);
	Complex W=Complex.plus(W0,new Complex(s,0));

        for(int i=0;i<PAP.NUM;++i) {
	    double test=Complex.dist(PAP.ZIG[i][0],W0);
	    if(test<.0000001) PAP.ZIG[i][0]=new Complex(W);
	}

	W0=new Complex(PAP.ZIG[SELECT][1]);
	W=Complex.plus(W0,new Complex(s,0));

        for(int i=0;i<PAP.NUM;++i) {
	    double test=Complex.dist(PAP.ZIG[i][1],W0);
	    if(test<.0000001) PAP.ZIG[i][1]=new Complex(W);
	}
	
	PAP.addGeometry();


    }

    

    /**combinatorics changing routines*/

    public void bendModify(int choice) {

	if(ZONE!=1) return;
	
	int w=PAP.detectWedge(SOURCE);
	
	if(w==-1) return;
	if(choice==1) PAP=PaperMobiusCombinatorics.modify1(M.P.PAP,w);
	HALF.val=PAP.HALF;

	if(choice==2) {
            double test=Math.abs(w-SELECT);
	    if(test<1.5)  PAP=PaperMobiusCombinatorics.modify2(M.P.PAP,SELECT);
	    HALF.val=PAP.HALF;
	}

	if(choice==3) {
            double test=Math.abs(w-SELECT);
	    if(test<1.5)  PAP=PaperMobiusCombinatorics.modify3(M.P.PAP,SELECT);
	}

    }
    /**********End of combinatorics change routines***********/
    

    public int closestBend() {
	double dist=10;
	int index=-1;
	for(int i=0;i<PAP.NUM;++i) {
	    double test=Complex.absArea(SOURCE,PAP.ZIG[i][0],PAP.ZIG[i][1]);
	    if(test<dist) {
		dist=test;
		index = i;
	    }
	}
	if(dist>.1) index=-1;
	return index;
    }

    public void doControls(Point X) {
	CH.process(X,M.C.CS.C);
	HALF.modify(X);
	PAP.HALF=HALF.val;
	ANGLE.configure(X);
       	if(X.y<40) changeBend(ANGLE.getValue());
	if(LEFT.inside(X)==1) parallelMove(-1);
	if(RIGHT.inside(X)==1) parallelMove(+1);
	M.repaint();
    }

    
    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
	ANGLE.activate(J.X);
	M.repaint();
    }
    

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    doControls(J.X);
	    return;
	}
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	
	SOURCE=unTransform2(J.X);
	setZone();
	if(J.mode==2) changeBandGeometry(SOURCE);
	makePerpendicular();
	M.repaint();
    }
    

    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    doControls(J.X);
	    return;
	}
	SOURCE=unTransform2(J.X);
	setZone();
	if(J.mode==2) changeBandGeometry(SOURCE);
	makePerpendicular();
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}


    public void keyPressed(KeyEvent e) {    }

    public void keyReleased(KeyEvent e) {    }

    public void keyTyped(KeyEvent e) {
	char ch=e.getKeyChar();
	if(ch=='1') bendModify(1);
	if(ch=='2') bendModify(2);
	if(ch=='3') bendModify(3);
	M.repaint();
    }






    
}

