import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PlotCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] PLOT=new Complex[1000000];
    Color[] COL=new Color[1000000];
    int COUNT=0;
    EnhancedSlider ANGLE,EXCESS;
    ControlPanel PUSH,TIP,CONSTRAIN;
    double[] R=new double[3];
    double SLOPE;
    Complex[] CHAIN=new Complex[5];
    double[] LIST=new double[7];
    ListenSquare CONTROL;
    double[] BBOX=new double[4];

     public PlotCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(350,550,500);
	 ANGLE=new EnhancedSlider(0,10,600,30,100,new Color(0,0,255),"angle");
	 EXCESS=new EnhancedSlider(0,60,600,30,0,new Color(200,0,200),"slack tolerance");
	 SLOPE=0;
	 for(int i=0;i<5;++i) CHAIN[i]=new Complex(0,0);
	 CONTROL=new ListenSquare(0,0,700,200);
	 setPanels();
     }
    
    public void setPanels() {

       Color[] C0={new Color(80,120,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};
	
        String[] BumpString={"xmin",
			     "xmax",
			     "ymin",
			     "ymax",
                             "push"};
        int[] BumpState={1,0,0,0};
        PUSH=new ControlPanel(C0,BumpString,BumpState,4);
	PUSH.mode=0;


        String[] TipString={"left",
			    "right","endpoint"};
        int[] TipState={0,1};
        TIP=new ControlPanel(C0,TipString,TipState,2);
	TIP.mode=0;

	
        String[] ConstrainString={"basic","crosshatch","perimeter","constraints"};
        int[] ConstrainState={1,1,1};
        CONSTRAIN=new ControlPanel(C0,ConstrainString,ConstrainState,3);
	CONSTRAIN.mode=0;
    }


    public int[] getMask() {
	int[] A=new int[3];
	for(int i=0;i<3;++i) {
	    A[i]=CONSTRAIN.L[i].on;
	}
	return A;
    }
    

    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        drawBG(g);
	drawTrial(g);
	drawPlot(g);
	drawControls(g);
      }


    public PolygonWrapper parallelogram(double d1,double d2,double d3,double d4) {
	double[][] P=NumericalStudy2.parametersToShape(LIST,0);
	double th=5*Math.PI/12;
	double x=Math.cos(th);
	double y=Math.sin(th);
	Complex[] Z=new Complex[4];
        Z[0]=new Complex(P[0][0]+d1,P[0][1]+d2);
	Z[1]=new Complex(P[0][0]+d3,P[0][1]+d2);
	Z[2]=new Complex(P[0][0]+d3-d4*x,P[0][1]+d2-d4*y);
	Z[3]=new Complex(P[0][0]+d1-d4*x,P[0][1]+d2-d4*y);
	return new PolygonWrapper(4,Z);
    }





    
    public void drawControls(Graphics2D g) {
	CONTROL.render(g,new Color(0,0,100));
	ANGLE.render(g);
	EXCESS.render(g);
	Double a=getExcess();
	g.setColor(Color.white);
	g.setFont(new Font("Helvetica",Font.PLAIN,14));
	g.drawString(a.toString(),250,80);
	PUSH.render(g,5,110,100);
	TIP.render(g,110,110,100);
	CONSTRAIN.render2(g,215,110,100);
    }

    public void drawTrial(Graphics2D g) {
	double theta=getAngle();
	double[][] P=NumericalStudy2.parametersToShape(LIST,theta);
	Path2D.Double p=new Path2D.Double();

	p.moveTo(P[0][0],P[0][1]);
	p.lineTo(P[3][0],P[3][1]);
	p.moveTo(P[2][0],0);
	p.lineTo(-P[2][0],0);
	p=transform(p);
	g.setColor(new Color(255,160,0));
	g.draw(p);

	p.reset();
	p.moveTo(P[1][0],P[1][1]);
	p.lineTo(P[4][0],P[4][1]);
	p=transform(p);
	g.setColor(new Color(60,120,255));
	g.draw(p);
	
	p.reset();
	p.moveTo(P[0][0],P[0][1]);
	p.lineTo(P[1][0],P[1][1]);
	p.lineTo(P[2][0],P[2][1]);
	p.moveTo(P[3][0],P[3][1]);
	p.lineTo(P[4][0],P[4][1]);
	p.lineTo(P[5][0],P[5][1]);
	p=transform(p);
	g.setColor(Color.white);
	g.draw(p);

	p.reset();
	p.moveTo(P[0][0],.5*(P[0][1]+P[3][1]));
	p.moveTo(P[0][0]+1,.5*(P[0][1]+P[3][1])+1);
	p=transform(p);
	g.setColor(Color.green);
	g.draw(p);
	
	
    }

    public double getAngle() {
	double a=ANGLE.getValue();
	return .5*Math.PI*a;
    }

    
    public double getExcess() {
	double a=EXCESS.getValue();
	return a/5;
    }

    
    
    public void drawBG(Graphics2D g) {
	g.setColor(new Color(50,70,90));
        g.fillRect(0,0,getWidth(),getHeight());
	Path2D.Double p=new Path2D.Double();
	p.moveTo(-1,0);
	p.lineTo(1,0);
	p.moveTo(0,-1);
	p.lineTo(0,1);
	p=transform(p);
	g.setColor(new Color(60,120,255));
	g.draw(p);
	g.setColor(Color.white);
	
    }

    public void drawSlopeTriangle(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	double b=-1/Math.sqrt(3);
	double a=2*Math.sqrt(3)/7;
	double c1=.25*(-3+2*Math.sqrt(3));
	double c2=(1.0/3)*(-3+Math.sqrt(3));
	p.moveTo(0,0);
	p.lineTo(0,b);
	p.moveTo(0,0);
	p.lineTo(a,-a/2);
	p.moveTo(0,b);
	p.lineTo(a,-a/2);
	p.moveTo(0,b);
	p.lineTo(c1,c2);
	p.moveTo(c1,c2);
	p.lineTo(3.0/7,-3.0/14);
	p=transform(p);
	g.setColor(Color.red);
	g.draw(p);
	double[] s=M.P.PAP.halfwayAngles();
	fillPoint(g,new Complex(s[0],s[1]),.005,new Color(255,200,0),16);
    }

    public void drawPlot(Graphics2D g) {
	double d=.001;
	for(int i=0;i<COUNT;++i) {
	    fillPoint(g,PLOT[i],d,COL[i],8);
	}
    }

    

    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
       ANGLE.activate(J.X);
       EXCESS.activate(J.X);
    }
    
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
	    ANGLE.configure(J.X);
	    EXCESS.configure(J.X);
	    CONSTRAIN.toggle(J.X);
	    PUSH.switchMode(J.X);
	    TIP.switchMode(J.X);
	    repaint();
	    return;
	}
	if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	SOURCE.print();
	repaint();
    }
    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
    
     public void mouseDragged(MouseEvent e) {
        MouseData J=MouseData.process(e);
	SOURCE=unTransform(J.X);
	ANGLE.configure(J.X);
	EXCESS.configure(J.X);
	repaint();
     }

}

