import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class SpaceCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
    Manager M;
    Complex[] PLOT=new Complex[100000];
    Color[] COL=new Color[100000];
    int COUNT=0;

     public SpaceCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(100,400,200);
     }
    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
        drawBG(g);
	drawStatus(g);
        drawMobius(g);
        drawFrame(g);
        drawCore(g);
        drawCoreAlt(g);
        drawMidpoints(g);
	drawSphere(g);
	drawBend(g);
      }

    
    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight());
    }

    
    public void drawStatus(Graphics2D g) {
	g.setStroke(new BasicStroke(10));
	double l=M.P.PAP.coreLength();
 	 Color C=new Color(0,200,0);
         double a=Math.sqrt(3);
	 double lambda=1.649497;
	if(l>a/2) C=new Color(255,200,0);
	if(l>a-lambda/2) C=new Color(150,150,150);
	g.setColor(C);
        g.drawRect(5,5,getWidth()-10,getHeight()-15);
	g.setStroke(new BasicStroke(1));
    }


    public void drawMobius(Graphics2D g) {
     	if(M.C.DISPLAY.L[1].on==1) drawMobius(g,0,M.P.PAP.HALF);
       	if(M.C.DISPLAY.L[2].on==1) drawMobius(g,M.P.PAP.HALF,M.P.PAP.NUM-1);
    }


    public void drawMobius(Graphics2D g,int START,int END) {
	Path2D.Double gp=new Path2D.Double();
	for(int i=START;i<END;++i) {
	    gp.reset();
	    Vector V0=M.P.PAP.V[i][0];
	    Vector W0=M.P.PAP.V[i][1];
	    double[] a0=view(V0);
 	    double[] b0=view(W0);
            gp.moveTo(a0[0],a0[1]);
	    gp.lineTo(b0[0],b0[1]);
	    Vector V1=M.P.PAP.V[i+1][0];
	    Vector W1=M.P.PAP.V[i+1][1];
	    double[] a=view(V1);
	    double[] b=view(W1);
	    gp.lineTo(b[0],b[1]);
	    gp.lineTo(a[0],a[1]);
	    gp.closePath();
	    gp=transform(gp);
	    Color COL=M.P.getColor(i);
	    COL=M.P.CH.trans(COL,M.C.TRANS.getValue());
	    g.setColor(COL);
	    g.fill(gp);
	    g.setColor(new Color(150,150,150));
	    g.draw(gp);
	}
    }


    
    public void drawBend(Graphics2D g) {
	if(M.C.DISPLAY.L[13].on==0) return;
	Path2D.Double gp=new Path2D.Double();
        int i=M.P.SELECT;
	 gp.reset();
	 Vector V0=M.P.PAP.V[i][0];
	 Vector W0=M.P.PAP.V[i][1];
	 double[] a0=view(V0);
 	 double[] b0=view(W0);
         gp.moveTo(a0[0],a0[1]);
	 gp.lineTo(b0[0],b0[1]);
	 gp=transform(gp);
	 Color COL=M.C.DISPLAY.M[13].C;
	 g.setColor(COL);
	 g.draw(gp);
    }


    public void drawCore(Graphics2D g) {
      	if(M.C.DISPLAY.L[3].on==1) drawCore(g,0,M.P.PAP.HALF);
       	if(M.C.DISPLAY.L[4].on==1) drawCore(g,M.P.PAP.HALF,M.P.PAP.NUM-1);
    }
    
    public void drawCore(Graphics2D g,int START,int END) {
	Path2D.Double gp=new Path2D.Double();
	Vector[] W=M.P.PAP.core();
	g.setStroke(new BasicStroke(3));
	
	for(int i=START;i<END;++i) {
	    gp.reset();
	    double[] a=view(W[i]);
	    gp.moveTo(a[0],a[1]);
	    a=view(W[i+1]);
	    gp.lineTo(a[0],a[1]);
            Color COL=M.P.getColor(i);
	    gp=transform(gp);
	    g.setColor(COL);
	    g.draw(gp);
	}
	g.setStroke(new BasicStroke(1));
    }

    public void drawCoreAlt(Graphics2D g) {
      	if(M.C.DISPLAY.L[10].on==1) drawCoreAlt(g,0,M.P.PAP.HALF);
       	if(M.C.DISPLAY.L[11].on==1) drawCoreAlt(g,M.P.PAP.HALF,M.P.PAP.NUM-1);
    }

    public void drawCoreAlt(Graphics2D g,int START,int END) {
	Path2D.Double gp=new Path2D.Double();
	Vector[] W=M.P.PAP.core2();
	g.setStroke(new BasicStroke(3));
	
	for(int i=START;i<END;++i) {
	    gp.reset();
	    double[] a=view(W[i]);
	    gp.moveTo(a[0],a[1]);
	    a=view(W[i+1]);
	    gp.lineTo(a[0],a[1]);
            Color COL=M.P.getColor(i);
	    gp=transform(gp);
	    g.setColor(COL);
	    g.draw(gp);
	}
	g.setStroke(new BasicStroke(1));
	Vector A0=W[END];
	Vector A1=M.P.PAP.V[0][0];
	double[] a0=view(A0);
	double[] a1=view(A1);
      	gp.reset();
	gp.moveTo(a0[0],a0[1]);
      	gp.lineTo(a1[0],a1[1]);
	g.setColor(new Color(140,140,140));
	gp=transform(gp);
	g.draw(gp);
	
    }



    /***drawing the sphere*/
    
    public void drawSphere(Graphics2D g) {
	if(M.C.DISPLAY.L[12].on==0) return;
	g.setColor(M.C.DISPLAY.M[12].C);
	g.setStroke(new BasicStroke(1));
	
	for(int i=0;i<40;++i) {
	    double theta=2*Math.PI*i/40;
	    Vector[] LIST=longitudeList(80,theta);
	    Path2D.Double gp=toPath(LIST);
	    gp=transform(gp);
	    g.draw(gp);
	}
	for(int i=0;i<40;++i) {
	    double psi=1.0*i/40;
	    Vector[] LIST=lattitudeList(80,psi);
	    Path2D.Double gp=toPath(LIST);
	    gp=transform(gp);
	    g.draw(gp);
	}
    }

    public static Vector[] longitudeList(int N,double theta) {
	Vector[] LIST=new Vector[N];
	for(int i=0;i<N;++i) {
	    double ss=1.0*i/(N-1);
	    ss=.5*Math.PI*((1-ss)*(-1)+ss);
	    double x=Math.cos(ss)*Math.cos(theta);
	    double y=Math.cos(ss)*Math.sin(theta);
	    double z=Math.sin(ss);
	    LIST[i]=new Vector(x,y,z);
	    LIST[i]=LIST[i].scale(.5);
	}
	return LIST;
    }
    
    public static Vector[] lattitudeList(int N,double psi0) {
	double psi=.5*Math.PI-Math.PI*psi0;
	Vector[] LIST=new Vector[N];
	for(int i=0;i<N;++i) {
	    double ss=2*Math.PI*i/(N-1);
	    double x=Math.cos(psi)*Math.cos(ss);
	    double y=Math.cos(psi)*Math.sin(ss);
	    double z=Math.sin(psi);
	    LIST[i]=new Vector(x,y,z);
	    LIST[i]=LIST[i].scale(.5);
	}
	return LIST;
    }


    Path2D.Double toPath(Vector[] LIST) {
	boolean active=false;
	Path2D.Double gp=new Path2D.Double();
	double step=LIST.length;
        for(int i=0;i<step;++i) {
  	   Vector U=new Vector(LIST[i]);
	   boolean viz=isVisible(U);
	   if(viz==false) active=false;
	       
	   if(viz==true) {
	     double[] s=view(U);
	     if(active==false) gp.moveTo(s[0],s[1]);
	     if(active==true) gp.lineTo(s[0],s[1]);
	     active=true;
	   }
	}
	return gp;
    }


    public boolean isVisible(Vector V) {
	Vector N=new Vector(0,1,0);
	double[] p=view(V);
	Vector P=new Vector(p[0],p[2],p[1]);
	double test=Vector.dot(P,N);
	if(test>0) return true;
	return false;
    }
    
    /**end drawing sphere*/
    
    
    public void drawFrame(Graphics2D g) {
	Path2D.Double gp0=new Path2D.Double();
	Path2D.Double gp1=new Path2D.Double();
	Path2D.Double gp2=new Path2D.Double();
	Path2D.Double gp3=new Path2D.Double();
	Vector[] V=M.P.PAP.kiteEdge();

	double[][] a=new double[6][2];
	for(int i=0;i<6;++i) {
	     a[i]=view(V[i]);
	     if(i==0) gp0.moveTo(a[i][0],a[i][1]);
	     if((i<4)&&(i!=0)) gp0.lineTo(a[i][0],a[i][1]);
	     if(i==0) gp1.moveTo(a[i][0],a[i][1]);
	     if(i==2) gp1.lineTo(a[i][0],a[i][1]);
	     if(i==1) gp2.moveTo(a[i][0],a[i][1]);
	     if(i==3) gp2.lineTo(a[i][0],a[i][1]);
	     if(i==4) gp3.moveTo(a[i][0],a[i][1]);
	     if(i==5) gp3.lineTo(a[i][0],a[i][1]);

	}
	gp0.closePath();
	gp0=transform(gp0);
	gp1=transform(gp1);
	gp2=transform(gp2);
	gp3=transform(gp3);
	g.setStroke(new BasicStroke(3));
	
	if(M.C.DISPLAY.L[5].on==1) {
	    g.setColor(M.C.DISPLAY.M[5].C);
	    g.draw(gp1);
	}
	if(M.C.DISPLAY.L[6].on==1) {
	    g.setColor(M.C.DISPLAY.M[6].C);
	    g.draw(gp2);
	}
	
	if(M.C.DISPLAY.L[7].on==1) {
	    g.setColor(M.C.DISPLAY.M[7].C);
	    g.draw(gp3);
	}
	
	if(M.C.DISPLAY.L[8].on==1) {
	    g.setColor(M.C.DISPLAY.M[8].C);
	    g.draw(gp0);
	}
	
	g.setStroke(new BasicStroke(1));
    }



    public void drawMidpoints(Graphics2D g) {
	if(M.C.DISPLAY.L[9].on==0) return;
	Vector[] V=M.P.PAP.kiteEdge();
	Vector W1=Vector.plus(V[0],V[2]);
	Vector W2=Vector.plus(V[1],V[3]);
	W1=W1.scale(.5);
	W2=W2.scale(.5);
	Color C=M.C.DISPLAY.M[9].C;
	viewPoint(g,W1,.01,C);
	viewPoint(g,W2,.01,C);
    }

    public void viewPoint(Graphics2D g,Vector V,double rad,Color C) {
	double[] v=view(V);
	Complex z=new Complex(v[0],v[1]);
        fillPoint(g,z,rad,C,32);
    }

    public double[] view(Vector V) {
	if(M.C.MODE.mode==0) return view0(V);
	return view1(V);
    }

    public double[] view0(Vector V) {
	Vector W=roll(V);
	W=yaw(W);
	W=pitch(W);
	double[] A={W.x[0],-W.x[2],W.x[1]};
	return A;
    }

    public double[] view1(Vector V) {
	Vector[] W=M.P.PAP.kiteEdge();
	Vector A=Vector.minus(W[0],W[2]);
	Vector B=Vector.minus(W[1],W[3]);
	A=A.unit();
	B=B.unit();
	Vector C=Vector.cross(A,B);
	Vector V2=C.proj(V);
	double d1=Vector.dot(A,V2);
	double d2=Vector.dot(B,V2);
	double d3=Vector.dot(C,V);
      	double[] d={-d1,-d2,d3};
	return d;
    }


    public Vector pitch(Vector V0) {
  	  double t=M.C.PITCH.getValue();
	  t=2*Math.PI*t;
	  Vector V=Vector.pitch(t,V0);
	  return V;
    }

    public Vector yaw(Vector V0) {
	double t=M.C.YAW.getValue();
	t=2*Math.PI*t;	
	Vector V=Vector.yaw(t,V0);
        return V;
    }

    public Vector roll(Vector V0) {
	double t=M.C.ROLL.getValue();
	t=2*Math.PI*t;	
	Vector V=Vector.roll(t,V0);
        return V;
    }

    public void mousePressed(MouseEvent e) {
	MouseData J=MouseData.process(e);
    }
    
    public void mouseClicked(MouseEvent e) {
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	SOURCE=unTransform(J.X);
	repaint();
    }
    
     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   
     public void mouseDragged(MouseEvent e) {
	 MouseData J=MouseData.process(e);
	 SOURCE=unTransform(J.X);
	 M.repaint();
     }


}

