import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors */


public class Vector {
    double[] x=new double[3];
    int tag;  //names the vertex of an auxiliary polygon

    public Vector(){}

    public Vector(double xx,double yy,double zz) {
	x[0]=xx;
	x[1]=yy;
	x[2]=zz;
    }

    public Vector(double[] xx) {
	x[0]=xx[0];
	x[1]=xx[1];
	x[2]=xx[2];
    }

    public Vector(Vector X) {
	x[0]=X.x[0];
	x[1]=X.x[1];
	x[2]=X.x[2];
	tag=X.tag;
    }
    
    public Vector(Complex z) {
	x[0]=z.x;
	x[1]=z.y;
	x[2]=1;
    }
    
    public static Vector plus(Vector V,Vector W) {
	return(new Vector(V.x[0]+W.x[0],V.x[1]+W.x[1],V.x[2]+W.x[2]));
    }

    public static Vector minus(Vector V,Vector W) {
	return(new Vector(V.x[0]-W.x[0],V.x[1]-W.x[1],V.x[2]-W.x[2]));
    }

    public Vector scale(double d) {
	Vector X=new Vector(this);
	for(int i=0;i<3;++i) X.x[i]=X.x[i]*d;
	return(X);
    }

    public Vector unit() {
	double d=this.norm();
	return this.scale(1/d);
    }
    
    public static double dist(Vector V1,Vector V2) {
	Vector X=Vector.minus(V1,V2);
	return X.norm();
    }

    public static double  dot(Vector v,Vector w) {
	return(v.x[0]*w.x[0]+v.x[1]*w.x[1]+v.x[2]*w.x[2]);
    }


    public double norm() {
	return(Math.sqrt(dot(this,this)));
    }

    public static double angle(Vector V,Vector W) {
	double d=dot(V.unit(),W.unit());
	return Math.acos(d);
    }

    /**This projects the vector onto the orthogonal complement */
        
    public Vector proj(Vector W) {
	Vector V1=this.unit();
	double d=dot(V1,W);
	Vector V2=V1.scale(d);
	Vector X=minus(W,V2);
	return(X);
    }

    /**This does reflection*/

    public static Vector reflect(Vector V1,Vector V2,Vector W) {
	Vector V=Vector.cross(V1,V2);
	double d1=Vector.dot(V,W);
	double d2=Vector.dot(V,V);
	Vector X=Vector.minus(W,V.scale(2*d1/d2));
	return X;
    }

    public static Complex reflect(Complex v1,Complex v2,Complex w) {
	Vector V1=new Vector(v1);
	Vector V2=new Vector(v2);
	Vector W=new Vector(w);
	Vector X=reflect(V1,V2,W);
	Complex x=new Complex(X.x[0]/X.x[2],X.x[1]/X.x[2]);
	return x;
    }

    public static Vector cross(Vector v,Vector w) {
	Vector X=new Vector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }

    public static Vector findCross(Vector v1,Vector v2,Vector v3,Vector v4) {
	Vector v5=cross(v1,v2);
	Vector v6=cross(v3,v4);
	Vector v7=cross(v5,v6);
	return(v7);
    }

    public static Complex findCross(Complex z1,Complex z2,Complex z3,Complex z4) {
	Vector v1=new Vector(z1);
	Vector v2=new Vector(z2);
	Vector v3=new Vector(z3);
	Vector v4=new Vector(z4);
	Vector w=findCross(v1,v2,v3,v4);
	Complex z=new Complex(w.x[0]/w.x[2],w.x[1]/w.x[2]);
	return z;
    }


    /**Completes a vector to an orthonormal frame:  puts original vector last*/

    public Vector[] orthoFrame() {
	Vector V1=this.unit();
	Vector V2=V1.distinctVector();
	V2=Vector.cross(V1,V2);
	V2=V2.unit();
	Vector V3=Vector.cross(V1,V2);
	Vector[] V={V2,V3,V1};
	return V;
    }
    
	
    /**gets a distinct vector*/
    public Vector distinctVector() {
	int index=0;
	double test=0;
	double min=1000000;
	for(int i=0;i<3;++i) {
	    test=Math.abs(x[i]);
	    if(test<min) {
		index = i;
		min=test;
	    }
	}
	if(index==0) return new Vector(1,0,0);
	if(index==1) return new Vector(0,1,0);
	if(index==2) return new Vector(0,0,1);
	return null;
    }

    


    public static Vector cycle(Vector V) {
	return new Vector(V.x[2],V.x[0],V.x[1]);
    }


    public static Vector roll(double tt,Vector V0) {
	Vector V=cycle(V0);
	V=yaw(tt,V);
	V=cycle(cycle(V));
	return V;
    }

    public static Vector pitch(double tt,Vector V0) {
	Vector V=cycle(cycle(V0));
	V=yaw(tt,V);
	V=cycle(V);
	return V;
    }

    
    public static Vector yaw(double t,Vector V) {
	double c=Math.cos(t);
	double s=Math.sin(t);
        double x=V.x[0];
	double y=V.x[1];
        double xx=x*c+y*s;
        double yy=-x*s+y*c;
	double z=V.x[2];
	Vector W=new Vector(xx,yy,z);
	return W;
    }


    


    /**end coords for coordinate chart*/


    public void print() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]);
    }


}




