import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class ControlCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    PopupManager PM;
    SelectColor CS;
    ListenSquare GO,STOP;
    ControlPanelColor DISPLAY;
    ControlPanel MOVE,ELLIPSE,ACTION;
    ShapeEntryBasic F,G;
    Hillclimb H;
    OrbitControl OC;
    MotionControl MOT;
    LevelControl LEVEL;
    ListenSquare[] INFO=new ListenSquare[10];

     public ControlCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 CS=new SelectColor(M,0,349,389,50);
	 H=new Hillclimb();
	 GO=new ListenSquare(0,200,35,20);
	 STOP=new ListenSquare(0,220,35,20);
	 MOT=new MotionControl(0,300);
	 OC=new OrbitControl(220,0,Color.yellow);
	 LEVEL=new LevelControl(85,205,new Color(0,200,0));
	 setInfo();
	 setPanels();
     }

    public void setInfo() {
	INFO[0]=new ListenSquare(386,96,12,12);
	INFO[1]=new ListenSquare(0,288,12,12);
	INFO[2]=new ListenSquare(220,0,12,12);
	INFO[3]=new ListenSquare(220,115,12,12);
    }
    
    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

       Color[] C1={new Color(0,200,0),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};


	String[] DisplayString={"background",
                                "orbit",
                                "lines",
				"disks",
				"polygon",
				"ellipse 1",
				"ellipse 2",
				"curves",
                                "display"};
	Color[] DisplayColor={new Color(0,0,0),
                              new Color(255,255,255),
			      new Color(255,0,255),
			      new Color(0,200,150),
			      new Color(255,0,0,170),
	                      new Color(255,0,0),
			      new Color(50,100,255),
                              new Color(255,255,0)};
	
	int[] DisplayState={1,1,1,0,1,0,0,0,1};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,8,DisplayColor);

	String[] MoveString={"point 1","point 2","both","nearest","move choice"};
	int[] MoveState={0,0,0,1};
        MOVE=new ControlPanel(C0,MoveString,MoveState,4);
	MOVE.mode=3;

	String[] EllipseString={"no","yes","inscribed"};
	int[] EllipseState={1,0};
        ELLIPSE=new ControlPanel(C0,EllipseString,EllipseState,2);

	String[] ActionString={"find level","test","action"};
	int[] ActionState={1,0};
        ACTION=new ControlPanel(C1,ActionString,ActionState,2);

    }
    

    


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
      CS.render(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(new Color(150,0,150));
        g.fillRect(0,0,getWidth(),getHeight());
    }

    
    
    public void drawControls(Graphics2D g) {
	PM.render(g);
      CS.render(g);
      drawPanels(g);

      g.setFont(new Font("Helvetica",Font.PLAIN,14));
      g.setColor(Color.black);

      if(H.halt==true) GO.render(g,"go",12,3,new Color(0,200,0));
      if(H.halt==false) STOP.render(g,"stop",12,3,new Color(200,0,0));
      MOT.render(g);
      OC.render(g);
      INFO[1].infoRender(g);
      INFO[2].infoRender(g);
      INFO[3].infoRender(g);
      if(ACTION.mode==0) LEVEL.render(g);
    }


    public void drawPanels(Graphics2D g) {
      DISPLAY.render(g,85,0,130);
      ELLIPSE.render(g,0,0,80);
      ACTION.render(g,0,140,80);
      MOVE.render(g,0,55,80);
    }

    public void doGo() {
	if(ACTION.mode==1) {
	    doTest();
	    return;
	}
	H=new Hillclimb(this.M);
	new Thread(H).start();
    }

    public void doInfo(Point X) {
	if(INFO[0].inside(X)==1) DocControls.invariants(M.D);
	if(INFO[1].inside(X)==1) DocControls.motion(M.D);
	if(INFO[2].inside(X)==1) DocControls.orbit(M.D);
	if(INFO[3].inside(X)==1) DocControls.popups(M.D);
    }

    public void doTest() {
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);


	System.out.println("powers of the algebraic map");
	for(int i=1;i<3;++i) {
      	   A=Pentagram2.map(A);
	   System.out.print(i+"   ");
	   System.out.println(A[0]+" "+A[1]+" "+A[2]+" "+A[3]);
	}


	System.out.println("powers of the geometric map");
	PolyVector Q=Pentagram.map(3,1,M.P.POLY);
	for(int i=1;i<3;++i) {
	     double[] AA=PolyVectorSpecial.toDouble(Q);
	     System.out.print(i+"   ");
	     System.out.println(AA[0]+" "+AA[1]+" "+AA[2]+" "+AA[3]);
	     Q=Pentagram.map(3,1,Q);
	}

	
    }

    
    public void mouseClicked(MouseEvent e) {
	int test=0;
        test=CS.process(e);
	if(test==20) DocControls.colorSelector(M.D);
        MouseData J=MouseData.process(e);

	test=DISPLAY.process(J.X,CS.C);
	if(test==20) DocControls.display(M.D);
	test= MOVE.switchMode(J.X);
	if(test==20) DocControls.moveChoice(M.D);
	test=ELLIPSE.switchMode(J.X);
	if(test==20) DocControls.inscribed(M.D);
	test=ACTION.switchMode(J.X);
	if(test==20) DocControls.action(M.D);
	if(GO.inside(J.X)==1) doGo();
	if(STOP.inside(J.X)==1) H.halt=true;
	LEVEL.processMouse(e);
	MOT.process(this.M,J.X);
	boolean test2=OC.process(J.X);
	if(test2==true) M.P.computeOrbit();
	doInfo(J.X);
	PM.process(J.X);
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {}
     public void mouseReleased(MouseEvent e) {}
     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   
     public void mouseMoved(MouseEvent e) {}    
     public void mouseDragged(MouseEvent e) {
        CS.process(e); 
        MouseData J=MouseData.process(e);
	M.repaint();
     }



  public void keyTyped(KeyEvent e) {
      LEVEL.processKey(e);
      M.repaint();
     }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    

}

          
