import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

/**Documentation file*/

public class DocControls{


    public static void colorSelector(DocumentCanvas D) {

	String S="This is the color selector. You can either choose 1 of 32 preset colors or you can select the RGB and transparency values.  This color selector works in tandem with the SOL and LIE display control panels.  These display windows have a double column of buttons.  The left buttons (usually) control the colors and the right buttons (usually) toggle the display of the object.  Here is an example: Select the color yellow and then press the left button besides the 'curves' option on the SOL display window.  This will change the color of the drawn sphere to yellow.";

	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void action(DocumentCanvas D) {

	String S="This control panel selects the action of the GO button.  There are two options:\n\nIf the option is set to FIND LEVEL then the go button tries to find the level set corresponding to the values shown in the green/blue/pink interface.  Initially these values start at (3,4), which means that we want to find the level set where F1=3 and F2=4.  You can use the green/blue/pink interface to enter in different rational values for F1 and F2. You use the keyboard to do this.\n\nIf the option on this window is set to test, the computer performs whatever test I am currently running for debugging purposes. It is likely that the output of such a test will look like gibberish to any other user.  Just ignore this option.";

	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void orbit(DocumentCanvas D) {

	String S="This control panel lets you specify various features of the orbit you are plotting.  You can select the number of points to plot, the size of the points when they are plotted, the power of the map you consider, and the map offset.  The last feature needs more explanation.  Suppose you set the map power to n and the offset to k.  Then you will plot the iterates corresponding to the following powers of the map: k,k+n,k+2n,...  To just see the map itself set the power to 1 and the offset to 0.";

	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


    public static void invariants(DocumentCanvas D) {

	String S="This window shows the main invariants F and G for the orbits.  When the polygon has 4-fold rotational symmetry we have F^2=G.  The window also says when the initial polygon is convex.";
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


    public static void swapCoords(DocumentCanvas D) {

	String S="This control panel changes the coordinate projection in a special way.  Define\n\nI(a,b,c,d)=(c,d,a,b).\n\nWhen this feature is on, the computer pre-composes the projection with I.  Thus if the projection being shown is into the (a,b) plane then when the swap feature is on, the projection shown is into the (c,d) plane.  I did this to illustrate the fact that the projection of a level set into the (a,b) plane is the same as the projection of that level set into the (c,d) plane.";
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


    public static void motion(DocumentCanvas D) {

	String S="You can either change the polygon by dragging the mouse around on the picture window or else using this console here.  The left and right tic-tac-toe grids control the first and second point respectively.  If you click on the grids, the points are moved by a certain amount.  The amount is determined by the row of squares.  Every time you chchange squares by one along the row, you change the size of the move by a factor of 2.";
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


       public static void display(DocumentCanvas D) {

	String S="This control panel toggles various items that can be displayed. The left column of squares controls the colors and the right column toggles the display.  When you click on one of the left square, the color changes to the current value of the color selector.";
	S=S+"\n\nHere is a rundown of what you can display from this panel:";
	S=S+"\n\nbackground: You can change the background color.";
	S=S+"\n\norbit: You can change the orbit color.";
	S=S+"\n\nlines: This shows certain lines in the plane which are nicely situated with respect to the (a,b) and (c,d) projection of the orbit. When you use a different projection these lines won't mean anything. To get a good feeling for that these lines mean, consider the case when (a,b)=(c,d). Select BOTH on the MOVE CHOICE control panel and then drag the point around.";
	S=S+"\n\ndisks: This shows certain disks in the plane which are nicely situated with respect to the (a,b) and (c,d) projection of the orbit. Follow the same instructions for the lines display.";
	S=S+"\n\npolygon: This shows the selected 8-gon.  You move the red and blue points around to change the8-gon. This display works most naturally when you are using the (a,b) projection of the orbit.";
	S=S+"\n\nellipse1:  This displays the ellipse through the points (1,0), (0,1) (-1,0) (0,-1) and (a,b).";
	S=S+"\n\nellipse2:  This displays the ellipse through the points (1,0), (0,1) (-1,0) (0,-1) and (-d,c).  When the two ellipses coincide, the 8-gon is inscribed in a common ellipse.";
	S=S+"\n\ncurves: Using the FLOWLINES popup window, you can display a flowline to a vectorfield generated by the Hamiltonian of some linear combination of our invariant functions F and G.  This feature will only work when you have this window open.  Read more about this on the documentation for the FLOWLINES window.";

	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


    public static void moveChoice(DocumentCanvas D) {

	String S="You change the shape of the octagon by dragging with the middle mouse button on the picture window. This control panel lets you specify what action this dragging has. You can either drag the first point (a,b) or the second point (c,d) or both at the same time.  The program also displays the semi-transparent blue point (-d,c).  The octagon coordinates are:";
	S=S+"\n\n (1,0)\n(a,b)\n(0,1)\n(-d,c)\n(-1,0)\n(-a,-b)\n(0,-1)\n(d,-c).";

	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


    public static void projectChoice(DocumentCanvas D) {
	String S="The coordinates for the space of centrally symmetric octagons are given by (a,b,c,d). This point corresponds to the octagon with vertices";
	S=S+"\n\n (1,0)\n(a,b)\n(0,1)\n(-d,c)\n(-1,0)\n(-a,-b)\n(0,-1)\n(d,-c).";
	S=S+"\n\n When the computer plots the orbit you can use the two projection panels to plot the (i,j)th projection of the orbit.  Here both i and j can vary from 1 to 4.  Of course, if you set i=j you will get a boring plot.";


	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void mapChoice(DocumentCanvas D) {
	String S="This lets you see the orbit of either the 3-diagonal map or its inverse.  You can also change to a suitable power of the map using the map power arrow keys";
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


    public static void inscribed(DocumentCanvas D) {
	String S="When you turn on this feature, the computer will automatically project the octagon you select onto the space of inscribed octagons.  The orbit you see has one dimensional projections for all the choices.  To see this feature the best, set the map power 4, so that you are looking at iterates of the 4th power of the map.\n\nOne thing misleading about the orbit is that the hyperbolic dynamics cause it to leak onto nearby subsets of the unstable manifold. Thus, the orbit appears to lie in a union of two ellipses and two lines in the (a,b) or (c,d) projections, but in fact it lies in a single ellipse.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void popups(DocumentCanvas D) {
	String S="This is the popup window manager. If you click on one of the bars you bring up a new window. If you click the same bar twice, you will mess up the program. In this case, you should kill both instances of the popup and try again.  Each of the popup windows has a corresponding question box.  Click on this question box to get operating instructions for the popup window.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void instructions(DocumentCanvas D) {
	String S="This brings up the instruction window that you are currently reading.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void intrinsic(DocumentCanvas D) {
	String S="This window shows the plot of the torus level sets in their intrinsic geometric structure. We do this by integrating the hamiltonian vector fields.  The program shows parts of the universal covers of each of the 3 cylinders.";
	S=S+"\n\nTo get a feel for the controls, we first explain how our plot works.  We first pick a direction to integrate. Typically this direction goes nearly parallel to the axis of the cylinder.  We call this direction the spine.  You can use the red arrow keys to adjust the slope of the spine.  The red squares adjust how much a click on the red arrow keys effects the slope of the spine.";
	S=S+"\n\nOnce we find a good spine, we integrate along the vector field XG.  This is the vector field X2-X1 in the paper.  Typically this vector field is almost perpendicular to the spine.  The blue arrow keys control technical features of the plot, as follows:";
	S=S+"\n\ntime step: This controls the scale in the numerical integration scheme.  The larger this number the more precisely the numerical integration is done.";
	S=S+"\n\nmax steps: This controls the maximum number of steps the numerical integrator will take.  If K is showing, the max number of steps is 2^K.";
	S=S+"\n\nspacing: This controls how often you shoot off from the spine.  The larger the number the more accurate the plot.";
	S=S+"\n\nThe display panel lets you select which cylinders to plot.  The convex option will plot the set of points in the positive cylinder corresponding to convex 8-gons. This feature does not always work well.  When this window is open, and you select a cylinder to plot, the corresponding part of the orbit in the picture window changes color to match the cylinder.";
	S=S+"\n\nFinally, we mention that this window is designed to work with points in positive part of the parameter space.  For such points, all the invariants F1,F2,G are positive, and so are all the factors of these invariants.  If you pick a point outside these range, you might get garbage in this window.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void numerics(DocumentCanvas D) {
	String S="This displays the invariants F1,F2 and G=F2-F1.  We also display the component factors that go into our invariants. We also show the coordinates of the current point and whether or not it represents a convex 8-gon.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void flowlines(DocumentCanvas D) {
	String S="This window lets you choose a linear combination of the Hamiltonians X1 and X2 and see the corresponding flowline on the level set. For this option to work well, you should change the background to white on the picture window.  When you drag the point around the disk you select the combination you want.  The two crossing lines denote the positions X1+X2, -X1-X2, X1-X2, X2-X1.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }

    public static void projection(DocumentCanvas D) {

	String S="This control panel lets you change the projection.  You can move a point around the pink outer rim of the interface and you can also move a second point around the blue triangle.  The first point specifies a vector of form\n\nx1 e1 + x2 e2\n\nHere e1,e2 are the standard basis vectors in R4 and x1,x2 are components of a unit complex numbers.  The second point specifies a vector of the form\n\n m1 e1 + m2 e2 + m2 e3\n\n where m1+m2+m3=1 and all these numbers are non-negative.  The two vectors you get specify a coordinate projection into the plane.  You can also use the control panel to directly specify the projection.  Just play around with this for a while to get a feel for how it works.";
	
	try  {DocumentCanvas.setText(D,S);}
	catch(Exception e) {}
    }


}

