import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class FlowCanvas extends ScaleCanvas implements MouseListener,MouseMotionListener,KeyListener {
    Manager M;
    SelectInteger[] S=new SelectInteger[4];
    ListenSquare CONTROL;
    boolean drag;
    Point JX;
    Complex Z;
    
    public FlowCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 Z=new Complex(1/Math.sqrt(2),-1/Math.sqrt(2));
	 S[0]=new SelectInteger(80,10,40,20,12,1,25,1);//timestep;
	 S[1]=new SelectInteger(80,35,40,20,14,1,30,1);//time
	 CONTROL=new ListenSquare(0,0,170,60);
	 setScales(200,300,150);
	 Z=new Complex(Math.sqrt(.5),Math.sqrt(.5));
    }

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawDisk(g);
      drawControls(g);
   }





    public void drawControls(Graphics2D g) {
	CONTROL.render(g,new Color(50,100,255));
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
        g.setColor(Color.white);
        g.drawString("time step",5,25);
        g.drawString("total time",5,50);;
        for(int i=0;i<2;++i) S[i].render(g,Color.white,Color.white,Color.white);
    }


    public void drawDisk(Graphics2D g) {
	fillPoint(g,new Complex(0,0),1,new Color(0,0,200),512);
	Path2D.Double p=new Path2D.Double();
	p.moveTo(1,1);
	p.lineTo(-1,-1);
	p.moveTo(-1,1);
	p.lineTo(1,-1);
	p=transform(p);
	g.setColor(new Color(255,255,255,100));
	g.draw(p);
	fillPoint(g,Z,.04,Color.yellow,32);
	fillPoint(g,Z,.01,Color.black,32);
    }



    public void drawBG(Graphics2D g) {
	g.setColor(new Color(150,0,150));
	g.fillRect(0,0,this.getWidth(),this.getHeight());
    }

    public double getStep() {
	double t=Math.pow(.5,S[0].val);
	return t;
    }

    public int getTime() {
	double t=Math.pow(2,S[1].val);
	int n=(int)(t);
	return n;
    }



    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }
        
    public void doMouseClick(int mode) {
	if(CONTROL.inside(JX)==1) {
	    S[0].modify(JX);
	    S[1].modify(JX);
	    M.repaint();
	    return;
	}
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  SOURCE=unTransform(JX);
	M.repaint();
    }
    
    
    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) SOURCE=unTransform(J.X);
	Z=SOURCE.unit();
	M.repaint();
    }


    

    public void mousePressed(MouseEvent e) {
	drag=true;
    }
    
     public void mouseReleased(MouseEvent e) {
	 drag=false;
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }
    
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
	if(drag==true) {
	    SOURCE=unTransform(JX);
	    Z=SOURCE.unit();
	}
	M.repaint();
     }
    

  public void keyTyped(KeyEvent e) {
      char ch=e.getKeyChar();
      if(ch=='z') doMouseClick(1);
      if(ch=='x') doMouseClick(2);
      if(ch=='c') doMouseClick(3);  
      M.repaint();
     }

    public void keyPressed(KeyEvent e) {
	drag=true;
	M.repaint();
    }

    public void keyReleased(KeyEvent e) {
	drag=false;
	M.repaint();
    }

    
}


