import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class GradFlow {

    public static double[] X1(double[] A) {
	double a=A[0];
	double b=A[1];
	double c=A[2];
	double d=A[3];


	double[] x1={((1 + c - d)*(-(a*p(b,2)) + a*c - p(a,3)*c + a*p(b,2)*c - a*p(c,2) + p(a,3)*p(c,2) - 
        2*a*p(b,2)*d + 2*p(b,3)*d - c*d + p(a,2)*c*d - p(b,2)*c*d + 2*a*p(b,2)*c*d - 
        a*p(b,2)*p(d,2) + 2*p(b,3)*p(d,2)))/(b*c*d),
   ((1 + c - d)*(-(p(a,2)*b) - 2*p(a,3)*c + 2*p(a,2)*b*c + 2*p(a,3)*p(c,2) - 
        p(a,2)*b*p(c,2) - b*d - p(a,2)*b*d + p(b,3)*d + c*d + p(a,2)*c*d + 2*p(a,2)*b*c*d - 
        p(b,2)*c*d - b*p(d,2) + p(b,3)*p(d,2)))/(a*c*d),
   ((1 + a - b)*(-(a*b) + a*c - p(a,2)*c + a*b*p(c,2) - a*p(c,3) + p(a,2)*p(c,3) - 
        a*b*p(d,2) - c*p(d,2) + a*c*p(d,2) - 2*b*c*p(d,2) + 2*a*b*c*p(d,2) - 
        p(b,2)*c*p(d,2) + 2*b*p(d,3) + 2*p(b,2)*p(d,3)))/(a*b*d),
   ((1 + a - b)*(a*b + a*b*p(c,2) - 2*a*p(c,3) + 2*p(a,2)*p(c,3) - b*d - p(b,2)*d - 
        p(c,2)*d + 2*a*p(c,2)*d - p(a,2)*p(c,2)*d - b*p(c,2)*d + 2*a*b*p(c,2)*d - 
		 a*b*p(d,2) + b*p(d,3) + p(b,2)*p(d,3)))/(a*b*c)};

	return x1;
	

    }

    
    public static double[] X2(double[] A) {
	double a=A[0];
	double b=A[1];
	double c=A[2];
	double d=A[3];

	    double[] x2={((-1 + c - d)*(-(a*p(b,2)) - a*c + p(a,3)*c - a*p(b,2)*c - a*p(c,2) + p(a,3)*p(c,2) + 
        2*a*p(b,2)*d - 2*p(b,3)*d + c*d - p(a,2)*c*d + p(b,2)*c*d + 2*a*p(b,2)*c*d - 
        a*p(b,2)*p(d,2) + 2*p(b,3)*p(d,2)))/(b*c*d),
   ((-1 + c - d)*(-(p(a,2)*b) + 2*p(a,3)*c - 2*p(a,2)*b*c + 2*p(a,3)*p(c,2) - 
        p(a,2)*b*p(c,2) + b*d + p(a,2)*b*d - p(b,3)*d - c*d - p(a,2)*c*d + 2*p(a,2)*b*c*d + 
        p(b,2)*c*d - b*p(d,2) + p(b,3)*p(d,2)))/(a*c*d),
   ((-1 + a - b)*(a*b - a*c - p(a,2)*c - a*b*p(c,2) + a*p(c,3) + p(a,2)*p(c,3) + a*b*p(d,2) - 
        c*p(d,2) - a*c*p(d,2) + 2*b*c*p(d,2) + 2*a*b*c*p(d,2) - p(b,2)*c*p(d,2) - 
        2*b*p(d,3) + 2*p(b,2)*p(d,3)))/(a*b*d),
   -(((1 - a + b)*(-(a*b) - a*b*p(c,2) + 2*a*p(c,3) + 2*p(a,2)*p(c,3) + b*d - p(b,2)*d - 
          p(c,2)*d - 2*a*p(c,2)*d - p(a,2)*p(c,2)*d + b*p(c,2)*d + 2*a*b*p(c,2)*d + 
		   a*b*p(d,2) - b*p(d,3) + p(b,2)*p(d,3)))/(a*b*c))};
	return x2;
	}

    public static double[] XG(double[] A) {
	double[] x1=X1(A);
	double[] x2=X2(A);
	double[] g=new double[4];
	for(int i=0;i<4;++i) g[i]=x2[i]-x1[i];
	return g;
    }
    
    
    public static double[] flow(double[] A,Complex u,double step) {
	double[] B1=X1(A);
	double[] B2=X2(A);
	double[] B={0,0,0,0};
      	for(int i=0;i<4;++i) B[i]=A[i]+step*u.x*B1[i]+step*u.y*B2[i];
	return B;
    }

public static double p(double x,double k) {
    return Math.pow(x,k);
}


    /**This flows starting in the positive component. u should be unit complex*/

    public static double[][] getFlow(double[] A,Complex u,double step,int MAX) {
	    boolean test=true;
	    int count=0;
	    double[][] LIST=new double[(int)(MAX+2)][4];
	    double[] B={A[0],A[1],A[2],A[3]};
	    
	    while(test==true) {
	       if(testProperty(-1,A)==false) test=false;
	       //if(testProperty(0,A)==false) test=false;
	       B=flow(B,u,step);
	       LIST[count]=B;
	       if(count>MAX) test=false;
	       ++count;
	    }
	    double[][] LIST2=new double[count][4];
	    for(int i=0;i<count;++i) LIST2[i]=LIST[i];
	    return LIST2;
    }

    public static double[] getFlowTarget(double[] A,Complex u,double step,int NUM) {
	    boolean test=true;
	    int count=0;  
             double[] B={A[0],A[1],A[2],A[3]};
	    for(int i=0;i<NUM;++i) {
	       B=flow(B,u,step);
	    }
	    return B;
    }

    
    public static double getFlowSteps(double[] A,Complex u,double step,int MAX) {
	    boolean test=true;  
            double[] B={A[0],A[1],A[2],A[3]};
	    int count=0;
	    while(test==true) {
		A=flow(A,u,step);
		if(testProperty(-1,B)==false) test=false;
		//if(testProperty(0,B)==false) test=false;
	
	        if(count>MAX) test=false;
	        ++count;
	    }
	    return 1.0*count;
    }


    public static double getFlowTime(double[] A,Complex u,double step,int MAX) {
	double a=getFlowSteps(A,u,step,MAX);
	return a*Math.abs(step);
    }


    /**This flows along the given direction and returns the step values where the
       desired property (e.g. convexity) starts and stops*/
    
    public static int[] getPropertySteps(int PROP,double[] A0,Complex u,double step,int MAX) {
	    double[] A={A0[0],A0[1],A0[2],A0[3]};
	    boolean test=true;
	    int count=0;
	    int crossing=0;
	    int[] spec=new int[2];
	    spec[0]=-1;

	    boolean mem=testProperty(PROP,A);
	    if(mem==true) {
		spec[0]=0;
		crossing=1;
	    }

	    while(test==true) {
	        A=flow(A,u,step);
		boolean mem2=testProperty(PROP,A);
		if(mem!=mem2) {
		    spec[crossing]=count;
		    ++crossing;
                    mem=mem2;
		}
		if(testProperty(-1,A)==false) test=false;
		if((PROP==3)&&(testProperty(3,A)==false)) test=false;
		if(crossing>1) test=false;
	        if(count>MAX) test=false;
	        ++count;
	    }
	    if(spec[0]==0) return spec;
	    if(crossing<2) return null;
            return spec;
    }


    public static double[] getPropertyTimes(int PROP,double[] A,Complex u,double step,int MAX) {
	int[] a=getPropertySteps(PROP,A,u,step,MAX);
	double[] b=new double[2];
	if(a==null) return null;
	b[0]=a[0]*Math.abs(step);
	b[1]=a[1]*Math.abs(step);
	return b;
    }


    public static double[] getPropertyExample(int PROP,double[] A,Complex u,double step, int MAX) {
	int[] t=getPropertySteps(PROP,A,u,step,MAX);
 	int num=(t[0]+t[1])/2;
        double[] B=getFlowTarget(A,u,step,num);
	double[] C={B[0],B[1],B[2],B[3],num*step};
	return C;
    }



    public static boolean testProperty(int choice,double[] A) {
	
	if(choice==-1) {//not a number
	    for(int i=0;i<4;++i) {
		Double U=new Double(A[i]);
		if(U.isNaN()==true) return false;
	    }
	    return true;
	}
	
	if(choice==0) {//positivity
	    for(int i=0;i<4;++i) {
		if(A[i]<0) return false;
	    }
	    return true;
	}
	
	if(choice==1) {//negativity
	    for(int i=0;i<4;++i) {
		if(A[i]>0) return false;
	    }
	    return true;
	}

	if(choice==2) {
	    if(A[0]<0) return false;
	    if(A[1]>0) return false;
	    if(A[2]<0) return false;
	    if(A[3]>0) return false;
	    return true;
	}


	if(choice==3) {//convexity

	    //now try convexity
            PolyVector P=PolyVectorSpecial.fromDouble(A);
	    return P.isConvex();
	}
	return false;

    }



    

}







	







    




