import java.applet.Applet;
import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class Hillclimb implements Runnable {
    Manager M;
    boolean halt;

    public Hillclimb() {
	halt=true;
    }

    public Hillclimb(Manager MM) {
	this.M=MM;
	halt=true;
    }

    public void run() {
	int mode=M.C.ACTION.mode;
	if(mode==0) coerceLevel();
    }
    
    public void coerceLevel() {
	double min=1000;
	double[] CURRENT=PolyVectorSpecial.toDouble(M.P.POLY);
	
	
	halt=false;
	while(halt==false) {
	    double[] A=randomGuided(CURRENT);
	    double f1=M.C.LEVEL.F1.getParameter();
	    double f2=M.C.LEVEL.F2.getParameter();
	    double q=quality(f1,f2,A);
	    if(q<min) {
		min=q;
		CURRENT=copy(A);
		System.out.println("-------------");
		System.out.println("min "+min);
		M.P.POLY=PolyVectorSpecial.fromDouble(A);
		M.P.POINT[0]=new Complex(A[0],A[1]);
		M.P.POINT[1]=new Complex(A[2],A[3]);
		M.repaint();
	    }
	}
    }

    public double quality(double ff1,double ff2,double[] A) {
	double f1=Pentagram2.F1(A);
	double f2=Pentagram2.F2(A);
	double x=ff1-f1;
	double y=ff2-f2;
	double t=x*x+y*y;
	return t;
    }

    public double[] random() {
	double[] A=new double[4];
	for(int i=0;i<4;++i) A[i]=Math.random();
	return A;
    }

    public double[] randomGuided(double[] A) {
	double step=.01*Math.random();
	double[] B=new double[4];
	for(int i=0;i<4;++i) B[i]=A[i]+step*(.5-Math.random());
	return B;
    }


    public double[] copy(double[] A) {
	double[] B=new double[4];
	for(int i=0;i<4;++i) B[i]=A[i];
	return B;
    }



}
