import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of 3x3 matrices */


public class Matrix {
    double[][] a=new double[3][3];
    public Matrix(){}


    
    public Matrix(double[][] aa) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=aa[i][j];
	    }
	}
    }

    public Matrix(Vector[] V) {
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		this.a[i][j]=V[i].x[j];
	    }
	}
    }



    public static Matrix times(Matrix M1,Matrix M2) {
	Matrix M=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		M.a[i][j]=0;
		for(int k=0;k<3;++k) {
		    M.a[i][j]=M.a[i][j]+M1.a[i][k]*M2.a[k][j];
		}
	    }
	}
	return(M);
    }


    public void print() {

	System.out.println("matrix");
	System.out.println(a[0][0]+ " "+a[0][1]+" "+a[0][2]);
	System.out.println(a[1][0]+ " "+a[1][1]+" "+a[1][2]);
	System.out.println(a[2][0]+ " "+a[2][1]+" "+a[2][2]);
    }



    public double det() {

	double a1=a[0][0]*a[1][1]*a[2][2];
	double a2=a[0][1]*a[1][2]*a[2][0];
	double a3=a[0][2]*a[1][0]*a[2][1];

	double b1=a[2][0]*a[1][1]*a[0][2];
	double b2=a[2][1]*a[1][2]*a[0][0];
	double b3=a[2][2]*a[1][0]*a[0][1];

	return(a1+a2+a3-b1-b2-b3);
    }


    public Matrix inverse() {

	Matrix M=new Matrix();

	M.a[0][0]= a[1][1]*a[2][2]-a[1][2]*a[2][1];
	M.a[0][1]= a[1][2]*a[2][0]-a[1][0]*a[2][2];
	M.a[0][2]= a[1][0]*a[2][1]-a[1][1]*a[2][0];

	M.a[1][0]= a[2][1]*a[0][2]-a[2][2]*a[0][1];
	M.a[1][1]= a[2][2]*a[0][0]-a[2][0]*a[0][2];
	M.a[1][2]= a[2][0]*a[0][1]-a[2][1]*a[0][0];

	M.a[2][0]= a[0][1]*a[1][2]-a[0][2]*a[1][1];
	M.a[2][1]= a[0][2]*a[1][0]-a[0][0]*a[1][2];
	M.a[2][2]= a[0][0]*a[1][1]-a[0][1]*a[1][0];

	double d=this.det();

	Matrix TM=new Matrix();

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=M.a[i][j]/d;
	    }
	}
	return(TM);
    }



    public Matrix adjoint() {

	Matrix M=new Matrix();

	M.a[0][0]= a[1][1]*a[2][2]-a[1][2]*a[2][1];
	M.a[0][1]= a[1][2]*a[2][0]-a[1][0]*a[2][2];
	M.a[0][2]= a[1][0]*a[2][1]-a[1][1]*a[2][0];

	M.a[1][0]= a[2][1]*a[0][2]-a[2][2]*a[0][1];
	M.a[1][1]= a[2][2]*a[0][0]-a[2][0]*a[0][2];
	M.a[1][2]= a[2][0]*a[0][1]-a[2][1]*a[0][0];

	M.a[2][0]= a[0][1]*a[1][2]-a[0][2]*a[1][1];
	M.a[2][1]= a[0][2]*a[1][0]-a[0][0]*a[1][2];
	M.a[2][2]= a[0][0]*a[1][1]-a[0][1]*a[1][0];
	Matrix TM=new Matrix();

	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=M.a[i][j];
	    }
	}
	return(TM);
    }

    public Matrix transpose() {

	Matrix TM=new Matrix();
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		TM.a[j][i]=a[i][j];
	    }
	}
	return(TM);
    }

    public double trace() {
	double t=a[0][0]+a[1][1]+a[2][2];
	return(t);
    }




    public static Vector act(Matrix M,Vector V) {
	Vector W=new Vector(0,0,0);
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		W.x[i]=W.x[i]+M.a[i][j]*V.x[j];
	    }
	}
	return(W);
    }


    public static PolyVector act(Matrix M,PolyVector X) {
	PolyVector Y=new PolyVector(X.n);
	Y.n=X.n;
	for(int i=0;i<X.n;++i) {
	    Y.v[i]=act(M,X.v[i]);
	}
	return(Y);
    }


    public static Matrix normalize0(Vector V0,Vector V1,Vector V2,Vector V3) {
	Vector[] VV={V0,V1,V2};
	Matrix M=new Matrix(VV);
	M=M.transpose();
	Matrix M2=M.inverse();
	Vector L=Matrix.act(M2,V3);

	for(int i=0;i<3;++i) {
	for(int j=0;j<3;++j) {
	    M.a[i][j]=M.a[i][j]*L.x[j];
	}}

	M=M.inverse();
	return(M);
    }




    public static Matrix normalize0(PolyVector X,int vtx) {
	return(normalize0(X.v[0+vtx],X.v[1+vtx],X.v[2+vtx],X.v[3+vtx]));
    }

    public static Matrix normalize2() {

	Vector V0=new Vector(0,0,1);
	Vector V1=new Vector(1,0,1);
	Vector V2=new Vector(1,1,1);
	Vector V3=new Vector(0,1,1);
	Matrix M=normalize0(V0,V1,V2,V3);
	return(M);
    }



    public static Matrix normalize3(PolyVector X,int vtx) {
	Matrix M1=normalize0(X,vtx);
	Matrix M2=normalize2();
	Matrix M=times(M2.inverse(),M1);
	return(M);
    }

    public static PolyVector normalize(PolyVector X,int vtx) {
	Matrix M=normalize3(X,vtx);
	PolyVector Y=act(M,X);
	Y=Y.normalize();
	return(Y);
    }


    public static PolyVector normalize(PolyVector X1,PolyVector X2,int vtx) {
	Matrix M1=normalize3(X1,vtx);
	Matrix M2=normalize3(X2,vtx);
	Matrix M3=times(M1.inverse(),M2);
	PolyVector Y=act(M3,X2);
	Y=Y.normalize();
	return(Y);
    }




}
