import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class MotionControl {
    Lever STEP;
    ListenSquare[][] X=new ListenSquare[3][3];
    ListenSquare[][] Y=new ListenSquare[3][3];
    int x,y;

    public MotionControl(int x0,int y0) {
	x=x0;
	y=y0;

	 STEP=new Lever(x+50,y+16,5,24);

	 for(int i=0;i<3;++i) {
	     for(int j=0;j<3;++j) {
		 int jj=2-j;
		 X[i][j]=new ListenSquare(x+15*i,y+15*jj,15,15);
		 Y[i][j]=new ListenSquare(x+345+15*i,y+15*jj,15,15);
	     }
	 }
     }
    

    public void render(Graphics2D g) {
	g.setColor(new Color(60,120,255));
	g.fillRect(x,y,390,45);
	g.setColor(Color.white);
	g.drawRect(x,y,390,45);
	g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.drawString("manual point control",x+120,y+40);
	g.drawString("point 1",x+50,y+40);
	g.drawString("point 2",x+295,y+40);
	
	STEP.render2(g,"step size",new Color(0,0,150));

	 for(int i=0;i<3;++i) {
	     for(int j=0;j<3;++j) {
		 X[i][j].render(g,new Color(190,0,0));
		 Y[i][j].render(g,new Color(0,0,190));
	     }
	 }
    }

    public void process(Manager M,Point P) {
	STEP.process(P);
	int[] index={9,9,9,9};
	for(int i=0;i<3;++i) {
	    for(int j=0;j<3;++j) {
		if(X[i][j].inside(P)==1) {
		    index[0]=i-1;
		    index[1]=j-1;
		}
		if(Y[i][j].inside(P)==1) {
		    index[2]=i-1;
		    index[3]=j-1;
		}
	    }
	}
	double t=Math.pow(.5,STEP.val);
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
	for(int i=0;i<4;++i) {
	    if(index[i]!=9) A[i]=A[i]+t*index[i];
	}
	M.P.POLY=PolyVectorSpecial.fromDouble(A);
	M.P.computeOrbit();
	M.repaint();
    }


}

