import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class OrbitControl {
    int X,Y;
    Color C;
    SelectInteger[] S=new SelectInteger[4];
    
    public OrbitControl(int x,int y,Color c) {
	C=c;
	X=x;
	Y=y;
	 S[0]=new SelectInteger(X+100,Y+10,40,20,10,1,20,1);//size of orbit
	 S[1]=new SelectInteger(X+100,Y+35,40,20,14,1,25,1);//pointsize
	 S[2]=new SelectInteger(X+100,Y+60,40,20,1,1,10,1);//map power
	 S[3]=new SelectInteger(X+100,Y+85,40,20,0,0,20,1);//map phase
    }

    
    public void render(Graphics2D g) {
	g.setColor(C);
	g.fillRect(X,Y,178,110);
	g.setColor(Color.white);
	g.drawRect(X,Y,178,110);
        g.setFont(new Font("Helvetica",Font.PLAIN,14));
        g.setColor(Color.black);
        g.drawString("orbit size",X+5,Y+25);
        g.drawString("point size",X+5,Y+50);
        g.drawString("map power",X+5,Y+75);
        g.drawString("map offset",X+5,Y+100);
        for(int i=0;i<4;++i) S[i].render(g,Color.white,Color.black,Color.black);
    }

    public boolean process(Point X) {
	for(int i=0;i<4;++i) {
	    S[i].modify(X);
	    if(S[i].isModified(X)!=0) return true;
	}
	return false;
    }
    
}
