import java.awt.event.*;
import java.awt.*;


public class Pentagram {
    double x,y;

    /**This is the geometric version of the map.
    It is not being used now.*/
    
    /**This is the map on the level of polygons.  We want skip = 1 and diag = 3.*/
    public static PolyVector map(int diag,int skip,PolyVector P) {
	PolyVector Q=diagonal(diag,skip,P);
	Q=normalize(Q);
	return Q;
    }

    /**this is the basic pentagram map*/
    
    public static PolyVector diagonal(int diag,int skip,PolyVector P) {
	PolyVector Q=new PolyVector(P.n);
	for(int i=0;i<P.n;++i) {
	    Q.v[i]=diagonal0(skip,diag,i+1,P);
	}
	return Q;
    }
    /**we want skip = 1 and diag = 3.*/
    
    public static Vector diagonal0(int skip,int diag,int j,PolyVector P) {
	int n=P.n;
	int a=(j+0+n)%n;
	int b=(j+diag+n)%n;
	int c=(j+skip+n)%n;
	int d=(j+diag+skip+n)%n;
	Vector V1=Vector.cross(P.v[a],P.v[b]);
	Vector V2=Vector.cross(P.v[c],P.v[d]);
	Vector V3=Vector.cross(V1,V2);
	V3.x[0]=V3.x[0]/V3.x[2];
	V3.x[1]=V3.x[1]/V3.x[2];
	V3.x[2]=1;
	return V3;
    }

    /**Here is the dual polygon*/

    public static PolyVector dual(PolyVector P) {
	PolyVector Q=new PolyVector(P.n);
	for(int i=0;i<P.n;++i) {
	    int j=(i+1)%P.n;
	    Q.v[i]=Vector.cross(P.v[i],P.v[j]);
	    Q.v[i]=Q.v[i].normalize();
	}
	Q=normalize(Q);
	return Q;
    }


    /**This applies the affine transformation needed to put the
       8-gon in standard form*/

    public static PolyVector normalize(PolyVector P) {
	Vector a=new Vector(P.v[0].x[0],P.v[0].x[1],0);
	Vector b=new Vector(P.v[2].x[0],P.v[2].x[1],0);
	Vector c=new Vector(0,0,1);
	Vector[] aa={a,b,c};
	
	Matrix m=new Matrix(aa);
	m=m.inverse();
	m=m.transpose();
	PolyVector Q=Matrix.act(m,P);
	return Matrix.act(m,P);
    }


}

