import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PictureCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    Path2D.Double TRI;
    Color COLOR;
    PolyVector POLY;
    Complex[] POINT=new Complex[2];
    Complex[] SLICE=new Complex[2];
    Orbit ORB;
    boolean drag=false;
    Point JX;

     public PictureCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(300,300,200);
	 COLOR=new Color(255,180,0);
	 POLY=PolyVectorSpecial.regular8();
	 setPoints();
	 ORB=new Orbit();
	 setPolygon();
	 
     }

    public void setPoints() {
	 SOURCE=unity(1,8);
	 POINT[0]=unity(1,8);
	 POINT[1]=unity(1,8);
	 SLICE[0]=new Complex(-1,0);
	 SLICE[1]=new Complex(1,0);
    }

    /**roots of unity*/
	public static Complex unity(int k,int n) {
	    double t=2*k*Math.PI/n;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    return new Complex(c,s);
	}

    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(M.C.DISPLAY.L[2].on==1) drawLines(g);
      if(M.C.DISPLAY.L[3].on==1) drawDisks(g);
      if(M.C.DISPLAY.L[4].on==1) drawPoly(g);
      if(M.C.DISPLAY.L[5].on==1) drawEllipse1(g);
      if(M.C.DISPLAY.L[6].on==1) drawEllipse2(g);
      if(M.C.DISPLAY.L[1].on==1) drawOrbit(g);
      if(M.C.DISPLAY.L[7].on==1) drawFlow(g);
   }


    public void setPolygon() {
	Complex[] TEMP=getPoints();
	POINT[0]=new Complex(TEMP[0]);
	POINT[1]=new Complex(TEMP[1]);
	POLY=PolyVectorSpecial.fromComplex(TEMP);

    }



    public Complex[] getPoints() {

	Complex[] TEMP=new Complex[2];

	int m=0;
	int ell=0;
	
	try{
	  m=M.C.MOVE.mode;
	  ell=M.C.ELLIPSE.mode;
	}
	catch(Exception e) {}

	TEMP=POINT;

	int choice=0;
	if(m==1) choice=1;
	if(m==2) choice=-1;
	if(m==3) {
	    double[] d={Complex.dist(SOURCE,TEMP[0]),Complex.dist(SOURCE,TEMP[1])};
	    if(d[0]<d[1]) choice=0;
	    else choice=1;
	}

	if(choice!=-1)	TEMP[choice]=SOURCE;
	if(choice==-1) {
	    TEMP[0]=new Complex(SOURCE);
	    TEMP[1]=new Complex(SOURCE);
	}

	if((choice==0)&&(ell==1)) {
	    TEMP=PolyVectorSpecial.projectToEllipse1(TEMP);
	}

	if((choice==1)&&(ell==1)) {
	    TEMP=PolyVectorSpecial.projectToEllipse0(TEMP);
	}

	return TEMP;
    }


    

    public void computeOrbit() {
	double[] A=PolyVectorSpecial.toDouble(POLY);
	int lim=(int)(Math.pow(2,M.C.OC.S[0].val));
	ORB=Orbit.orbit(lim,M.C.OC.S[2].val,M.C.OC.S[3].val,A);
    }

    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
	try{g.setColor(M.C.DISPLAY.M[0].C);} catch(Exception e) {}
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawOrbit(Graphics2D g) {

	Color[] COL=new Color[4];
	for(int i=0;i<4;++i) COL[i]=M.C.DISPLAY.M[1].C;
	try{
	    for(int i=0;i<3;++i) {
		if(M.S.DISPLAY.L[i+1].on==1) COL[i]=M.S.DISPLAY.M[i+1].C;
	    }
	}
	catch(Exception e) {}
	
	double s=Math.sqrt(.5);
	
	double size=Math.pow(s,M.C.OC.S[1].val);
	
	for(int i=0;i<ORB.length;++i) {
	    Complex z=project(ORB.A[i]);
	    int j=(i+M.C.OC.S[3].val)%ORB.length;
	    int sort=projectionTest(ORB.A[i]);
	    if(sort==3) sort=0;
	    if(sort==-1) fillPoint(g,z,size,COL[0],4);
	    else fillPoint(g,z,size,COL[sort],4);
	}
    }

    
    public void drawFlow(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	double s=.001;
	int t=1000;
	Complex u=new Complex(1,-1);
	u=u.unit();
	
	try{
	    s=M.F.getStep();
	    t=M.F.getTime();
	    u=new Complex(M.F.Z);
	}
	catch(Exception e) {}
	
	double[] A=PolyVectorSpecial.toDouble(POLY);
	double[][] LIST=GradFlow.getFlow(A,u,s,t);
	for(int i=0;i<LIST.length;++i) {
	    Complex z=project(LIST[i]);
	    if(i==0) p.moveTo(z.x,z.y);
	    if(i>0) p.lineTo(z.x,z.y);
	}
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[7].C);
	g.draw(p);
    }

    
    

    public Complex project(double[] A) {
   	double[] d0=PlotCanvas.COORD0;
	double[] d1=PlotCanvas.COORD1;
	double x=0;
	double y=0;
	x=d0[0]*A[0]+d0[1]*A[1];
	y=d1[0]*A[1]+d1[1]*A[2]+d1[2]*A[3];
	Complex z=new Complex(x,y);
	return z;
    }

    public static int projectionTest(double[] A) {

	double a=A[0];
	double b=A[1];
	double c=A[2];
	double d=A[3];
        for(int i=3;i>-1;--i) {
	    boolean test=GradFlow.testProperty(i,A);
	    if(test==true) return i;
	}
	return(-1);
    }



    
    public double sliceDistance(Complex z) {
	double d1=Complex.signedArea(z,SLICE[0],SLICE[1]);
	double d2=Complex.dist(SLICE[0],SLICE[1]);
	double d3=d1/d2;
	return Math.abs(d3);
    }

    

    public void drawLines(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(-2,0);
	p.lineTo(2,0);
	p.moveTo(0,-2);
	p.lineTo(0,2);
	
	p.moveTo(10,9);
	p.lineTo(-9,-10);
	
	p.moveTo(9,10);
	p.lineTo(-10,-9);
	
	p.moveTo(9,-10);
	p.lineTo(-10,9);

	p.moveTo(-9,10);
	p.lineTo(10,-9);

	
	p.moveTo(0,1);
	p.lineTo(1,0);
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[2].C);
	g.draw(p);
    }

    public void drawDisks(Graphics2D g) {
	Color C1=new Color(0,0,0,0);
	Color C2=M.C.DISPLAY.M[3].C;
	double sq=Math.sqrt(.5);
	fillPoint(g,new Complex(0,0),1,C1,C2,500);
	fillPoint(g,new Complex(-.5,.5),sq,C1,C2,500);
	fillPoint(g,new Complex(.5,-.5),sq,C1,C2,500);
    }
    
	public Path2D.Double line(Complex u0,Complex u1) {
	    Path2D.Double p=new Path2D.Double();
	    for(int i=-3000;i<=3000;++i) {
		double t=1.0*i/100;
		double x=(1-t)*u0.x+t*u1.x;
		double y=(1-t)*u0.y+t*u1.y;
		Complex z=new Complex(x,y);
		if(i==-3000) p.moveTo(z.x,z.y);
		if(i!=-3000) p.lineTo(z.x,z.y);
	    }
	    return p;
	}

    public void drawSlicer(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	p.moveTo(SLICE[0].x,SLICE[0].y);
	p.lineTo(SLICE[1].x,SLICE[1].y);
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[7].C);
	g.draw(p);
    }

    

    public void drawPoly(Graphics2D g) {
	Path2D.Double p=POLY.toPath();
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[4].C);
	g.fill(p);
	Complex[] Z=PolyVectorSpecial.toComplex(POLY);
	fillPoint(g,Z[0],.02,Color.red,16);
	fillPoint(g,Z[1],.02,new Color(50,100,255),16);
	Z[1]=Complex.times(Z[1],new Complex(0,1));
	fillPoint(g,Z[1],.02,new Color(50,100,255,100),16);
    }
    
    public void drawEllipse1(Graphics2D g) {
	Complex[] z=PolyVectorSpecial.toComplex(POLY);
	Path2D.Double p=PolyVectorSpecial.ellipse(z[0]);
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[5].C);
	g.draw(p);
    }
    
    public void drawEllipse2(Graphics2D g) {
	Complex[] z=PolyVectorSpecial.toComplex(POLY);
	Complex w=Complex.times(z[1],new Complex(0,1));
	Path2D.Double p=PolyVectorSpecial.ellipse(w);
	p=transform(p);
	g.setColor(M.C.DISPLAY.M[6].C);
	g.draw(p);
    }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) {
	    SOURCE=unTransform(J.X);
	    setPolygon();
	    computeOrbit();
	}
	M.repaint();
    }

        
    public void doMouseClick(int mode) {
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  SOURCE=unTransform(JX);
	M.repaint();
    }
    
    
    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) SOURCE=unTransform(J.X);
	setPolygon();
	computeOrbit();
	M.repaint();
    }


    

    public void mousePressed(MouseEvent e) {
	drag=true;
    }
    
     public void mouseReleased(MouseEvent e) {
	 drag=false;
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

    
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
	if(drag==true) {
	    SOURCE=unTransform(JX);
	    setPolygon();
	    repaint();
	}
     }
    

  public void keyTyped(KeyEvent e) {
      char ch=e.getKeyChar();
      if(ch=='z') doMouseClick(1);
      if(ch=='x') doMouseClick(2);
      if(ch=='c') doMouseClick(3);  
      M.repaint();
     }

    public void keyPressed(KeyEvent e) {
	drag=true;
	M.repaint();
    }

    public void keyReleased(KeyEvent e) {
	drag=false;
	M.repaint();
    }



}

