import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class PlotCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener {
  
    public static double[] COORD0={1,0};
    public static double[] COORD1={1,0,0};
    Manager M;
    PolyVector TRI;
    Complex[] POINT=new Complex[2];
    ControlPanel PROJ;
    ListenSquare CONTROL;

     public PlotCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 setScales(200,300,120);
	 setPoly();
	 POINT[0]=new Complex(1.25,0);
	 POINT[1]=new Complex(1,0);
	 CONTROL=new ListenSquare(0,0,80,80);
	 setPanels();
     }

    public void setPoly() {
	TRI=new PolyVector(3);
	double t=2*Math.PI/3;
	double c=Math.cos(t);
	double s=Math.sin(t);
	TRI.v[0]=new Vector(1,0,0);
	TRI.v[1]=new Vector(-.5,Math.sqrt(3)/2,0);
	TRI.v[2]=new Vector(-.5,-Math.sqrt(3)/2,0);
    }



    
    public void setPanels() {

	Color[] C0={new Color(200,0,200),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};

	String[] ProjString={"A,B","A,C","A,D","ABC,AB","projection"};
	int[] ProjState={1,0,0,0};
        PROJ=new ControlPanel(C0,ProjString,ProjState,4);
    }
    







    
   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      drawControls(g);
   }

    public void drawBG(Graphics2D g) {
	g.setColor(M.C.DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawControls(Graphics2D g) {
	fillPoint(g,new Complex(0,0),10,new Color(255,0,200,50),500);
	fillPoint(g,new Complex(0,0),1.30,new Color(255,0,200),500);
	fillPoint(g,new Complex(0,0),1.20,Color.white,500);
	fillPoint(g,new Complex(0,0),1.10,new Color(100,150,255,50),500);
	Path2D.Double p=TRI.toPath();
	p=transform(p);
	g.setColor(new Color(100,150,255));
	g.fill(p);
	for(int i=0;i<2;++i) fillPoint(g,POINT[i],.025,Color.black,32);
	CONTROL.render(g,Color.black);
	PROJ.render(g,0,0,80);
    }


    public void setPoint() {
	double d=SOURCE.norm();
	if(d>1.15) setPoint0();
	if(d<1.10) setPoint1();
	COORD0=coord0();
	COORD1=coord1();
	System.out.println(COORD0[0]+" "+COORD0[1]);
	System.out.println(COORD1[0]+" "+COORD1[1]+" "+COORD1[2]);
    }
    


    public void setPoint0() {
	POINT[0]=SOURCE.unit();
	POINT[0]=Complex.times(POINT[0],new Complex(1.25,0));
    }
    


    public void setPoint1() {
	Path2D.Double p=TRI.toPath();
	if(p.contains(SOURCE.x,SOURCE.y)==true) {
           POINT[1]=new Complex(SOURCE);
	   return;
	}

	for(int i=0;i<3;++i) {
	    Complex z=new Complex(TRI.v[i].x[0],TRI.v[i].x[1]);
	    if(Complex.dist(z,SOURCE)<.02) {
		POINT[1]=z;
		return;
	    }
	}

	for(int i=0;i<3;++i) {
	    int j=(i+1)%3;
	    Complex w=getIntersection(i);
	    if(inSector(SOURCE,i)==true) {
		POINT[1]=w;
		return;
	    }
	}
	
    }


    public  void specialProjections(int k) {
	
	if(k==0) {
	    POINT[0]=new Complex(1.25,0);
	    POINT[1]=new Complex(1,0);
	}
	
	if(k==1) {
	    POINT[0]=new Complex(1.25,0);
	    POINT[1]=new Complex(-.5,Math.sqrt(3)/2);
	}
	
	if(k==2) {
	    POINT[0]=new Complex(1.25,0);
	    POINT[1]=new Complex(-.5,-Math.sqrt(3)/2);
	}
	
	if(k==3) {
	    double s=Math.sqrt(.5);
	    POINT[0]=new Complex(-1.25*s,1.25*s);
	    POINT[1]=new Complex(0,0);
	}


        COORD0=coord0();
	COORD1=coord1();
    }


    public boolean inSector(Complex w,int i) {
         int j=(i+1)%3;
	 PolyVector TRI2=new PolyVector(3);
	 TRI2.v[0]=new Vector(0,0,0);
	 TRI2.v[1]=TRI.v[i].scale(10);
	 TRI2.v[2]=TRI.v[j].scale(10);
	 Path2D.Double p=TRI2.toPath();
	 if(p.contains(w.x,w.y)==true) return true;
	 return false;
    }
    

    public Complex getIntersection(int i) {
            int j=(i+1)%3;
	    int k=(i+2)%3;
	    Vector origin=new Vector(0,0,1);
	    Vector s=new Vector(SOURCE.x,SOURCE.y,1);
	    Vector v1=new Vector(TRI.v[i].x[0],TRI.v[i].x[1],1);
	    Vector v2=new Vector(TRI.v[j].x[0],TRI.v[j].x[1],1);
	    Vector v=Vector.findCross(origin,s,v1,v2);
	    Complex w=new Complex(v.x[0]/v.x[2],v.x[1]/v.x[2]);
	    return w;
    }

    public double[] coord0() {
	Complex z=POINT[0].unit();
	double[] d={z.x,z.y};
	return d;
    }


    public double[] coord1() {
	double[] d=new double[3];
	Complex[] z=new Complex[3];
	for(int i=0;i<3;++i) {
	    z[i]=new Complex(TRI.v[i].x[0],TRI.v[i].x[1]);
	}
	d[0]=Math.abs(Complex.signedArea(z[1],z[2],POINT[1]));
	d[1]=Math.abs(Complex.signedArea(z[0],z[2],POINT[1]));
	d[2]=Math.abs(Complex.signedArea(z[0],z[1],POINT[1]));
	double s=d[0]+d[1]+d[2];
	for(int i=0;i<3;++i) d[i]=d[i]/s;
	return d;
    }

    public void doProjection(Point X) {
	int test=PROJ.switchMode(X);
	specialProjections(test);
	if(test==20) DocControls.projection(M.D);
    }
    

    public void mousePressed(MouseEvent e) { }
    
    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(CONTROL.inside(J.X)==1) {
            doProjection(J.X);
	    M.repaint();
	    return;
	}
        if(J.mode==1)  scaleUp(J.X,0);
        if(J.mode==3)  scaleUp(J.X,1);
	if(J.mode==2) SOURCE=unTransform(J.X);
	setPoint();
	M.repaint();
    }
    
    
    public void mouseDragged(MouseEvent e) {
	MouseData J=MouseData.process(e);
	if(J.mode==2) SOURCE=unTransform(J.X);
	setPoint();
	M.repaint();
    }

     public void mouseReleased(MouseEvent e) {	 
     }

     public void mouseEntered(MouseEvent e) {}
     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {}   


}

