import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;


class PolyVector {
    int n;
    Vector[] v=new Vector[30];

    public PolyVector() {}

    public PolyVector(int S) {
	this.n=S;
	for(int i=0;i<S;++i) v[i]=new Vector();
    }

    public PolyVector(PolyVector P) {
	this.n=P.n;
	for(int i=0;i<P.n;++i) v[i]=new Vector(P.v[i]);
    }

    public Path2D.Double toPath() {
	Path2D.Double gp=new Path2D.Double(Path2D.WIND_EVEN_ODD);
	gp.moveTo(v[0].x[0],v[0].x[1]);
	for(int i=1;i<n;++i) {
	    gp.lineTo(v[i].x[0],v[i].x[1]);
	}
	gp.closePath();
	return(gp);
    }

    public PolyVector rotate(double d) {
	PolyVector X=new PolyVector();
	X.n=this.n;
	for(int i=0;i<n;++i) {
	    X.v[i]=this.v[i].rotate(d);
	}
	return(X);
    }

    public PolyVector normalize() {
	PolyVector P=new PolyVector();
	P.n=n;
	for(int i=0;i<n;++i) {
	    P.v[i]=v[i].normalize();
	}
	return(P);
    }

    public boolean isConvex() {
	double mem=0;
	for(int i=0;i<this.n;++i) {
	    int j=(i+1)%n;
	    int k=(j+1)%n;
	    double test=Vector.tripleProduct(v[i],v[j],v[k]);
	    if(test<0) return false;
	    mem=test;
	}
	return true;
    }

    public void print() {
	System.out.println("------------");
	for(int i=0;i<8;++i) this.v[i].print();
    }

}



