import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import java.io.*;


class PolyVectorSpecial {


    /**This is the regular octagon*/
    public static PolyVector regular8() {
	PolyVector P=new PolyVector(8);
        for(int i=0;i<8;++i) {
	    double t=2*Math.PI*i/8;
	    double c=Math.cos(t);
	    double s=Math.sin(t);
	    P.v[i]=new Vector(c,s,1);
	}
	return P;
    }

    /**This promotes a pair of complex numbers to an 8-gon with
       central symmetry*/

    public static PolyVector fromComplex(Complex[] Z) {
	PolyVector P=new PolyVector(8);
	P.v[0]=new Vector(1,0,1);
	P.v[1]=new Vector(Z[0].x,Z[0].y,1);
	P.v[2]=new Vector(0,1,1);
	P.v[3]=new Vector(-Z[1].y,Z[1].x,1);
	for(int i=0;i<4;++i) {
	    P.v[4+i]=new Vector(P.v[i]);
	    P.v[4+i].x[0]=-P.v[4+i].x[0];
	    P.v[4+i].x[1]=-P.v[4+i].x[1];
	}
	return P;
    }

    public static PolyVector fromDouble(double[] A) {
	Complex[] Z={new Complex(A[0],A[1]),new Complex(A[2],A[3])};
	return fromComplex(Z);
    }

    public static Complex[] toComplex(PolyVector P) {
	Complex z0=new Complex(P.v[1].x[0],P.v[1].x[1]);
	Complex z1=new Complex(P.v[3].x[1],-P.v[3].x[0]);
	Complex[] z={z0,z1};
	return z;
    }

    public static double[] toDouble(PolyVector P) {
	double[] A={P.v[1].x[0],P.v[1].x[1],P.v[3].x[1],-P.v[3].x[0]};
	return A;
    }


    

    public static double ellipseConstant(Complex z) {
	double d=z.x*z.x+z.y*z.y;
	double a=(d-1)/(z.x*z.y);
	return a;
    }

    public static Path2D.Double ellipse(Complex z) {
	double a=ellipseConstant(z);
	double b1=1/Math.sqrt(2-a);
	double b2=1/Math.sqrt(2+a);
	Path2D.Double p=new Path2D.Double();
	for(int i=0;i<1000;++i) {
	    double t=2*Math.PI*i/1000;
	    double c=b1*Math.cos(t);
	    double s=b2*Math.sin(t);
	    Complex w=new Complex(c,s);
	    w=Complex.times(w,new Complex(1,1));
	    if(i==0) p.moveTo(w.x,w.y);
	    if(i!=0) p.lineTo(w.x,w.y);
	}
	p.closePath();
	return p;
    }


    public static Complex[] projectToEllipse0(Complex[] z) {
	double a=ellipseConstant(z[0]);
	double r=1/Math.sqrt(z[1].x*z[1].x+a*z[1].x*z[1].y+z[1].y*z[1].y);
	Complex[] w={z[0],Complex.times(new Complex(r,0),z[1])};
	return w;
    }

    public static Complex[] projectToEllipse1(Complex[] z) {
	double a=ellipseConstant(z[1]);
	double r=1/Math.sqrt(z[0].x*z[0].x+a*z[0].x*z[0].y+z[0].y*z[0].y);
	Complex[] w={Complex.times(new Complex(r,0),z[0]),z[1]};
	
	return w;
    }
    
    public static double Psi(PolyVector P) {
	double[] A=toDouble(P);
	return Psi(A);
    }
    public static double F(PolyVector P) {
	double d=Psi(P);
	d=(2-d)/(2+d);
	return d;
    }

    public static double G(PolyVector P) {
	double[] A=toDouble(P);
	return G(A);
    }

    public static double Psi(double[] A) {
	double x1=A[0];
	double y1=A[1];
	double x2=A[2];
	double y2=A[3];
	double b1=(1-x1*x1-y1*y1)/(x1*y1);
	double b2=(1-x2*x2-y2*y2)/(x2*y2);
     	double c=(x1-y1+x2-y2);
	double d=.25*c*(b1+b2);
	return d;
    }
    public static double F(double[] A) {
	double d=Psi(A);
	d=(2-d)/(2+d);
	return d;
    }

    public static double G(double[] A) {
	double x1=A[0];
	double y1=A[1];
	double x2=A[2];
	double y2=A[3];
        double n=(+1+x1-y1)*(+1+x2-y2)*(-x2+x1*x2+y1+y1*y2)*(-x1+x1*x2+y2+y1*y2);
        double d=(-1+x1-y1)*(-1+x2-y2)*(+x2+x1*x2-y1+y1*y2)*(+x1+x1*x2-y2+y1*y2);
	double t=n/d;
	return t;
    }



    

    public static double p(double d,double k) {
	return Math.pow(d,k);
    }
    
    /**gradients of the invariants*/

    public static double[] gradF(double[] A) {
	return gradF(A[0],A[1],A[2],A[3]);
    }
    
    public static double[] gradG(double[] A) {
	return gradG(A[0],A[1],A[2],A[3]);
    }

    public static double[] gradF(double a,double b,double c,double d) {

	double[] G=new double[4];
G[0]=(4*b*c*d*(2*p(a,3)*c*d + (-1 + p(b,2))*c*d*(b - c + d) + p(a,2)*(c*(c - d)*d + b*(-1 + p(c,2) - c*d + p(d,2)))))/
   p(p(a,3)*c*d - (-1 + p(b,2))*c*d*(b - c + d) + p(a,2)*(c*(c - d)*d + b*(-1 + p(c,2) - c*d + p(d,2))) - 
     a*(c*d + p(b,2)*(-1 + p(c,2) - c*d + p(d,2)) + b*(c - p(c,3) - d + 2*c*d + p(c,2)*d - c*p(d,2) + p(d,3))),2);

G[1]=(-4*a*c*d*(p(a,3)*c*d + p(a,2)*c*(c - d)*d + c*d*(2*p(b,3) - c + d + p(b,2)*(-c + d)) + 
       a*(-(c*d) + p(b,2)*(-1 + p(c,2) - c*d + p(d,2)))))/
   p(p(a,3)*c*d - (-1 + p(b,2))*c*d*(b - c + d) + p(a,2)*(c*(c - d)*d + b*(-1 + p(c,2) - c*d + p(d,2))) - 
     a*(c*d + p(b,2)*(-1 + p(c,2) - c*d + p(d,2)) + b*(c - p(c,3) - d + 2*c*d + p(c,2)*d - c*p(d,2) + p(d,3))),2);

G[2]=(-4*a*b*d*(-((-1 + p(b,2))*p(c,2)*d) - p(a,2)*(p(c,2)*d + b*(1 + p(c,2) - p(d,2))) + 
       a*b*(-2*p(c,3) + d + p(c,2)*d - p(d,3) + b*(1 + p(c,2) - p(d,2)))))/
   p(p(a,3)*c*d - (-1 + p(b,2))*c*d*(b - c + d) + p(a,2)*(c*(c - d)*d + b*(-1 + p(c,2) - c*d + p(d,2))) - 
     a*(c*d + p(b,2)*(-1 + p(c,2) - c*d + p(d,2)) + b*(c - p(c,3) - d + 2*c*d + p(c,2)*d - c*p(d,2) + p(d,3))),2);

G[3]=(-4*a*b*c*((-1 + p(b,2))*c*p(d,2) + p(a,2)*(c*p(d,2) + b*(-1 + p(c,2) - p(d,2))) + 
       a*b*(p(c,3) + 2*p(d,3) - c*(1 + p(d,2)) + b*(1 - p(c,2) + p(d,2)))))/
   p(p(a,3)*c*d - (-1 + p(b,2))*c*d*(b - c + d) + p(a,2)*(c*(c - d)*d + b*(-1 + p(c,2) - c*d + p(d,2))) - 
     a*(c*d + p(b,2)*(-1 + p(c,2) - c*d + p(d,2)) + b*(c - p(c,3) - d + 2*c*d + p(c,2)*d - c*p(d,2) + p(d,3))),2);

return G;
    
    }

    public static double[] gradG(double a,double b,double c,double d) {
	double[] G = new double[4];

G[0]=(-2*(1 + c - d)*(p(a,4)*c*(p(c,2)*d + b*(-1 + p(c,2) + c*d)) + 
       2*p(a,3)*b*c*(b*(1 - p(c,2) + p(d,2)) + c*(-1 + p(c,2) + p(d,2))) + 
       2*a*b*(-1 + p(b,2))*d*(b*(1 + p(c,2) - p(d,2)) + c*(-1 - p(c,2) + 2*c*d + p(d,2))) + 
       (-1 + p(b,2))*d*(-p(c,3) + b*c*(c + d) + p(b,3)*(-1 + c*d + p(d,2)) + p(b,2)*(c - d - p(c,2)*d + c*p(d,2) + p(d,3))) + 
       p(a,2)*(-2*p(c,3)*d + b*c*(-1 + p(c,2) + 4*c*d + 3*p(d,2)) + 
          p(b,3)*(-c + p(c,3) - d - 3*p(c,2)*d - 3*c*p(d,2) + p(d,3)) + 
          p(b,2)*(1 - p(c,4) + 5*p(c,3)*d - p(d,2) + p(c,2)*p(d,2) + c*d*(-3 + p(d,2))))))/
    (p(1 - a + b,2)*p((1 + a)*c + b*(-1 + d),2)*(-1 + c - d)*p(a*(1 + c) + (-1 + b)*d,2));



  G[1]=  (2*(1 + c - d)*(p(-1 + p(b,2),2)*c*p(d,3) + p(a,5)*c*(-1 + p(c,2) + c*d) + 
       a*d*(-(c*(c + d)) - 2*b*c*(-1 + p(c,2) + 2*c*d - p(d,2)) + 2*p(b,3)*d*(-1 + p(c,2) + p(d,2)) + p(b,4)*(-1 + c*d + p(d,2)) + 
          p(b,2)*(-1 + 3*p(c,2) + 4*c*d + p(d,2))) + 
       p(a,4)*c*(p(c,3) + d + p(c,2)*d - c*(1 + p(d,2)) + b*(2 - 2*p(c,2) + 2*p(d,2))) + 
       p(a,2)*(2*b*c*(-1 + p(c,2) - p(d,2)) + 2*p(b,3)*(d + p(c,2)*d - p(d,3)) - 
          c*(p(c,3) + d + p(c,2)*d + p(d,3) - c*(1 + p(d,2))) + 
          p(b,2)*(1 + p(c,3)*d - p(d,4) + p(c,2)*(-1 + p(d,2)) + c*d*(-3 + 5*p(d,2)))) + 
       p(a,3)*(b*p(c,2)*d*(-3*b + 4*d) + p(c,3)*(-1 + p(b,2) + 2*b*d) + p(b,2)*d*(-1 + p(d,2)) - 
          c*(-1 - p(d,2) + p(b,2)*(1 + 3*p(d,2)) + 2*b*(d + p(d,3))))))/
	(p(1 - a + b,2)*p((1 + a)*c + b*(-1 + d),2)*(-1 + c - d)*p(a*(1 + c) + (-1 + b)*d,2));


 G[2]=   (-2*(1 + a - b)*(p(a,4)*p(c,2)*(2*c - d)*d + (-1 + p(b,2))*p(d,2)*
        (-p(c,2) + p(b,2)*(-1 + p(d,2)) + b*(2*c - d + p(c,2)*d - 2*c*p(d,2) + p(d,3))) + 
       a*d*(-(p(c,2)*(1 + p(c,2) - 2*c*d + p(d,2))) + b*(2*c - d - 3*p(c,2)*d - 2*c*p(d,2) + p(d,3)) + 
          p(b,2)*(-1 + 2*p(c,3)*d + p(d,4) - 3*p(c,2)*(-1 + p(d,2))) + 
          p(b,3)*(p(c,2)*d + 2*c*(-1 + p(d,2)) + d*(-1 + p(d,2)))) + 
       p(a,2)*d*(-2*p(c,3) + p(b,2)*(2*p(c,3) + d + p(c,2)*d - p(d,3) + 4*c*(-1 + p(d,2))) + 
          b*(-1 + p(c,4) + p(d,2) + p(c,2)*(4 - 3*p(d,2)) + 2*c*d*(-1 + p(d,2)))) + 
       p(a,3)*(p(c,2)*d*(1 + p(c,2) - 2*c*d + p(d,2)) + 
          b*(1 + p(c,4) - p(d,2) - 2*c*d*(-1 + p(d,2)) + p(c,2)*(-2 + 5*p(d,2))))))/
	((-1 + a - b)*p((1 + a)*c + b*(-1 + d),2)*p(1 - c + d,2)*p(a*(1 + c) + (-1 + b)*d,2));

 G[3]=   (2*(1 + a - b)*(p(a,4)*p(c,2)*(-1 + p(c,2)) - (-1 + p(b,2))*c*p(d,2)*(c + p(b,2)*(c - 2*d) - b*(1 + p(c,2) - 2*c*d + p(d,2))) + 
       p(a,2)*c*(-(c*(-1 + p(c,2) + p(d,2))) + p(b,2)*(c - p(c,3) - 4*d + 4*p(c,2)*d + c*p(d,2) + 2*p(d,3)) + 
          b*(-1 + p(c,4) + 3*p(d,2) - 3*p(c,2)*p(d,2) + 2*c*p(d,3))) + 
       p(a,3)*c*(c*(p(c,3) + 2*d - 2*p(c,2)*d + c*(-1 + p(d,2))) + b*(p(c,3) - 2*d + 2*p(c,2)*d + c*(-1 + p(d,2)))) + 
       a*(p(b,2)*c*(-1 - 2*c*d + 2*p(c,3)*d + 4*p(d,2) + p(d,4) + p(c,2)*(1 - 3*p(d,2))) - 
          p(c,2)*(p(c,3) + 2*d - 2*p(c,2)*d + c*(-1 + p(d,2))) + b*c*(p(c,3) + 2*d - 2*p(c,2)*d - c*(1 + 3*p(d,2))) + 
          p(b,3)*(2*c*d - 2*p(c,3)*d + p(-1 + p(d,2),2) + p(c,2)*(-1 + 5*p(d,2))))))/
	((-1 + a - b)*p((1 + a)*c + b*(-1 + d),2)*p(1 - c + d,2)*p(a*(1 + c) + (-1 + b)*d,2));

    return G;

    }

    
}
