import java.applet.Applet;
import java.awt.*;
import java.applet.*;
import java.math.*;
import java.awt.event.*;
import java.awt.geom.*;


public class PopupManager {
    Manager M;
    int X,Y;
    ListenSquare INST,GEOM,NAV,STAT,FLOW;
    ListenSquare[] INFO=new ListenSquare[5];
    
    public PopupManager(Manager m,int x,int y) {
	M=m;
	this.X=x;
	this.Y=y;
	INST=new ListenSquare(X,Y+25,85,25);
	GEOM=new ListenSquare(X,Y+55,85,25);
	NAV=new ListenSquare(X,Y+85,85,25);
	STAT=new ListenSquare(X,Y+115,85,25);
	FLOW=new ListenSquare(X,Y+145,85,25);
	for(int i=0;i<5;++i) INFO[i]=new ListenSquare(X+100,y+32+30*i,12,12);
    }


    public void render(Graphics2D g) {
	g.setColor(new Color(120,140,160));
	g.fillRect(X,Y,120,180);
	g.setColor(Color.white);
	g.drawRect(X,Y,120,180);
	g.setFont(new Font("Helvetica",Font.PLAIN,16));
	g.drawString("popups",X+35,Y+18);
	INST.render(g,"instructions",15,5,new Color(80,0,80));
	GEOM.render(g,"intrinsic",15,5,new Color(0,0,150));
	NAV.render(g,"projection",15,5,new Color(150,0,0));
	STAT.render(g,"numerics",15,5,new Color(0,150,0));
	FLOW.render(g,"flowlines",15,5,new Color(150,0,150));
	for(int i=0;i<5;++i) INFO[i].infoRender(g);
    }

    public void process(Point X) {
	if(INST.inside(X)==1) {
	    PopupDocumentCanvas PD=new PopupDocumentCanvas();
	    PD.D.M=this.M;
	    M.D=PD.D;
	}

	if(GEOM.inside(X)==1) {
	    PopupSpreadCanvas PS=new PopupSpreadCanvas();
	    PS.S.M=this.M;
	    M.S=PS.S;
	}
	
	if(NAV.inside(X)==1) {
	    PopupPlotCanvas PZ=new PopupPlotCanvas();
	    PZ.Z.M=this.M;
	    M.Z=PZ.Z;
	}
	
	if(STAT.inside(X)==1) {
	    PopupStatsCanvas PN=new PopupStatsCanvas();
	    PN.N.M=this.M;
	    M.N=PN.N;
	}

	if(FLOW.inside(X)==1) {
	    PopupFlowCanvas PF=new PopupFlowCanvas();
	    PF.F.M=this.M;
	    M.F=PF.F;
	}
	if(INFO[0].inside(X)==1) DocControls.instructions(M.D);
	if(INFO[1].inside(X)==1) DocControls.intrinsic(M.D);
	if(INFO[2].inside(X)==1) DocControls.projection(M.D);
	if(INFO[3].inside(X)==1) DocControls.numerics(M.D);
	if(INFO[4].inside(X)==1) DocControls.flowlines(M.D);

    }


}

