import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class ShapeEntryBasic {
    SelectIntegerKeyboard[] I=new SelectIntegerKeyboard[2];
    ListenSquare REDUCE;
    ListenSquare[] INFO=new ListenSquare[10];
    SelectInteger INC;
    int X,Y;


    public ShapeEntryBasic(int x,int y) {
	 X=x;
	 Y=y;
	 I[0]=new SelectIntegerKeyboard(x+3,y+3,   48,13,1,9999999);  //xcoord numerator
	 I[1]=new SelectIntegerKeyboard(x+3,y+21,48,13,1,9999999);  //ycoord denominator
	 INC=new SelectInteger(x+57,y+20,40,18,1,1,2,1);
         REDUCE=new ListenSquare(x+55,y,45,15,Color.white);
	 REDUCE.on=1; 
    }

    public void render(Graphics2D g) {
            drawFractionsBasic(g);
            drawButtonsBasic(g);
    }


    public void drawButtonsBasic(Graphics2D g) {
	  REDUCE.render(g,new Color(0,0,230));
	  g.drawString("reduce",X+63,Y+11); 
    }

	public void drawFractionsBasic(Graphics2D g) {
          g.setFont(new Font("Helvetica",Font.PLAIN,10));

	  //main entry
	  g.setColor(new Color(0,0,160));  
	  g.fillRect(X,Y,55,37);
	  g.setColor(Color.white);
	  g.drawRect(X,Y,55,37);

          for(int i=0;i<=1;++i) {
	    I[i].render(g,new Color(255,140,255),Color.blue,Color.yellow,Color.black);
	  }
	  INC.render(g,new Color(0,0,160),Color.white,new Color(0,0,0,0));
	}

    public void reduce() {
	if(I[0].val*I[1].val>0) {
           int s=MathRational.GCD(I[0].val,I[1].val);
           I[0].val=I[0].val/s;
           I[1].val=I[1].val/s;
	}
    }

    public void increment(Point X) {
	INC.val=I[0].val;
	INC.max=I[1].val-1;
	int test1=INC.val;
	int t=INC.isModified(X);
	if(t==-1) --I[0].val;
	if(t==+1) ++I[0].val;
    }



    public double getParameter() {
	 return 1.0*I[0].val/I[1].val;
    }

  public int processMouse(MouseEvent e) {
	MouseData J=MouseData.process(e);

       for(int i=0;i<=1;++i) {
	  I[i].on=0;
	  if(I[i].inside(J.X)==1) I[i].on=1;
       }
       increment(J.X);
       if(REDUCE.inside(J.X)==1) reduce();
       return(0);
  }

    public void processKey(KeyEvent e) {
	if(I[0].on==1) I[0].modifySign(e);
	if(I[1].on==1) I[1].modifySign(e);
    }

}




