import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;

public class SpreadCanvas extends ScaleCanvas implements MouseListener, MouseMotionListener, KeyListener {
    Manager M;
    boolean drag;
    Point JX;
    int COUNT;
    ListenSquare CONTROL,GO;
    Complex AXIS;
    SelectInteger MOT1;
    Lever MOT2;
    SelectInteger[] S=new SelectInteger[3];
    ControlPanelColor DISPLAY;

     public SpreadCanvas() {
	 addMouseListener(this);
	 addMouseMotionListener(this);
	 addKeyListener(this);
	 setScales(400,400,300);
	 double s=Math.sqrt(.5);
	 AXIS=new Complex(s,s);
	 CONTROL=new ListenSquare(0,0,500,95);
	 MOT1=new SelectInteger(280,16,40,20,0,0,0,0);
	 MOT2=new Lever(10,20,6,20);
	 S[0]=new SelectInteger(10,70,40,20,12,1,25,1);//timestep;
	 S[1]=new SelectInteger(158,70,40,20,14,1,30,1);//time
	 S[2]=new SelectInteger(307,70,40,20,5,1,15,1);//ray
	 setPanels();
     }

    public void setPanels() {

       Color[] C0={new Color(100,150,255),
                   Color.white,
                   Color.white,
                   Color.black,
                   Color.white};


	String[] DisplayString={"background",
				"(L+) cylinder",
				"(L-) cylinder",
				"(M) cylinder",
				"convex points",
                                "display"};
	Color[] DisplayColor={new Color(0,0,0),
                              new Color(255,0,0),
			      new Color(0,200,0),
			      new Color(0,200,200),
                              new Color(255,255,255,80)};
	
	int[] DisplayState={1,0,0,0,0};
        DISPLAY=new ControlPanelColor(C0,DisplayString,DisplayState,5,DisplayColor);
    }
    

    




    

   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      if(DISPLAY.L[1].on==1) drawPositiveCylinder(g);
      if(DISPLAY.L[2].on==1) drawNegativeCylinder(g);
      if(DISPLAY.L[3].on==1) drawMiddleCylinder(g);
      if(DISPLAY.L[4].on==1) drawConvexCylinder(g);
      drawControls(g);
   }

    public void drawControls(Graphics2D g) {
	CONTROL.render(g,new Color(100,100,100));
	MOT1.render(g,new Color(200,0,0),Color.white,Color.white);
	MOT2.render2(g,"spine slope increment size",new Color(200,0,0));
	String[] U={"time step", "max steps","spacing"};
	for(int i=0;i<3;++i) {
	   S[i].render(g,Color.blue,Color.white,Color.white);
	   g.setColor(Color.white);
	   g.drawString(U[i],10+150*i,65);
	}
	g.drawString("spine slope",280,13);
	
	DISPLAY.render(g,380,0,120);
    }
    
    public void drawBG(Graphics2D g) {
	g.setColor(DISPLAY.M[0].C);
        g.fillRect(0,0,getWidth(),getHeight()); 
    }

    public void drawPositiveCylinder(Graphics2D g) {
	boolean test=isSuitable();  
        Color COL=DISPLAY.M[1].C;
	if(test==false) return;
	drawSpine(g);
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
	drawCylinder(0,+1,+1,COL,AXIS,A,g);
	drawCylinder(0,+1,-1,COL,AXIS,A,g);
    }

    public void drawNegativeCylinder(Graphics2D g) {
        Color COL=DISPLAY.M[2].C;
	 boolean test=isSuitable();
	 if(test==false) return;
	 double s=getStep();
         int t=getTime();
	 double s2=Math.sqrt(.5);
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
        double[] B=GradFlow.getPropertyExample(1,A,new Complex(s2,-s2),s,t);
	 drawCylinder(1,+1,+1,COL,AXIS,B,g);
	 drawCylinder(1,+1,-1,COL,AXIS,B,g);
    }

    public void drawMiddleCylinder(Graphics2D g) {
         Color COL=DISPLAY.M[3].C;
	 boolean test=isSuitable();
	 if(test==false) return;
	 double s=getStep();
         int t=getTime();
	 double s2=Math.sqrt(.5);
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
        double[] B=GradFlow.getPropertyExample(2,A,new Complex(s2,-s2),s,t);
	 drawCylinder(2,+1,+1,COL,AXIS,B,g);
	 drawCylinder(2,+1,-1,COL,AXIS,B,g);
    }

    public void drawConvexCylinder(Graphics2D g) {
	boolean test=isSuitable();  
        Color COL=DISPLAY.M[4].C;
	if(test==false) return;
	drawSpine(g);
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
	drawCylinder(3,+1,+1,COL,AXIS,A,g);
	drawCylinder(3,+1,-1,COL,AXIS,A,g);
    }





    public boolean isSuitable() {
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
	for(int i=0;i<4;++i) {
	    if(A[i]<0) return false;
	}
	if(A[0]-A[1]>1) return false;
	if(A[2]-A[3]>1) return false;
	if(A[3]-A[2]>1) return false;
	if(A[1]-A[0]>1) return false;
	if(A[0]-A[1]+A[2]-A[3]<0) return false;
	return true;
    }
    
    public void drawSpine(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
	double s=getStep();
        int t=getTime();
	double time=GradFlow.getFlowTime(A,AXIS,s,t);
	p.moveTo(0,0);
	p.lineTo(time*AXIS.x,time*AXIS.y);
	p=transform(p);
	g.setColor(new Color(255,255,255,50));
	g.draw(p);
    }
    
	


    public void drawCylinder(int PROP,double sign1,double sign2,Color COL,Complex AXIS,double[] A,Graphics2D g) {
	double[] LIST=getCylinderProperty(PROP,sign1,sign2,AXIS,A);
	if(A.length>4) {
	    double t=-A[4]/Math.sqrt(2);
	    for(int i=0;i<LIST.length;i=i+4) {
               LIST[i+0]=LIST[i+0]-t;
               LIST[i+1]=LIST[i+1]+t;
               LIST[i+2]=LIST[i+2]-t;
               LIST[i+3]=LIST[i+3]+t;
	    }

	}
	renderCylinder(LIST,COL,false,g);
    }
    
    public void renderCylinder(double[] LIST,Color COL,boolean edge,Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	for(int i=0;i<LIST.length-4;i=i+4) {
	    int j=i+4;
	    double x1=LIST[i+0];
	    double y1=LIST[i+1];
	    double xx1=LIST[i+2];
	    double yy1=LIST[i+3];
	    double x2=LIST[j+0];
	    double y2=LIST[j+1];
	    double xx2=LIST[j+2];
	    double yy2=LIST[j+3];
	    
            p.moveTo(x1,y1);
            p.lineTo(xx1,yy1);
            p.lineTo(xx2,yy2);
            p.lineTo(x2,y2);
	    p.closePath();
	}
	p=transform(p);
	g.setColor(COL);
	g.fill(p);
	g.setColor(new Color(255,255,255,100));
	g.draw(p);
	if(edge==false) return;
	
	p.reset();
        p.moveTo(LIST[2],LIST[3]);
	for(int i=4;i<LIST.length;i=i+4) {
	    p.lineTo(LIST[i+2],LIST[i+3]);
	}
	p=transform(p);
	g.setColor(Color.white);
	g.draw(p);
	
    }

    public double[] getCylinderProperty(int PROP,double sign1,double sign2,Complex AXIS,double[] A) {
        int COUNT=0;
	double[] FINAL=new double[40000];
	

    	double s=getStep();
        int t=getTime();
	double s2=Math.sqrt(.5);
	
	double[][] SPINE=GradFlow.getFlow(A,AXIS,sign1*s,t);
	double time=GradFlow.getFlowSteps(A,AXIS,sign1*s,t);
    	int RAY=(int)(Math.pow(2,S[2].val));
	double RAY2=RAY*(SPINE.length/t);
	double spacing=time/RAY2;

	int N=(int)(1.0*SPINE.length/RAY2);
		      
	for(int i=0;i<RAY2;++i) {
	    double x=s*sign1*AXIS.x*i*spacing;
	    double y=s*sign1*AXIS.y*i*spacing;

	    double[] spec=GradFlow.getPropertyTimes(PROP,SPINE[i*N],new Complex(s2,-s2),sign2*s,t);
	    if(spec!=null) {
	      double xx1=x+sign2*spec[0]*s2;
	      double yy1=y-sign2*spec[0]*s2;
	      double xx2=x+sign2*spec[1]*s2;
	      double yy2=y-sign2*spec[1]*s2;

	    FINAL[COUNT+0]=xx1;
	    FINAL[COUNT+1]=yy1;
	    FINAL[COUNT+2]=xx2;
	    FINAL[COUNT+3]=yy2;
	    COUNT=COUNT+4;
	    }
	}

        double[] FINAL2=new double[COUNT];
	for(int i=0;i<COUNT;++i) FINAL2[i]=FINAL[i];
        return FINAL2;

	
    }


    public void drawRay(Graphics2D g) {
	Path2D.Double p=new Path2D.Double();
	double[] A=PolyVectorSpecial.toDouble(M.P.POLY);
    	double s=getStep();
	int t=getTime();
	Complex u=new Complex(0,0);
	try{
	    u=M.F.Z;
	}
	catch(Exception e) {return;}
	double time=GradFlow.getFlowTime(A,u,s,t);
	p.moveTo(0,0);
	p.lineTo(time*u.x,time*u.y);
	p=transform(p);
	g.setColor(Color.white);
	g.draw(p);
    }



    public void changeAxis(Point X) {
	MOT2.process(X);
	int t=MOT1.isModified(X);
        double m=t*Math.pow(.5,MOT2.val);
	AXIS.x=AXIS.x+m;
	AXIS=AXIS.unit();


    }
	

    public double getStep() {
	double t=Math.pow(.5,S[0].val);
	return t;
    }

    public int getTime() {
	double t=Math.pow(2,S[1].val);
	int n=(int)(t);
	return n;
    }

    public void mouseClicked(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	doMouseClick(J.mode);
    }
    
    public void doMouseClick(int mode) {
	if(CONTROL.inside(JX)==1) {  
            changeAxis(JX);
	    repaint();
	    for(int i=0;i<3;++i) S[i].modify(JX);
	    DISPLAY.process(JX,M.C.CS.C);
	    return;
	}
	
        if(mode==1)  scaleUp(JX,0);
        if(mode==3)  scaleUp(JX,1);
	if(mode==2)  SOURCE=unTransform(JX);
	M.repaint();
    }
    
    
    public void mouseDragged(MouseEvent e) { 
	MouseData J=MouseData.process(e);
	if(J.mode==2) SOURCE=unTransform(J.X);
	M.repaint();
    }

    public void mousePressed(MouseEvent e) {
	drag=true;
    }
    
     public void mouseReleased(MouseEvent e) {
	 drag=false;
     }

     public void mouseEntered(MouseEvent e) {
	 requestFocus();
     }

     public void mouseExited(MouseEvent e) {}   

     public void mouseMoved(MouseEvent e) {
	MouseData J=MouseData.process(e);
	JX=new Point(J.X);
	if(drag==true) {
	    SOURCE=unTransform(JX);
	}
	M.repaint();
     }
    

  public void keyTyped(KeyEvent e) {
      char ch=e.getKeyChar();
      if(ch=='z') doMouseClick(1);
      if(ch=='x') doMouseClick(2);
      if(ch=='c') doMouseClick(3);  
      M.repaint();
     }

    public void keyPressed(KeyEvent e) {
	drag=true;
	M.repaint();
    }

    public void keyReleased(KeyEvent e) {
	drag=false;
	M.repaint();
    }



}

