import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.awt.geom.*;
import java.math.*;


public class StatsCanvas extends ScaleCanvas {
    Manager M;
    
    public StatsCanvas() {
    }


   public void paint(Graphics g2) {
      Graphics2D g=(Graphics2D) g2;
      g.setRenderingHint(RenderingHints.KEY_ANTIALIASING,RenderingHints.VALUE_ANTIALIAS_ON);
      drawBG(g);
      PolyVector P=new PolyVector(M.P.POLY);
      double[] AA=PolyVectorSpecial.toDouble(P);
      drawCoords(g,AA);
      drawInvariant1(g,AA);
      drawInvariant2(g,AA);
      drawInvariant3(g,AA);
      drawConvex(g,P);
   }


    public void drawBG(Graphics2D g) {
	g.setColor(Color.white);
	g.fillRect(0,0,getWidth(),getHeight());
    }
    
    public void drawCoords(Graphics2D g,double[] AA) {
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,16));
	String[] S={"a","b","c","d"};
	for(int i=0;i<4;++i) {
	    Double D=new Double(AA[i]);
	    g.drawString(S[i],10,20+20*i);
	    g.drawString(D.toString(),55,20+20*i);
	}
	    
    }
    
    public void drawInvariant1(Graphics2D g,double[] AA) {
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,16));
	Double f1=new Double(Pentagram2.F1(AA));
	g.drawString("F1:",5,120);
	g.drawString(f1.toString(),55,120);
	String[] S={"1+a-b","1+c-d","ac+bd-a+d","ac+bd+b-c","abcd"};
	
	g.setFont(new Font("Helvetica",Font.PLAIN,12));
	g.setColor(Color.blue);
	double[] h=Pentagram2.FF1(AA);
	for(int i=0;i<5;++i) {
	    Double D=new Double(h[i]);
	    if(i==4) g.setColor(new Color(200,0,0));
	    g.drawString(D.toString(),155,140+20*i);
	    g.drawString(S[i],55,140+20*i);
	}
	    
    }




    public void drawInvariant2(Graphics2D g,double[] AA) {
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,16));
	Double f1=new Double(Pentagram2.F2(AA));
	g.drawString("F2:",5,250);
	g.drawString(f1.toString(),55,250);

	String[] S={"1-a+b","1-c+d","ac+bd+a-d","ac+bd-b+c","abcd"};
	g.setFont(new Font("Helvetica",Font.PLAIN,12));
	
	g.setColor(Color.blue);
	double[] h=Pentagram2.FF2(AA);
	for(int i=0;i<5;++i) {
	    Double D=new Double(h[i]);
	    if(i==4) g.setColor(new Color(200,0,0));
	    g.drawString(D.toString(),155,270+20*i);
	    g.drawString(S[i],55,270+20*i);
	}
	    
    }


	public void drawInvariant3(Graphics2D g,double[] AA) {

	g.setFont(new Font("Helvetica",Font.PLAIN,15));

	double f1=Pentagram2.F1(AA);
	double f2=Pentagram2.F2(AA);
	Double G=new Double(f2-f1);
	g.setColor(Color.black);
	g.drawString("G:",5,380);
	g.drawString(G.toString(),55,380);
	g.setColor(Color.blue);
	g.setFont(new Font("Helvetica",Font.PLAIN,12));

	double insc=AA[0]-AA[1]+AA[2]-AA[3];
	double circ=(1-AA[0]*AA[0]-AA[1]*AA[1])/(AA[0]*AA[1])+(1-AA[2]*AA[2]-AA[3]*AA[3])/(AA[2]*AA[3]);
	Double I=new Double(insc);
	Double J=new Double(circ);
	String[] S={"a-b+c-d","(1-aa-bb)/(ab)+(1-cc-dd)/(cd)"};
	
	g.drawString(S[0],55,400);
	g.drawString(S[1],55,420);
	g.drawString(I.toString(),235,400);
	g.drawString(J.toString(),235,420);
	}



    


    public static void drawConvex(Graphics2D g,PolyVector P) {
	g.setColor(Color.black);
	g.setFont(new Font("Helvetica",Font.PLAIN,15));
	boolean test=P.isConvex();
        if(test==true) {
	  g.drawString("convex",10,480);
	}
    }


}
