import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;

/*This class does the basic arithmetic
  of vectors */


public class Vector {
    double[] x=new double[3];
    public Vector(){}

    public Vector(Complex z) {
	x[0]=z.x;
	x[1]=z.y;
	x[2]=1.0;
    }

    public Vector(double xx,double yy) {
	x[0]=xx;
	x[1]=yy;
	x[2]=1.0;
    }

    public Vector(double xx,double yy,double zz) {
	x[0]=xx;
	x[1]=yy;
	x[2]=zz;
    }

    public Vector(Vector X) {
	x[0]=X.x[0];
	x[1]=X.x[1];
	x[2]=X.x[2];
    }

    public static Vector add(Vector V1,Vector V2) {
	Vector W=new Vector();
	for(int i=0;i<3;++i) W.x[i]=V1.x[i]+V2.x[i];
	return(W);
    }

    public Vector scale(double d) {
	return scale(d,this);
    }

    public static Vector scale(double t,Vector V) {
	Vector W=new Vector();
	for(int i=0;i<3;++i) W.x[i]=t*V.x[i];
	return(W);
    }


    public static double  dot(Vector v,Vector w) {
	return(v.x[0]*w.x[0]+v.x[1]*w.x[1]+v.x[2]*w.x[2]);
    }

    public double norm() {
	return(Math.sqrt(dot(this,this)));
    }

    public static Vector cross(Vector v,Vector w) {
	Vector X=new Vector();
	X.x[0]=v.x[1]*w.x[2]-w.x[1]*v.x[2];
	X.x[1]=v.x[2]*w.x[0]-w.x[2]*v.x[0];
	X.x[2]=v.x[0]*w.x[1]-w.x[0]*v.x[1];
	return(X);
    }

    public static Vector findCross(Vector v1,Vector v2,Vector w1,Vector w2) {
	Vector x1=cross(v1,v2);
	Vector x2=cross(w1,w2);
	Vector y=cross(x1,x2);
	return y;
    }

    public void print() {
	System.out.println(x[0]+" "+x[1]+" "+x[2]);
    }

    public static double tripleProduct(Vector v1,Vector v2,Vector v3) {
	return(dot(cross(v1,v2),v3));
    }


    public Vector normalize() {
	Vector W=new Vector();
	W.x[0]=this.x[0]/this.x[2];
	W.x[1]=this.x[1]/this.x[2];
	W.x[2]=1;
	return(W);
    }

    //returns a normalized vector

    public Vector rotate(double d) {
	Vector V1=this.normalize();
	double c=Math.cos(d);
	double s=Math.sin(d);
	double x0=V1.x[0];
	double x1=V1.x[1];
	double y0= x0*c+x1*s;
	double y1=-x0*s+x1*c;
	V1.x[0]=y0;
	V1.x[1]=y1;
	V1.x[2]=1.0;
	return(V1);
    }

}


