import java.applet.Applet;
import java.awt.event.*;
import java.awt.*;


public class XInvariants {
    double x,y;
    
    public XInvariants() {}

    //vectors should be normalized to have 3rd coordinate equal to 1.

    public static double slope(Vector V1,Vector V2) {
        double s;
        s=(V2.x[1]-V1.x[1])/(V2.x[0]-V1.x[0]);
        return(s);
    }


    //inverse of usual cross ratio
    public static double cross0(double a,double b,double c,double d)
      {
      double x;
      x=(a-b)*(c-d)/((a-c)*(b-d));
      return(x);
      }


    public static double fan(Vector x,Vector a,Vector b,Vector c,Vector d) {
        double f=cross0(slope(x,a),slope(x,b),slope(x,c),slope(x,d));
        return(f);
    }



    // the local invariant
    public static double locinv(PolyVector P,int j,int ii) {
        int i;
	int n=P.n;
	PolyVector Q=P.rotate(Math.sqrt(2.0));   //a random rotation to avoid degeneracies
	int j1=(j-1*ii+n)%n;
	int j2=(j-2*ii+n)%n;
	int j3=(j-0*ii+n)%n;
	int j4=(j+1*ii+n)%n;
	int j5=(j+2*ii+n)%n;
	double ll=fan(Q.v[j1],Q.v[j2],Q.v[j3],Q.v[j4],Q.v[j5]);
        return(ll);
    }


    // the global invariants

    public static double[] invariant(PolyVector P) {
	double[] x=new double[P.n*2];

        for(int i=0;i<P.n;++i) {
             x[2*i-0]=locinv(P,i,-1);
             x[2*i+1]=locinv(P,i,1);
	}
	return(x);
    }

    public static double energy(PolyVector P) {
	double[] y=invariant(P);
	double t=1;
	for(int i=0;i<y.length;++i) t=t*y[i];
	return(t);
    }

    public static double[] productInvariant(PolyVector P) {
	double[] x=invariant(P);
	int n=2*P.n;
	double[] y=new double[n/2];
	int i1,i2,i3;
	for(int i=0;i<n;i=i+2) {
	    i2=(i+1+n)%n;
	    i3=(i-0+n)%n;
	    y[i/2]=x[i2]*x[i3];
	}
	return(y);
    }


    public static double conicInvariantProduct(PolyVector P) {
	double[] d=conicInvariant(P);
	return d[0]*d[2];
    }
    
    public static double conicInvariantDualProduct(PolyVector P) {
	double[] d=conicInvariantDual(P);
	return d[0]*d[2];
    }
    


    public static double[] conicInvariant1(PolyVector P) {
	double[] x=invariant(P);
	int n=2*P.n;
	double[] y=new double[n/2];
	int i1,i2,i3;
	for(int i=0;i<n;i=i+2) {
	    i1=(i+2+n)%n;
	    i2=(i+1+n)%n;
	    i3=(i+0+n)%n;
	    y[i/2]=(1-x[i1])*(x[i2])*(1-x[i3]);
	}
	return(y);
    }

    public static double[] conicInvariant2(PolyVector P) {
	double[] x=invariant(P);
	int n=2*P.n;
	double[] y=new double[n/2];
	int i1,i2,i3;
	for(int i=0;i<n;i=i+2) {
	    i1=(i+1+n)%n;
	    i2=(i+2+n)%n;
	    i3=(i+3+n)%n;
            y[i/2]=(1-x[i1])*(x[i2])*(1-x[i3]);
	}
	return(y);
    }

    public static double[] conicInvariant(PolyVector P) {
	double[] x1=conicInvariant1(P);
	double[] x2=conicInvariant2(P);
	double[] x=new double[P.n];
	for(int i=0;i<P.n;++i) {
	    x[i]=x2[i]-x1[i];
	}
    return(x);
    }


    public static double[] conicInvariantDual1(PolyVector P) {
	double[] x=invariant(P);
	int n=2*P.n;
	double[] y=new double[n/2];
	int i1,i2,i3;
	for(int i=0;i<n;i=i+2) {
	    i1=(i+3+n)%n;
	    i2=(i+2+n)%n;
	    i3=(i+1+n)%n;
	    y[i/2]=(1-x[i1])*(1-x[i2]*x[i3]);
	}
	return(y);
    }

    public static double[] conicInvariantDual2(PolyVector P) {
	double[] x=invariant(P);
	int n=2*P.n;
	double[] y=new double[n/2];
	int i1,i2,i3;
	for(int i=0;i<n;i=i+2) {
	    i1=(i+2+n)%n;
	    i2=(i+3+n)%n;
	    i3=(i+4+n)%n;
	    y[i/2]=(1-x[i1])*(1-x[i2]*x[i3]);
	}
	return(y);
    }

    public static double[] conicInvariantDual(PolyVector P) {
	double[] x1=conicInvariantDual1(P);
	double[] x2=conicInvariantDual2(P);
	double[] x=new double[P.n];
	for(int i=0;i<P.n;++i) {
	    x[i]=x2[i]-x1[i];
	}
    return(x);
    }


    public static boolean isInscribed(PolyVector P) {
	double[] a=conicInvariant(P);
	for(int i=0;i<P.n;++i) {
	    if(Math.abs(a[i])>.000000001) return(false);
                   if(Double.isNaN(a[i])==true) return(false);
	}
	return(true);
    }

    public static boolean isCircumscribed(PolyVector P) {
	double[] a=conicInvariantDual(P);
	for(int i=0;i<P.n;++i) {
	    if(Math.abs(a[i])>.000000001) return(false);   
            if(Double.isNaN(a[i])==true) return(false);
	}
	return(true);
    }




    /**some special cases*/
    
    public static double invariantSpecial(PolyVector P) {
	double[] a={P.v[1].x[0],P.v[1].x[1],P.v[3].x[1],-P.v[3].x[0]};
	double b1=(1-a[0]*a[0]-a[1]*a[1])/(a[0]*a[1]);
	double b2=(1-a[2]*a[2]-a[3]*a[3])/(a[2]*a[3]);
	double b=b1+b2;
	return b;
    }
    public static double O1(PolyVector P) {
	double[] x=XInvariants.invariant(P);
	x=rotate(x);
	return E1(x);
    }

    public static double E1(PolyVector P) {
	double[] x=XInvariants.invariant(P);
	return E1(x);
    }

    public static double E1(double[] x) {
	double e=0;
	for(int i=0;i<8;++i) e=e-x[2*i];
	for(int i=0;i<7;++i) e=e+x[2*i]*x[2*i+1]*x[2*i+2];
	e=e+x[14]*x[15]*x[0];
	return e;
    }
    

    public static double[] rotate(double[] a) {
	double[] b=new double[16];
	for(int i=0;i<16;++i) {
	    int j=(i+1)%16;
	    b[i]=a[j];
	}
	return b;
    }



    
}


