(*This file does the concavity calculations for the last section in Chapter 5.
 We are calculating the Hessian and printing out the result*)

X1 = {((1 + c - d)*(-(a*b^2) + a*c - a^3*c + a*b^2*c - a*c^2 + a^3*c^2 - 
        2*a*b^2*d + 2*b^3*d - c*d + a^2*c*d - b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((1 + c - d)*(-(a^2*b) - 2*a^3*c + 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 - 
        b*d - a^2*b*d + b^3*d + c*d + a^2*c*d + 2*a^2*b*c*d - b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((1 + a - b)*(-(a*b) + a*c - a^2*c + a*b*c^2 - a*c^3 + a^2*c^3 - 
        a*b*d^2 - c*d^2 + a*c*d^2 - 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 + 
        2*b*d^3 + 2*b^2*d^3))/(a*b*d), 
     ((1 + a - b)*(a*b + a*b*c^2 - 2*a*c^3 + 2*a^2*c^3 - b*d - b^2*d - 
        c^2*d + 2*a*c^2*d - a^2*c^2*d - b*c^2*d + 2*a*b*c^2*d - a*b*d^2 + 
        b*d^3 + b^2*d^3))/(a*b*c)}
 
X2 = {((-1 + c - d)*(-(a*b^2) - a*c + a^3*c - a*b^2*c - a*c^2 + a^3*c^2 + 
        2*a*b^2*d - 2*b^3*d + c*d - a^2*c*d + b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((-1 + c - d)*(-(a^2*b) + 2*a^3*c - 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 + 
        b*d + a^2*b*d - b^3*d - c*d - a^2*c*d + 2*a^2*b*c*d + b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((-1 + a - b)*(a*b - a*c - a^2*c - a*b*c^2 + a*c^3 + a^2*c^3 + a*b*d^2 - 
        c*d^2 - a*c*d^2 + 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 - 2*b*d^3 + 
        2*b^2*d^3))/(a*b*d), 
     -(((1 - a + b)*(-(a*b) - a*b*c^2 + 2*a*c^3 + 2*a^2*c^3 + b*d - b^2*d - 
         c^2*d - 2*a*c^2*d - a^2*c^2*d + b*c^2*d + 2*a*b*c^2*d + a*b*d^2 - 
         b*d^3 + b^2*d^3))/(a*b*c))}


GRAD[f_]:={D[f,a],D[f,b],D[f,c],D[f,d]};

(*Here is the Y vector field*)
alpha1 = 1 + c - d;
alpha2 = 1 - c + d;
Y= alpha1 X1 + alpha2 X2;

(*Here is the defining function*)
phi=a+b-1;


Print["Check that the Y vector field is tangent to the surface phi=1"];
Print[Factor[Y.GRAD[phi]//.{b->1-a}]];

(*Now we are computing the Hessian*)
X={X1,X2};    
Q[i_,j_]:=Factor[X[[i]].GRAD[X[[j]].GRAD[phi]]/.{b->1-a}];
alpha={alpha1,alpha2};
	     
Print["expression for hessian evaluated on (alpha1,alpha2) when b=1-a"];
hess=Sum[Sum[Q[i,j] alpha[[i]] alpha[[j]],{i,1,2}],{j,1,2}]

Print[Factor[hess]]
