(*This map verifies that our formula for iota3 = A delta A is correct*)


Clear[a,b,c,d,P,P1,P2,P3,P4,ToPlane,ToAffinePatch,MAT,A,delta,MAP,NewPoint];



(**Some general formulas*)

(*put into the affine patch of the projective plane*)
ToAffinePatch[x_]:=Append[x,1];

(*Map Affine patch back to R2*)
ToPlane[x_]:=Simplify[{x[[1]]/x[[3]],x[[2]]/x[[3]]}];

(*Modular arithmetic. Fixing Mathematica's stupid convention*)
MOD[k_,n_]:=If[Mod[k,n]==0,n,Mod[k,n]];

(*Done with the general formulas*)





(*The geometric version of the map described in the paper*)

P={{1,0},{a,b},{0,1},{-d,c},{-1,0},{-a,-b},{0,-1},{d,-c}};
P1=Table[ToAffinePatch[P[[j]]],{j,1,8}];

(*Intersects the diagonals*)
CrossingPointGeneral[A1_,A2_]:=Cross[A1,A2];
CrossingPoint[a_,b_]:=CrossingPointGeneral[P1[[a]],P1[[b]]];

(*this gets the points v0',v1',... except that v0' is P2[[1]] and v1' is P2[[2]], etc.*)

shift=0;P2=Table[CrossingPoint[MOD[k+shift,8],MOD[k+shift+1,8]],{k,1,8}];
(* here is the list of points before normalization*)
P3=Table[ToPlane[P2[[j]]],{j,1,8}];

(*Now we normalize. this gets the points v0',v1',... except that v0' is P2[[1]] and v1' is P2[[2]], etc.*)

MAT=Transpose[Inverse[{P3[[1]],P3[[3]]}]];
P4=Factor[Table[MAT.P3[[j]],{j,1,8}]];

(*Here is the new point (a',b',c',d')*)
NewPoint={P4[[2,1]],P4[[2,2]],P4[[4,2]],-P4[[4,1]]}

  Print[NewPoint];


(*Now we compare this to A delta A*)

(*First we repeat a few things from the main file*)

A[{a_,b_,c_,d_}]:={-b,-a,-d,-c};
 
delta[{a_, b_, c_, d_}] := {(b*(1 + c + d))/(c*(1 + a + c + a*c + b*d)), 
     (d*(b + c + a*c + b*d))/(c*(1 + a + c + a*c + b*d)), 
     ((1 + a + b)*d)/(a*(1 + a + c + a*c + b*d)), (b*(a + a*c + d + b*d))/
			    
      (a*(1 + a + c + a*c + b*d))}
 I0[{a_,b_,c_,d_}]:={c,d,a,b};
  J0[{a_,b_,c_,d_}]:={b,a,d,c};


 
 Print[A[delta[A[I0[J0[{a,b,c,d}]]]]]]
