
(*This file does the calcs for the 9 cases of the Non Vanishing Lemma from Ch 3*)
<<verify_resultant.m






Print["Cases 1 and 2:"];
Print[phi1];

Clear[a,b,c,d,p,NF,DF];

NF[p_]:=Numerator[Factor[p]];
DF[p_]:=Denominator[Factor[p]];
Clear[a,b,c,d];

gr2=X2.GRAD[phi1];
b=1;
gr2=Factor[gr2];

Print["here is where X2.grad(phi1) vanishes"];
  Print[Solve[gr2==0,a]];

  (*This is the only solution to gr2=0 for a*)
  a=(1+c-d)/2/c

    Print["here are the two nontrivial resultants"]
res1=Resultant[NF[f/g],DF[f/g],c];
res2=Resultant[NF[f/g],DF[f/g],d];
Print[res1];
Print[res2];




	     Print[""];
	     Print[""];



Clear[a,b,c,d];
Print["Case 3:"];
Print[phi1];

gr=XG.GRAD[phi3];
c=b;
gr=Factor[gr];

Print["These values should be 0"];
Print[Solve[gr==0,a]];
Print[Factor[G[{a,b,b,a}]]];
Print[Factor[G[{a,b,b,-a}]]];






	     Print[""];
	     Print[""];


Clear[a,b,c,d];
Print["Case 4"];
Print[phi4];

gr=XG.GRAD[phi4];
d=b;
gr=Factor[gr];

Print["here is where the XG.grad(phi4) can vanish"];
  Print[Solve[gr==0,a]];


(*the case a=(1-b)/c leads to a point with G=0*)
Print["this case should be 0"];

Print[Factor[G[{a,b,c,d}]//.{a->(1-b b)/c}]]

(*The only case possible is a=b-c*)
a=b-c;
	     
 Print["Here are the resultants we get when a=b-c"];
 res1=Resultant[NF[f/g],DF[f/g],c];
 res2=Resultant[NF[f/g],DF[f/g],b];
 Print[res1];
 Print[res2];




	     

	     Print[""];
	     Print[""];
Clear[a,b,c,d];
Print["Case 5"];
Print[phi5];
	    
d=-c;
Print["here is what the g function looks like when d=-c"];
Print[Factor[g]];
(*The only way to get g=0 is to take b=-a*)
b=-a;
Print["to get this to vanish in our space we need b=-a"];

Print["Here we are computing the Plucker determinant function f_13"]
zeta=Factor[(1/2) a a a c c c (X1[[1]] X2[[3]] - X1[[3]] X2[[1]])];
Print[zeta];
Print["here is where this function vanishes"];
Print[Solve[zeta==0,a]]

Print["the case c=a gives the point {a,a,a,a}"];
(*the 3 nontrivial cases for the choices of a.  We leave off the trivial case a=c.*)
	     Print["one case gives a point in the dependence set Y"];
Print[{a c + d b +1, a a c + a c c + b d d + b b d}/.{a->-1/2/c}];
	     Print["another case has F1 vanishing"];
Print[Factor[F1[{a,b,c,d}]/.{a->c/(2 c-1)}]];
	     Print["another case has F2 vanishing"];
Print[Factor[F2[{a,b,c,d}]/.{a->-c/(2 c+1)}]];





	     Print[""];
	     Print[""];
Clear[a,b,c,d];
Print["Case 6"];
Print[phi6];
	    
	     
gr=XG.GRAD[phi6];
b=(c c - c d)/(c+d);

gr=Factor[gr];
	     Print["here is XG.Grad[phi6] when phi6=0"];
	     Print[gr];
	     Print["here is where this vanishes"];
  Print[Solve[gr==0,a]];

(*first case*)
	     Print["first case leads to a point where the invariant G vanishes:"];
Print[Factor[G[{a,b,c,d}]/.{a->(d d - c d)/(c+d)}]]

(*second case*)
	     Print["Here are the resultants in the second case"];
a=(-2 c - c c d + d d d)/(c+d)/(c+d);
res1=Resultant[NF[f/g],DF[f/g],c];
res2=Resultant[NF[f/g],DF[f/g],d];
Print[res1];
Print[res2];






	     Print[""];
	     Print[""];	     
Clear[a,b,c,d];
	     Print["cases 7 and 8"];
	     Print[phi7];

gr=X2.GRAD[phi7];
b=c (1+c+d)/(1+c-d);
	     Print["here is X2.grad[phi7]"];
Print[Factor[gr]];
	     Print["here is where this vanishes"];
sol=Solve[gr==0,a]
  Print[sol];

	     Print["the double root leads to a point where F2=0"];
Print[Factor[F2[{a,b,c,d}]//.{a->sol[[1,1,2]]}]]

	     ff=NF[f/g];
	     gg=DF[f/g];

	     Print["here are the resultants in the other case"];
Print[Resultant[ff,gg,c]]
Print[Resultant[ff,gg,d]];






	     Print[""];
	     Print[""];	     
	     Clear[a,b,c,d];
	     Print["case 9"];
	     Print[phi9];

Print["here is where this vanishes"];
sol1=Solve[phi9==0,c];
	     Print[sol1];
	     Print["this is a messy quadratic but the sum and products of the roots is nice."];

c1=sol1[[1,1,2]];
c2=sol1[[2,1,2]];

Print[Factor[c1+c2]];
Print[Simplify[c1 c2]];

		   Print["done"];
