(*This file derives the equation for the map we call sqrtI in the paper*)

(*do the rotation*)

P={{1,0},{a,b},{0,1},{-d,c},{-1,0},{-a,-b},{0,-1},{d,-c}};
P3=RotateLeft[P,1];

MAT=Transpose[Inverse[{P3[[1]],P3[[3]]}]];
P4=Table[MAT.P3[[j]],{j,1,8}];

(*Here is the new point (a',b',c',d')*)
NewPoint={P4[[2,1]],P4[[2,2]],P4[[4,2]],-P4[[4,1]]};

(*Done getting the geometric version of the map. It is {a,b,c,d} --> NewPoint*)
Print[NewPoint];
