

(*This file has many of the important formulas used in the paper.
 It sometimes has to be loaded into Mathematica before the other
 files can run*)

(*table of contents:*)

(*map definitions*)
(*map symmetries*)
(*invariants: F1,F2,G*)
(*gradient formulas*)
(*Hamiltonian vector field formulas for X1,X2,XG*)





(*We clear the variables we use*)
Clear[F1,F2,G,a,b,c,d,A,delta,sqrtI0,I0,J0,T3,MAP,MAP2,GRAD1,GRAD2,INV1,INV1B,INV2,Z];





(*map definitions*)

(*Here is the square root of the map T3*)
MAP[p_]:=A[delta[p]];

(*And here is T3 itself*)
T3[p_]:=MAP[MAP[p]];

A[{a_,b_,c_,d_}]:={-b,-a,-d,-c};
 
delta[{a_, b_, c_, d_}] := {(b*(1 + c + d))/(c*(1 + a + c + a*c + b*d)), 
     (d*(b + c + a*c + b*d))/(c*(1 + a + c + a*c + b*d)), 
     ((1 + a + b)*d)/(a*(1 + a + c + a*c + b*d)), (b*(a + a*c + d + b*d))/
      (a*(1 + a + c + a*c + b*d))}

iota3[p_]:=A[delta[A[p]]];

 iota5[p_]:=A[delta[A[delta[A[p]]]]];

  (*end map definitions*)





  

  (*map symmetries. These are sqrtI and I and J in the paper.*)

  sqrtI0[{a_,b_,c_,d_}]:={d,a,b,c}/(a c  + b d)
  I0[{a_,b_,c_,d_}]:={c,d,a,b};
  J0[{a_,b_,c_,d_}]:={b,a,d,c};

(*End of symmetries*)






  
  (* The invariants*)
  
(*this is g*)
g1[a_,b_]:=(1-a a - b b)/a/b;
g1[{a_,b_,c_,d_}]:=g1[a,b]+g1[c,d];

(*This is g dual*)
g2[a_,b_]:=a-b;
g2[{a_,b_,c_,d_}]:=g2[a,b]+g2[c,d];

G[{a_,b_,c_,d_}]:=2 (g1[a,b] + g1[c,d])(g2[a,b]+g2[c,d])
F1[{a_,b_,c_,d_}]:=(1+a-b) (1+c -d) (b-c+a c + d b) (d -a + a c + d b)/a/b/c/d;
F2[{a_,b_,c_,d_}]:=F1[{b,a,d,c}];

(* End invariants*)







(*Here are the gradient the symplectic gradient*)

GRAD[f_]:={D[f,a],D[f,b],D[f,c],D[f,d]}
HAM[f_]:=(gr=GRAD[f];{-a b gr[[2]], a b gr[[1]], -c d gr[[4]],c d gr[[3]]})

  (*end gradient and symplectic gradient*)




  

  
  (* Hamiltonian vector fields*)

X1 = {((1 + c - d)*(-(a*b^2) + a*c - a^3*c + a*b^2*c - a*c^2 + a^3*c^2 - 
        2*a*b^2*d + 2*b^3*d - c*d + a^2*c*d - b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((1 + c - d)*(-(a^2*b) - 2*a^3*c + 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 - 
        b*d - a^2*b*d + b^3*d + c*d + a^2*c*d + 2*a^2*b*c*d - b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((1 + a - b)*(-(a*b) + a*c - a^2*c + a*b*c^2 - a*c^3 + a^2*c^3 - 
        a*b*d^2 - c*d^2 + a*c*d^2 - 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 + 
        2*b*d^3 + 2*b^2*d^3))/(a*b*d), 
     ((1 + a - b)*(a*b + a*b*c^2 - 2*a*c^3 + 2*a^2*c^3 - b*d - b^2*d - 
        c^2*d + 2*a*c^2*d - a^2*c^2*d - b*c^2*d + 2*a*b*c^2*d - a*b*d^2 + 
        b*d^3 + b^2*d^3))/(a*b*c)}
 
X2 = {((-1 + c - d)*(-(a*b^2) - a*c + a^3*c - a*b^2*c - a*c^2 + a^3*c^2 + 
        2*a*b^2*d - 2*b^3*d + c*d - a^2*c*d + b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((-1 + c - d)*(-(a^2*b) + 2*a^3*c - 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 + 
        b*d + a^2*b*d - b^3*d - c*d - a^2*c*d + 2*a^2*b*c*d + b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((-1 + a - b)*(a*b - a*c - a^2*c - a*b*c^2 + a*c^3 + a^2*c^3 + a*b*d^2 - 
        c*d^2 - a*c*d^2 + 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 - 2*b*d^3 + 
        2*b^2*d^3))/(a*b*d), 
     -(((1 - a + b)*(-(a*b) - a*b*c^2 + 2*a*c^3 + 2*a^2*c^3 + b*d - b^2*d - 
         c^2*d - 2*a*c^2*d - a^2*c^2*d + b*c^2*d + 2*a*b*c^2*d + a*b*d^2 - 
         b*d^3 + b^2*d^3))/(a*b*c))}
 
XG = {-(a*b*(2*(-2/a - (1 - a^2 - b^2)/(a*b^2))*(a - b + c - d) - 
        2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d)))), 
     a*b*(2*(-2/b - (1 - a^2 - b^2)/(a^2*b))*(a - b + c - d) + 
       2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d))), 
     -(c*d*(2*(a - b + c - d)*(-2/c - (1 - c^2 - d^2)/(c*d^2)) - 
        2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d)))), 
     c*d*(2*(a - b + c - d)*(-2/d - (1 - c^2 - d^2)/(c^2*d)) + 
       2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d)))}

  (*end Hamiltonian vector fields*)



  
