(*This file checks the symmetries and the invariance of
 F1 and F2 under T3.*)

  






(*map definitions*)

(*Here is the square root of the map T3*)
MAP[p_]:=A[delta[p]];

(*And here is T3 itself*)
T3[p_]:=MAP[MAP[p]];

A[{a_,b_,c_,d_}]:={-b,-a,-d,-c};
 
delta[{a_, b_, c_, d_}] := {(b*(1 + c + d))/(c*(1 + a + c + a*c + b*d)), 
     (d*(b + c + a*c + b*d))/(c*(1 + a + c + a*c + b*d)), 
     ((1 + a + b)*d)/(a*(1 + a + c + a*c + b*d)), (b*(a + a*c + d + b*d))/
      (a*(1 + a + c + a*c + b*d))}

iota3[p_]:=A[delta[A[p]]];

 iota5[p_]:=A[delta[A[delta[A[p]]]]];

  (*end map definitions*)





  

  (*map symmetries. These are sqrtI and I and J in the paper.*)

  sqrtI0[{a_,b_,c_,d_}]:={d,a,b,c}/(a c  + b d)
  I0[{a_,b_,c_,d_}]:={c,d,a,b};
  J0[{a_,b_,c_,d_}]:={b,a,d,c};

(*End of symmetries*)






  
  (* The invariants*)
  
(*this is g*)
g1[a_,b_]:=(1-a a - b b)/a/b;
g1[{a_,b_,c_,d_}]:=g1[a,b]+g1[c,d];

(*This is g dual*)
g2[a_,b_]:=a-b;
g2[{a_,b_,c_,d_}]:=g2[a,b]+g2[c,d];

G[{a_,b_,c_,d_}]:=2 (g1[a,b] + g1[c,d])(g2[a,b]+g2[c,d])
F1[{a_,b_,c_,d_}]:=(1+a-b) (1+c -d) (b-c+a c + d b) (d -a + a c + d b)/a/b/c/d;
F2[{a_,b_,c_,d_}]:=F1[{b,a,d,c}];

(* End invariants*)




















RandomRational[]:=Floor[1000000 Random[]]/1000000;
ran=Table[RandomRational[],{4}];


(*Symmetry checks*)
Print["symmetry checks"];

p1=I0[A[delta[I0[ran]]]];
p2=A[delta[ran]];
Print[p1/p2]

p3=J0[T3[J0[ran]]];
p4=I0[T3[ran]];
Print[p3/p4]

Print["checking that F1 and F2 are invariant under T3 and Delta"];

(*invariance checks*)
p5=F1[ran];
p6=F1[T3[ran]];
Print[p5/p6]

p7=F2[ran];
p8=F2[T3[ran]];
Print[p7/p8]

p7=F2[ran];
p8=F2[delta[ran]];
Print[p7/p8]

p7=F1[ran];
p8=F1[delta[ran]];
Print[p7/p8]


Print["how the invariants interact with the map sqrt I from the paper"];

p7=F1[ran];
p8=F1[sqrtI0[ran]];
Print[p7/p8]

p7=F2[ran];
p8=F2[sqrtI0[ran]];
Print[p7/p8]

p7=G[ran];
p8=G[sqrtI0[ran]];
Print[p7/p8]


(*These values should  negative*)

p7=g1[ran];
p8=g1[sqrtI0[ran]];
Print[Sign[p7/p8]]

p7=g2[ran];
p8=g2[sqrtI0[ran]];
Print[Sign[p7/p8]]


Print["how the invariants interact with the map J from the paper"];

p7=F1[ran];
p8=F2[J0[ran]];
Print[p7/p8]

p7=F2[ran];
p8=F1[J0[ran]];
Print[p7/p8]

p7=G[ran];
p8=G[J0[ran]];
Print[p7/p8]


(*These values should  negative*)

p7=g1[ran];
p8=g1[J0[ran]];
Print[Sign[p7/p8]]

p7=g2[ran];
p8=g2[J0[ran]];
Print[Sign[p7/p8]]
