(*This file verifies the claims about the set Y in Section 2.6.*)

Clear[a,b,c,d,Y];

F1[{a_,b_,c_,d_}]:=(1+a-b) (1+c -d) (b-c+a c + d b) (d -a + a c + d b)/a/b/c/d;
F2[{a_,b_,c_,d_}]:=F1[{b,a,d,c}];






Y[x1_,x2_]:=512 + 216 x1 x2 + 192 (x1+x2) - 30 Power[x1+x2,2] + Power[x1+x2,3];



(*Here is the numerator of polynomial Y(F1,F2)*)
y0=Factor[Y[F1[{a,b,c,d}],F2[{a,b,c,d}]] Power[a b c d,3]/8];

  
Print["factor y0 upon upon when d solves a c + b d =1"]
Print[Factor[y0//.{d->(-1-a c)/b}]]
	     
(*Here we are solving a c + b d +1=0 for d and making the substitution*)
y1=Factor[Power[b,6] y0//.{d->(-1-a c)/b}];
	  
y11=y1[[1]];
y2=Factor[b (a c c + a a c + b d d + b b d)//.{d->(-1-a c)/b}];

	  Print["the factor of interest to us"];
	  Print[y11];

	  Print["This is the same as the square of..."];
	  Print[y2];


