(*This file checks the gradient formulas in Lemma 2.3*)




(*Here are the gradient the symplectic gradient*)

GRAD[f_]:={D[f,a],D[f,b],D[f,c],D[f,d]}
HAM[f_]:=(gr=GRAD[f];{-a b gr[[2]], a b gr[[1]], -c d gr[[4]],c d gr[[3]]})

  (*end gradient and symplectic gradient*)


  
  (* Hamiltonian vector fields*)

X1 = {((1 + c - d)*(-(a*b^2) + a*c - a^3*c + a*b^2*c - a*c^2 + a^3*c^2 - 
        2*a*b^2*d + 2*b^3*d - c*d + a^2*c*d - b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((1 + c - d)*(-(a^2*b) - 2*a^3*c + 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 - 
        b*d - a^2*b*d + b^3*d + c*d + a^2*c*d + 2*a^2*b*c*d - b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((1 + a - b)*(-(a*b) + a*c - a^2*c + a*b*c^2 - a*c^3 + a^2*c^3 - 
        a*b*d^2 - c*d^2 + a*c*d^2 - 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 + 
        2*b*d^3 + 2*b^2*d^3))/(a*b*d), 
     ((1 + a - b)*(a*b + a*b*c^2 - 2*a*c^3 + 2*a^2*c^3 - b*d - b^2*d - 
        c^2*d + 2*a*c^2*d - a^2*c^2*d - b*c^2*d + 2*a*b*c^2*d - a*b*d^2 + 
        b*d^3 + b^2*d^3))/(a*b*c)}
 
X2 = {((-1 + c - d)*(-(a*b^2) - a*c + a^3*c - a*b^2*c - a*c^2 + a^3*c^2 + 
        2*a*b^2*d - 2*b^3*d + c*d - a^2*c*d + b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((-1 + c - d)*(-(a^2*b) + 2*a^3*c - 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 + 
        b*d + a^2*b*d - b^3*d - c*d - a^2*c*d + 2*a^2*b*c*d + b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((-1 + a - b)*(a*b - a*c - a^2*c - a*b*c^2 + a*c^3 + a^2*c^3 + a*b*d^2 - 
        c*d^2 - a*c*d^2 + 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 - 2*b*d^3 + 
        2*b^2*d^3))/(a*b*d), 
     -(((1 - a + b)*(-(a*b) - a*b*c^2 + 2*a*c^3 + 2*a^2*c^3 + b*d - b^2*d - 
         c^2*d - 2*a*c^2*d - a^2*c^2*d + b*c^2*d + 2*a*b*c^2*d + a*b*d^2 - 
         b*d^3 + b^2*d^3))/(a*b*c))}
 
XG = {-(a*b*(2*(-2/a - (1 - a^2 - b^2)/(a*b^2))*(a - b + c - d) - 
        2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d)))), 
     a*b*(2*(-2/b - (1 - a^2 - b^2)/(a^2*b))*(a - b + c - d) + 
       2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d))), 
     -(c*d*(2*(a - b + c - d)*(-2/c - (1 - c^2 - d^2)/(c*d^2)) - 
        2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d)))), 
     c*d*(2*(a - b + c - d)*(-2/d - (1 - c^2 - d^2)/(c^2*d)) + 
       2*((1 - a^2 - b^2)/(a*b) + (1 - c^2 - d^2)/(c*d)))}





(*We check that our stored values for the Hamiltonian vector fields agree with*)
(*the ones computed from the formula for the Hamiltonian gradient*)
Print["everything should be {0,0,0,0} here."];
    Print[Simplify[XG-HAM[G[{a,b,c,d}]]]]
    Print[Simplify[X1-HAM[F1[{a,b,c,d}]]]]
    Print[Simplify[X2-HAM[F2[{a,b,c,d}]]]]

