(*This verifies the factorization of the resultant h from Chapter 3.*)
 (*We also store the 9 functions from chapter 3*)

Clear[mu,alpha,beta,a,b,c,d,f,g,h];







  
  (* Hamiltonian vector fields*)

X1 = {((1 + c - d)*(-(a*b^2) + a*c - a^3*c + a*b^2*c - a*c^2 + a^3*c^2 - 
        2*a*b^2*d + 2*b^3*d - c*d + a^2*c*d - b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((1 + c - d)*(-(a^2*b) - 2*a^3*c + 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 - 
        b*d - a^2*b*d + b^3*d + c*d + a^2*c*d + 2*a^2*b*c*d - b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((1 + a - b)*(-(a*b) + a*c - a^2*c + a*b*c^2 - a*c^3 + a^2*c^3 - 
        a*b*d^2 - c*d^2 + a*c*d^2 - 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 + 
        2*b*d^3 + 2*b^2*d^3))/(a*b*d), 
     ((1 + a - b)*(a*b + a*b*c^2 - 2*a*c^3 + 2*a^2*c^3 - b*d - b^2*d - 
        c^2*d + 2*a*c^2*d - a^2*c^2*d - b*c^2*d + 2*a*b*c^2*d - a*b*d^2 + 
        b*d^3 + b^2*d^3))/(a*b*c)}
 
X2 = {((-1 + c - d)*(-(a*b^2) - a*c + a^3*c - a*b^2*c - a*c^2 + a^3*c^2 + 
        2*a*b^2*d - 2*b^3*d + c*d - a^2*c*d + b^2*c*d + 2*a*b^2*c*d - 
        a*b^2*d^2 + 2*b^3*d^2))/(b*c*d), 
     ((-1 + c - d)*(-(a^2*b) + 2*a^3*c - 2*a^2*b*c + 2*a^3*c^2 - a^2*b*c^2 + 
        b*d + a^2*b*d - b^3*d - c*d - a^2*c*d + 2*a^2*b*c*d + b^2*c*d - 
        b*d^2 + b^3*d^2))/(a*c*d), 
     ((-1 + a - b)*(a*b - a*c - a^2*c - a*b*c^2 + a*c^3 + a^2*c^3 + a*b*d^2 - 
        c*d^2 - a*c*d^2 + 2*b*c*d^2 + 2*a*b*c*d^2 - b^2*c*d^2 - 2*b*d^3 + 
        2*b^2*d^3))/(a*b*d), 
     -(((1 - a + b)*(-(a*b) - a*b*c^2 + 2*a*c^3 + 2*a^2*c^3 + b*d - b^2*d - 
         c^2*d - 2*a*c^2*d - a^2*c^2*d + b*c^2*d + 2*a*b*c^2*d + a*b*d^2 - 
         b*d^3 + b^2*d^3))/(a*b*c))}














  (*alpha=a b (c+d)/(a - b + 1)/(b - a +1);beta= c d (a+b)/(c - d + 1)/(d - c +1);*)

alpha=a b (c+d) (c - d + 1) (d - c +1);
beta= c d (a+b) (a - b + 1) (b - a +1);

mu={alpha,-alpha,-beta,beta}

  div=(1-a+b) (1+a-b) (1-c+d) (1-d+c);
f=Simplify[a b c c d d(X1[[1]] X2[[2]] - X1[[2]] X2[[1]])/2/div];
  g=Factor[a b c d X1.mu/div];
h=Factor[Power[b,-5] Power[c,-5] Power[d,-6] Resultant[f,g,a]];

phi1 = b-1;
phi2 = b+1;
phi3 = b-c;
phi4 = b-d;
phi5 = c+d;
phi6 = b c +  b d + c d - c c;
phi7 = +b - c + b c - b d - c d - c c;
phi8 = -b + c + b c - b d - c d - c c;
phi9 = 1 - c c + 2 b d + b b c d - b c c d + b b d d + b c d d;
phi9 = c (b d d + b b d) + (1+b d) (1+b d - c c);

hh=phi1 phi2 phi3 phi4 Power[phi5,2] phi6 Power[phi7,2] Power[phi8,2] phi9
  Print["Ratio should be 1"];
Factor[h/hh]
