(*This file works out the factorization of the map iota5 on
 the set (a,b,c,d) where a+b=1.  This is used in the
 Reversal Lemma II*)



(*Here is what we need from the main formulas file*)
A[{a_,b_,c_,d_}]:={-b,-a,-d,-c};
 
delta[{a_, b_, c_, d_}] := {(b*(1 + c + d))/(c*(1 + a + c + a*c + b*d)), 
     (d*(b + c + a*c + b*d))/(c*(1 + a + c + a*c + b*d)), 
     ((1 + a + b)*d)/(a*(1 + a + c + a*c + b*d)), (b*(a + a*c + d + b*d))/
      (a*(1 + a + c + a*c + b*d))}

 iota5[p_]:=A[delta[A[delta[A[p]]]]];








Print[" iota5 when b=1-a"];
Print[Factor[iota5[{a,1-a,b,c}]]];

mm=Factor[iota5[{a,b,c,d}]];

Print["Here are the 4 denominators of iota[a,b,c,d]"]

den=Table[Denominator[mm[[j]]],{j,1,4}];
Print[MatrixForm[den]];

Print["here is the big poly in the denominator"];

den1=den[[1]][[2]];
Print[den1];

(*We want to justify the expression for this big denom that we gave in the paper*)

aa=1-a;
bb=1-b;
cc=1-c;
dd=1-d;
match=a c aa cc + b d bb dd + a b c cc + a b d dd + c d a aa +c d b bb + 2 a b c d;

Print["this check should be 0"];
Print[Factor[den1-match]];

Print["not we want to solve for the situation where iota[a,b,c,d]=(0,*,*,0)"];
Print["we don't have to worry about the denoms. Here are the 1st and 4th numerator"];
mm1=Numerator[mm[[1]]];
Print[mm1];
mm4=-Numerator[mm[[4]]];
Print[mm4];

Print["the nontrivial factors we care about"];
mm13=mm1[[3]];
mm43=mm4[[3]];
Print[mm13];
Print[mm43];;

Print["setting them equal to 0 and solving"];
SOL=Solve[{mm13==0,mm43==0},{a,b}]
Print[SOL];
