(*This files does the main calculation that checks the invariance of the symplectic
 form.  The calculation is explained in Sect 2.4 of the paper*)

Clear[CHECK,P1,PSI,a,b,c,d,A,delta,A];
 
delta[{a_, b_, c_, d_}] := {(b*(1 + c + d))/(c*(1 + a + c + a*c + b*d)), 
     (d*(b + c + a*c + b*d))/(c*(1 + a + c + a*c + b*d)), 
     ((1 + a + b)*d)/(a*(1 + a + c + a*c + b*d)), (b*(a + a*c + d + b*d))/
			    (a*(1 + a + c + a*c + b*d))};

  (*end of the map definitions*)



  (* Here is the matrix of partials*)
  
  P1=delta[{a,b,c,d}];
  PSI= Transpose[{D[P1,a],D[P1,b],D[P1,c],D[P1,d]}];

   (*done with the matrix of partials*)


   CHECK[i_,j_]:=Simplify[(PSI[[1,i]] PSI[[2,j]] - PSI[[2,i]] PSI[[1,j]])/P1[[1]]/P1[[2]]+
			  (PSI[[3,i]] PSI[[4,j]] - PSI[[4,i]] PSI[[3,j]])/P1[[3]]/P1[[4]]];
   

Print["matrix of coeffs for pullback of symplectic form omega. Should equal omega"];

Print[MatrixForm[Table[Table[CHECK[i,j],{j,1,4}],{i,1,4}]]]

Print["done"];
